/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.computing;

import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.computing.CompNode;
import fr.pasteur.sysbio.rdfscape.computing.CompValueNode;
import fr.pasteur.sysbio.rdfscape.computing.EvaluationNode;
import fr.pasteur.sysbio.rdfscape.computing.PatternNode;
import fr.pasteur.sysbio.rdfscape.computing.builtinfunctions.PatternDataFunction;
import java.util.ArrayList;
import java.util.Hashtable;

public class FunctionNode
implements CompNode,
CompValueNode {
    String functionName = "";
    PatternNode patternNode = null;
    int indexInPatterns = 0;
    String[] myObjectPattern = null;
    PatternDataFunction myFunction = null;
    int[][] dataIndexBlock = null;
    double[] myAttributeValues = null;
    boolean isBuiltIn = false;
    boolean isCytoValue = false;
    boolean isFromSUM = false;

    @Override
    public String dump() {
        if (this.patternNode != null) {
            return this.functionName + "(" + this.patternNode.dump() + ")";
        }
        return "()";
    }

    public void SetPatternNode(PatternNode patternNode) {
        this.patternNode = patternNode;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    @Override
    public boolean collectPatterns(ArrayList arrayList) {
        this.myObjectPattern = this.patternNode.getPatternVariablesArray();
        System.out.print("F:" + this.myObjectPattern);
        if (!arrayList.contains(this.myObjectPattern)) {
            arrayList.add(this.myObjectPattern);
        }
        this.indexInPatterns = arrayList.indexOf(this.myObjectPattern);
        System.out.println(this.indexInPatterns);
        return true;
    }

    @Override
    public CompNode optimizeTree(EvaluationNode evaluationNode, CompNode compNode) {
        return this;
    }

    @Override
    public boolean computePartial(EvaluationNode evaluationNode, Hashtable hashtable, Hashtable hashtable2, ArrayList[] arrayListArray) {
        String[] stringArray;
        int n;
        System.out.print("Function " + this.functionName + " first pass ");
        ArrayList arrayList = arrayListArray[this.indexInPatterns];
        if (arrayList.size() == 0) {
            System.out.println("Empty matches should be rare...");
            return false;
        }
        if (arrayList.size() > 1 && !this.isFromSUM) {
            System.out.println("Need an aggregator for this function in this case...");
            return false;
        }
        if (evaluationNode.myFunctionManager.isBuiltInFunction(this.functionName)) {
            System.out.println("Found builtin");
            this.myFunction = evaluationNode.myFunctionManager.getFunction(this.functionName);
            if (this.myFunction != null) {
                System.out.println("Got function");
            }
            this.dataIndexBlock = new int[arrayList.size()][];
            n = this.myFunction.getCardinality();
            if (n != evaluationNode.otherPatterns[this.indexInPatterns].length) {
                System.out.println("Wrong cardinality for this function");
                return false;
            }
            System.out.print("My pattern: ");
            for (int i = 0; i < evaluationNode.otherPatterns[this.indexInPatterns].length; ++i) {
                System.out.print(evaluationNode.otherPatterns[this.indexInPatterns][i]);
            }
            System.out.println();
            stringArray = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.print("Pattern# " + i + " : ");
                stringArray = (String[])arrayList.get(i);
                int[] nArray = new int[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    System.out.print(stringArray[j] + " ");
                    if (hashtable.get(stringArray[j]) == null) {
                        System.out.println("Unable to find data for var: " + stringArray[j]);
                        return false;
                    }
                    nArray[j] = (Integer)hashtable.get(stringArray[j]);
                }
                this.dataIndexBlock[i] = nArray;
            }
            this.isBuiltIn = true;
        } else {
            System.out.println("Looking for an attribute");
            this.myAttributeValues = new double[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                Double d;
                System.out.print("Pattern# " + n + " : ");
                stringArray = (String[])arrayList.get(n);
                if (stringArray.length == 1) {
                    System.out.println(stringArray[0] + " !");
                    d = RDFScape.getCytoscapeDealer().getNumericAttributeValueByURI(stringArray[0], this.functionName);
                    if (d == null) {
                        System.out.println("Attribute not found!");
                        return false;
                    }
                    this.myAttributeValues[n] = d;
                    System.out.println("Value=" + this.myAttributeValues[n]);
                    continue;
                }
                if (stringArray.length == 2) {
                    System.out.println("Looking for an Edge atribute of type " + this.functionName + " for (" + stringArray[0] + "," + stringArray[1] + ")");
                    d = RDFScape.getCytoscapeDealer().getEdgeAttributeNumericValueByURI(stringArray[0], stringArray[1], this.functionName);
                    if (d == null) {
                        System.out.println("Attribute not found!");
                        return false;
                    }
                    this.myAttributeValues[n] = d;
                    System.out.println("Value=" + this.myAttributeValues[n]);
                    continue;
                }
                System.out.println("Hypernodes are not supported....");
                return false;
            }
            this.isCytoValue = true;
        }
        if (this.dataIndexBlock != null) {
            for (n = 0; n < this.dataIndexBlock.length; ++n) {
                for (int i = 0; i < this.dataIndexBlock[n].length; ++i) {
                    System.out.print(this.dataIndexBlock[n][i] + " ");
                }
                System.out.println();
            }
        }
        return true;
    }

    @Override
    public double computeTotal(double[][] dArray) {
        if (this.isCytoValue) {
            System.out.println("FunctionValue: " + this.myAttributeValues[0]);
            return this.myAttributeValues[0];
        }
        if (this.isBuiltIn) {
            double[] dArray2 = this.myFunction.evaluate(this.dataIndexBlock, dArray);
            return dArray2[0];
        }
        System.out.println("Panic!");
        return 0.0;
    }

    public double[] computeTotalVector(double[][] dArray) {
        if (this.isCytoValue) {
            return this.myAttributeValues;
        }
        if (this.isBuiltIn) {
            double[] dArray2 = this.myFunction.evaluate(this.dataIndexBlock, dArray);
            return dArray2;
        }
        System.out.println("Panic!");
        return new double[0];
    }

    public void setFromSUM(boolean bl) {
        this.isFromSUM = true;
    }
}

