/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.computing;

import fr.pasteur.sysbio.rdfscape.computing.CompNode;
import fr.pasteur.sysbio.rdfscape.computing.EvaluationNode;
import fr.pasteur.sysbio.rdfscape.computing.ExpNode;
import fr.pasteur.sysbio.rdfscape.computing.FactorNode;
import fr.pasteur.sysbio.rdfscape.computing.FunctionNode;
import fr.pasteur.sysbio.rdfscape.computing.NumNode;
import fr.pasteur.sysbio.rdfscape.computing.PatternNode;
import fr.pasteur.sysbio.rdfscape.computing.SumNode;
import fr.pasteur.sysbio.rdfscape.computing.TermsNode;
import fr.pasteur.sysbio.rdfscape.computing.ValueNode;
import java.util.ArrayList;

public class Parser {
    String token;
    String fullRule;
    String remainingRule;
    String errorMessage;
    String globalErrorString = new String();
    boolean hasErrors = false;

    public EvaluationNode parse(String string) {
        EvaluationNode evaluationNode = new EvaluationNode();
        this.fullRule = string;
        this.remainingRule = string;
        this.token = this.getNextToken();
        String string2 = null;
        PatternNode patternNode = null;
        CompNode compNode = null;
        if (this.tokenIsString(this.token) && !this.tokenIsAggregator(this.token)) {
            string2 = this.token;
            this.token = this.getNextToken();
            if (!this.token.equals("(")) {
                this.error("Expecting \"(\"");
            }
            this.token = this.getNextToken();
            patternNode = this.parsePattern();
            if (!this.token.equals(")")) {
                this.error("xpecting \")\"");
            }
            this.token = this.getNextToken();
            if (!this.token.equals("=")) {
                this.error("Expecting \"=\"");
            }
            this.token = this.getNextToken();
            compNode = this.parseTerms();
        } else {
            this.error("Expecting an identifier and not an aggregator");
        }
        evaluationNode.setName(string2);
        evaluationNode.setPatternNode(patternNode);
        evaluationNode.setExpressionNode(compNode);
        System.out.println("ENDFILE");
        if (this.hasErrors) {
            evaluationNode.setHasErrors(true);
            evaluationNode.setErrorString(this.globalErrorString);
        }
        return evaluationNode;
    }

    private CompNode parseTerms() {
        TermsNode termsNode = new TermsNode();
        FactorNode factorNode = this.parseFactors();
        termsNode.add(factorNode, "+");
        while (this.token.equals("+") || this.token.equals("-")) {
            String string = this.token;
            this.token = this.getNextToken();
            FactorNode factorNode2 = this.parseFactors();
            termsNode.add(factorNode2, string);
        }
        return termsNode;
    }

    private FactorNode parseFactors() {
        FactorNode factorNode = new FactorNode();
        ExpNode expNode = this.parseExps();
        factorNode.add(expNode, "*");
        while (this.token.equals("*") || this.token.equals("/")) {
            String string = this.token;
            this.token = this.getNextToken();
            ExpNode expNode2 = this.parseExps();
            factorNode.add(expNode2, string);
        }
        return factorNode;
    }

    private ExpNode parseExps() {
        ExpNode expNode = new ExpNode();
        CompNode compNode = this.parseAtom();
        expNode.addValueNode(compNode);
        if (this.token.equals("^")) {
            this.token = this.getNextToken();
            if (!this.tokenIsNumber(this.token)) {
                this.error("^ requires a number!");
            } else {
                expNode.setExpString(this.token);
                this.token = this.getNextToken();
            }
        }
        return expNode;
    }

    private CompNode parseAtom() {
        CompNode compNode = null;
        if (this.tokenIsNumber(this.token)) {
            compNode = new ValueNode();
            compNode.setValueString(this.token);
            this.token = this.getNextToken();
        } else if (this.token.equals("SUM")) {
            this.token = this.getNextToken();
            if (this.token.equals("(")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \"(\"");
            }
            compNode = new SumNode();
            ((SumNode)compNode).setFunctionNode(this.parseFunction());
            if (this.token.equals(")")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \")\"");
            }
        } else if (this.token.equals("NUM")) {
            this.token = this.getNextToken();
            if (this.token.equals("(")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \"(\"");
            }
            compNode = new NumNode();
            ((NumNode)compNode).setPatternNode(this.parsePattern());
            if (this.token.equals(")")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \")\"");
            }
        } else if (this.tokenIsString(this.token)) {
            compNode = this.parseFunction();
        } else if (this.token.equals("(")) {
            this.token = this.getNextToken();
            compNode = this.parseTerms();
            if (this.token.equals(")")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \")\"");
            }
        } else {
            this.error("Expecting SUM,NUM,[Attribute name or Built in function],\"(\"");
        }
        return compNode;
    }

    private FunctionNode parseFunction() {
        FunctionNode functionNode = new FunctionNode();
        if (!this.tokenIsString(this.token)) {
            this.error("Expecting a function name");
        } else {
            functionNode.setFunctionName(this.token);
            this.token = this.getNextToken();
            if (this.token.equals("(")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \"(\"");
            }
            functionNode.SetPatternNode(this.parsePattern());
            if (this.token.equals(")")) {
                this.token = this.getNextToken();
            } else {
                this.error("Expecting \")\"");
            }
        }
        return functionNode;
    }

    private PatternNode parsePattern() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PatternNode patternNode = new PatternNode();
        if (!this.tokenIsVar(this.token)) {
            this.error("Expecting a variable");
            return patternNode;
        }
        arrayList.add(this.token.trim());
        this.token = this.getNextToken();
        while (this.tokenIsVar(this.token)) {
            arrayList.add(this.token.trim());
            this.token = this.getNextToken();
        }
        patternNode.addVariables(arrayList);
        return patternNode;
    }

    private String getNextToken() {
        String string = "";
        this.remainingRule = this.remainingRule.trim();
        int n = this.remainingRule.length();
        if (n == 0) {
            return string;
        }
        if (this.remainingRule.indexOf(" ") >= 0 && this.remainingRule.indexOf(" ") < n) {
            n = this.remainingRule.indexOf(" ");
        }
        if (this.remainingRule.indexOf("=") >= 0 && this.remainingRule.indexOf("=") < n) {
            n = this.remainingRule.indexOf("=");
        }
        if (this.remainingRule.indexOf("(") >= 0 && this.remainingRule.indexOf("(") < n) {
            n = this.remainingRule.indexOf("(");
        }
        if (this.remainingRule.indexOf(")") >= 0 && this.remainingRule.indexOf(")") < n) {
            n = this.remainingRule.indexOf(")");
        }
        if (this.remainingRule.indexOf("+") >= 0 && this.remainingRule.indexOf("+") < n) {
            n = this.remainingRule.indexOf("+");
        }
        if (this.remainingRule.indexOf("-") >= 0 && this.remainingRule.indexOf("-") < n) {
            n = this.remainingRule.indexOf("-");
        }
        if (this.remainingRule.indexOf("*") >= 0 && this.remainingRule.indexOf("*") < n) {
            n = this.remainingRule.indexOf("*");
        }
        if (this.remainingRule.indexOf("/") >= 0 && this.remainingRule.indexOf("/") < n) {
            n = this.remainingRule.indexOf("/");
        }
        if (this.remainingRule.indexOf("^") >= 0 && this.remainingRule.indexOf("^") < n) {
            n = this.remainingRule.indexOf("^");
        }
        if (n == 0) {
            string = this.remainingRule.substring(0, 1);
            this.remainingRule = this.remainingRule.substring(1, this.remainingRule.length());
        } else {
            string = this.remainingRule.substring(0, n);
            this.remainingRule = this.remainingRule.substring(n, this.remainingRule.length());
        }
        return string;
    }

    private boolean tokenIsStringOrVar(String string) {
        boolean bl = this.tokenIsStringOrNumber(string);
        boolean bl2 = true;
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl && !bl2;
    }

    private boolean tokenIsStringOrNumber(String string) {
        boolean bl = true;
        if (string.indexOf("=") >= 0) {
            bl = false;
        }
        if (string.indexOf("(") >= 0) {
            bl = false;
        }
        if (string.indexOf(")") >= 0) {
            bl = false;
        }
        if (string.indexOf("+") >= 0) {
            bl = false;
        }
        if (string.indexOf("-") >= 0) {
            bl = false;
        }
        if (string.indexOf("*") >= 0) {
            bl = false;
        }
        if (string.indexOf("/") >= 0) {
            bl = false;
        }
        if (string.indexOf("^") >= 0) {
            bl = false;
        }
        return bl;
    }

    private boolean tokenIsString(String string) {
        return this.tokenIsStringOrVar(string) && string.indexOf("?") != 0;
    }

    private boolean tokenIsNumber(String string) {
        boolean bl = true;
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private boolean tokenIsAggregator(String string) {
        boolean bl = false;
        if (string.equals("SUM")) {
            bl = true;
        }
        if (string.equals("NUM")) {
            bl = true;
        }
        return bl;
    }

    private void error(String string) {
        this.globalErrorString = this.globalErrorString.concat("For token " + this.token + " Error: " + string + " near " + this.remainingRule + "\n");
        System.out.println("For token " + this.token + " Error: " + string + " near " + this.remainingRule);
        this.hasErrors = true;
    }

    private boolean tokenIsVar(String string) {
        boolean bl = true;
        if (!this.tokenIsStringOrVar(string)) {
            bl = false;
        }
        if (string.indexOf("?") != 0) {
            bl = false;
        }
        return bl;
    }
}

