/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import ding.view.EdgeContextMenuListener;
import ding.view.InnerCanvas;
import ding.view.NodeContextMenuListener;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.MemoryViewer;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.cytoscape.PatternMenu;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class CytoscapeDealer
implements PropertyChangeListener,
MemoryViewer {
    private CyNetwork myCurrentNetwork = null;
    private CyNetworkView myCurrentNetworkView = null;
    private CommonMemory commonMemory = null;
    private HashMap patternPanels = null;
    private CyNode hackNode = null;
    private static int currentID = 0;
    private Hashtable networkType = null;
    private HashSet isEditable = null;
    private Collection varRestrictions = null;
    private Hashtable<String, Boolean> networkHasMenu = null;
    private ArrayList tempFilterConditions = null;
    private static int bNodeCounter = 0;
    private static int literalNodeCounter = 0;
    private static int nodeIDCounter = 0;
    private boolean showRDFSLabels = false;
    private boolean collapseDatatypeAttributes = false;
    private boolean enableSplit = false;
    private HashSet uri2Split = null;
    private PatternMenu menuListener = null;
    private String[] nodeAttributesNames = new String[0];
    private String[] edgeAttributesNames = new String[0];
    private String[] nodeStringAttributesNames = new String[0];
    private String[] nodeDoubleAttributesNames = new String[0];
    private String[] nodeBooleanAttributesNames = new String[0];
    private String[] nodeIntegerAttributesNames = new String[0];
    private String[] edgeStringAttributesNames = new String[0];
    private String[] edgeDoubleAttributesNames = new String[0];
    private String[] edgeBooleanAttributesNames = new String[0];
    private String[] edgeIntegerAttributesNames = new String[0];
    private Set nodeStringAttributes = new HashSet();
    private Set nodeDoubleAttributes = new HashSet();
    private Set nodeBooleanAttributes = new HashSet();
    private Set nodeIntegerAttributes = new HashSet();
    private Set edgeStringAttributes = new HashSet();
    private Set edgeDoubleAttributes = new HashSet();
    private Set edgeBooleanAttributes = new HashSet();
    private Set edgeIntegerAttributes = new HashSet();
    CyAttributes nodeAttributes = null;
    CyAttributes edgeAttributes = null;

    public CytoscapeDealer() throws Exception {
        System.out.print("\tCytoscapeDealer... ");
        System.out.print(" 0");
        this.link();
        System.out.print(" 1");
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_FOCUS", this);
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_CREATED", this);
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        this.myCurrentNetworkView = Cytoscape.getCurrentNetworkView();
        System.out.print(" 2");
        this.menuListener = new PatternMenu();
        System.out.print(" 3");
        this.patternPanels = new HashMap();
        this.networkType = new Hashtable();
        this.networkHasMenu = new Hashtable();
        System.out.print(" 4");
        RDFScape.getCommonMemory().addViewerElement(this);
        this.reset();
        System.out.print(" 5 ");
        System.out.println("Ok");
    }

    private void relink() throws Exception {
        this.link();
    }

    private void link() throws Exception {
        if (RDFScape.getCommonMemory() == null) {
            System.out.print("!!!");
            throw new Exception("Cannot build CytoscapeDealer : missing CommonMemory");
        }
        System.out.print(".");
        this.commonMemory = RDFScape.getCommonMemory();
        this.commonMemory.addViewerElement(this);
        System.out.print(".");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        System.out.print("Event ");
        if (propertyChangeEvent.getPropertyName() == "NETWORK_VIEW_CREATED") {
            this.myCurrentNetworkView = (CyNetworkView)propertyChangeEvent.getNewValue();
            System.out.print("focus change ->" + this.myCurrentNetworkView);
        }
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        this.myCurrentNetworkView = Cytoscape.getCurrentNetworkView();
        System.out.println();
    }

    public void reset() {
        this.isEditable = new HashSet();
        this.tempFilterConditions = new ArrayList();
        this.restoreSplitConditions();
    }

    public CyNetwork getCurrentNetwork() {
        return Cytoscape.getCurrentNetwork();
    }

    public Image getScreenshot(int n, int n2) {
        System.out.println("Going to get a screenshot");
        InnerCanvas innerCanvas = ((DGraphView)Cytoscape.getCurrentNetworkView()).getCanvas();
        System.out.println("Dimensions: " + innerCanvas.getWidth() + "x" + innerCanvas.getHeight());
        BufferedImage bufferedImage = new BufferedImage(innerCanvas.getWidth(), innerCanvas.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        innerCanvas.print((Graphics)graphics2D);
        return bufferedImage.getScaledInstance(300, 300, 1);
    }

    public String[] getSelectedOntologyNodes() {
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        Set set = this.myCurrentNetwork.getSelectedNodes();
        ArrayList arrayList = new ArrayList();
        for (CyNode cyNode : set) {
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void makeNewPanel(String string) {
        String string2 = "RDFScape ontology browser # " + currentID;
        ++currentID;
        this.myCurrentNetwork = Cytoscape.createNetwork((String)string2);
        this.myCurrentNetworkView = Cytoscape.createNetworkView((CyNetwork)this.myCurrentNetwork);
        VisualMappingManager visualMappingManager = Cytoscape.getVisualMappingManager();
        CalculatorCatalog calculatorCatalog = visualMappingManager.getCalculatorCatalog();
        VisualStyle visualStyle = calculatorCatalog.getVisualStyle("rdfscape");
        if (visualStyle == null) {
            System.out.println("Cannot find RDFScape visual style");
        }
        this.myCurrentNetworkView.setVisualStyle(visualStyle.getName());
        visualMappingManager.setVisualStyle(visualStyle);
        this.myCurrentNetworkView.redrawGraph(true, true);
        this.networkType.put(string2, string);
        this.networkHasMenu.put(this.myCurrentNetworkView.getIdentifier(), new Boolean(true));
        this.myCurrentNetworkView.addNodeContextMenuListener((NodeContextMenuListener)this.menuListener);
        this.myCurrentNetworkView.addEdgeContextMenuListener((EdgeContextMenuListener)this.menuListener);
    }

    public void setEditable() {
        String string = this.myCurrentNetwork.getTitle();
        if (string == null) {
            return;
        }
        if (!this.isEditable.contains(string)) {
            this.isEditable.add(string);
        }
    }

    public String getCurrentNetworkType() {
        return (String)this.networkType.get(this.myCurrentNetwork.getTitle());
    }

    public void searchNode(String string) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        Iterator iterator = this.myCurrentNetwork.nodesIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string2 = cyAttributes.getStringAttribute(node.getIdentifier(), "URI");
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            this.myCurrentNetwork.setSelectedNodeState(node, true);
        }
    }

    public CyNode getNodeWithURI(String string) {
        CyNode cyNode = RDFScape.getCommonMemory().getCyNodesForURI(string)[0];
        return cyNode;
    }

    private void checkGenericType() {
        if ((String)this.networkType.get(this.myCurrentNetwork.getTitle()) == null) {
            this.networkType.put(this.myCurrentNetwork.getTitle(), "GENERIC");
            System.out.println("Made generic");
        }
    }

    public String getStringNodeAttributeValueByURI(String string, String string2) {
        System.out.println("Request for String attribute " + string2 + " for Node " + string);
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        CyNode cyNode = this.getNodeWithURI(string);
        if (cyNode == null) {
            System.out.println("Node " + string + " not found");
            return null;
        }
        if (!this.nodeStringAttributes.contains(string2)) {
            System.out.println("String attribute " + string2 + " was not found");
            return null;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.getStringAttribute(cyNode.getIdentifier(), string2);
    }

    public Double getDoubleNodeAttributeValueByURI(String string, String string2) {
        System.out.println("Request for Double attribute " + string2 + " for Node " + string);
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        CyNode cyNode = this.getNodeWithURI(string);
        if (cyNode == null) {
            System.out.println("Node " + string + " not found");
            return null;
        }
        if (!this.nodeDoubleAttributes.contains(string2)) {
            System.out.println("Double attribute " + string2 + " was not found");
            return null;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.getDoubleAttribute(cyNode.getIdentifier(), string2);
    }

    public Boolean getBooleanNodeAttributeValueByURI(String string, String string2) {
        System.out.println("Request for Boolean attribute " + string2 + " for Node " + string);
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        CyNode cyNode = this.getNodeWithURI(string);
        if (cyNode == null) {
            System.out.println("Node " + string + " not found");
            return null;
        }
        if (!this.nodeBooleanAttributes.contains(string2)) {
            System.out.println("Boolean attribute " + string2 + " was not found");
            return null;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.getBooleanAttribute(cyNode.getIdentifier(), string2);
    }

    public Integer getIntegerNodeAttributeValueByURI(String string, String string2) {
        System.out.println("Request for Integer attribute " + string2 + " for Node " + string);
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        CyNode cyNode = this.getNodeWithURI(string);
        if (cyNode == null) {
            System.out.println("Node " + string + " not found");
            return null;
        }
        if (!this.nodeIntegerAttributes.contains(string2)) {
            System.out.println("Integer attribute " + string2 + " was not found");
            return null;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.getIntegerAttribute(cyNode.getIdentifier(), string2);
    }

    public Double getNumericAttributeValueByURI(String string, String string2) {
        if (this.getDoubleNodeAttributeValueByURI(string, string2) != null) {
            return this.getDoubleNodeAttributeValueByURI(string, string2);
        }
        if (this.getBooleanNodeAttributeValueByURI(string, string2) != null) {
            if (this.getBooleanNodeAttributeValueByURI(string, string2).booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.getIntegerNodeAttributeValueByURI(string, string2) != null) {
            return new Double(this.getIntegerNodeAttributeValueByURI(string, string2).intValue());
        }
        if (this.getStringNodeAttributeValueByURI(string, string2) != null) {
            Double d = null;
            try {
                d = Double.parseDouble(this.getStringNodeAttributeValueByURI(string, string2));
            }
            catch (Exception exception) {
                System.out.println("Cannot parse " + string2 + " as a number");
                return null;
            }
            return d;
        }
        return null;
    }

    public String getStringEdgeAttributeValueByURI(String string, String string2, String string3) {
        System.out.println("Request for String attribute " + string3 + " for Edge " + string + "->" + string2);
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        if (!this.edgeStringAttributes.contains(string3)) {
            System.out.println(string3 + " is not a String");
            return null;
        }
        int[] nArray = this.myCurrentNetwork.getEdgeIndicesArray();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = this.myCurrentNetwork.getEdge(nArray[i]);
            String string4 = this.nodeAttributes.getStringAttribute(edge.getSource().getIdentifier(), "URI");
            String string5 = this.nodeAttributes.getStringAttribute(edge.getTarget().getIdentifier(), "URI");
            if (string4 == null || string5 == null || !string4.equals(string) || !string5.equals(string2)) continue;
            return this.edgeAttributes.getStringAttribute(edge.getIdentifier(), string3);
        }
        return null;
    }

    public Double getDoubleEdgeAttributeValueByURI(String string, String string2, String string3) {
        System.out.println("Request for Double attribute " + string3 + " for Edge " + string + "->" + string2);
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        if (!this.edgeDoubleAttributes.contains(string3)) {
            System.out.println(string3 + " is not a Double");
            return null;
        }
        int[] nArray = this.myCurrentNetwork.getEdgeIndicesArray();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = this.myCurrentNetwork.getEdge(nArray[i]);
            String string4 = this.nodeAttributes.getStringAttribute(edge.getSource().getIdentifier(), "URI");
            String string5 = this.nodeAttributes.getStringAttribute(edge.getTarget().getIdentifier(), "URI");
            if (string4 == null || string5 == null || !string4.equals(string) || !string5.equals(string2)) continue;
            return this.edgeAttributes.getDoubleAttribute(edge.getIdentifier(), string3);
        }
        return null;
    }

    public Boolean getBooleanEdgeAttributeValueByURI(String string, String string2, String string3) {
        System.out.println("Request for Boolean attribute " + string3 + " for Edge " + string + "->" + string2);
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        if (!this.edgeBooleanAttributes.contains(string3)) {
            System.out.println(string3 + " is not a Boolean");
            return null;
        }
        int[] nArray = this.myCurrentNetwork.getEdgeIndicesArray();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = this.myCurrentNetwork.getEdge(nArray[i]);
            String string4 = this.nodeAttributes.getStringAttribute(edge.getSource().getIdentifier(), "URI");
            String string5 = this.nodeAttributes.getStringAttribute(edge.getTarget().getIdentifier(), "URI");
            if (string4 == null || string5 == null || !string4.equals(string) || !string5.equals(string2)) continue;
            return this.edgeAttributes.getBooleanAttribute(edge.getIdentifier(), string3);
        }
        return null;
    }

    public Integer getIntegerEdgeAttributeValueByURI(String string, String string2, String string3) {
        System.out.println("Request for Integer attribute " + string3 + " for Edge " + string + "->" + string2);
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (this.myCurrentNetwork == null) {
            System.out.println("No network!");
            return null;
        }
        if (!this.edgeIntegerAttributes.contains(string3)) {
            System.out.println(string3 + " is not a String");
            return null;
        }
        int[] nArray = this.myCurrentNetwork.getEdgeIndicesArray();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = this.myCurrentNetwork.getEdge(nArray[i]);
            String string4 = this.nodeAttributes.getStringAttribute(edge.getSource().getIdentifier(), "URI");
            String string5 = this.nodeAttributes.getStringAttribute(edge.getTarget().getIdentifier(), "URI");
            if (string4 == null || string5 == null || !string4.equals(string) || !string5.equals(string2)) continue;
            return this.edgeAttributes.getIntegerAttribute(edge.getIdentifier(), string3);
        }
        return null;
    }

    public Double getEdgeAttributeNumericValueByURI(String string, String string2, String string3) {
        Constable constable;
        Double d = null;
        if (this.edgeDoubleAttributes.contains(string3)) {
            d = this.getDoubleEdgeAttributeValueByURI(string, string2, string3);
        }
        if (d != null) {
            return d;
        }
        if (this.edgeIntegerAttributes.contains(string3) && (constable = this.getIntegerEdgeAttributeValueByURI(string, string2, string3)) != null) {
            d = new Double(((Integer)constable).intValue());
        }
        if (d != null) {
            return d;
        }
        if (this.edgeBooleanAttributes.contains(string3) && (constable = this.getBooleanEdgeAttributeValueByURI(string, string2, string3)) != null) {
            d = ((Boolean)constable).booleanValue() ? new Double(1.0) : new Double(0.0);
        }
        if (d != null) {
            return d;
        }
        if (this.edgeStringAttributes.contains(string3)) {
            try {
                d = Double.parseDouble(this.getStringEdgeAttributeValueByURI(string, string2, string3));
            }
            catch (Exception exception) {
                System.out.println("Cannot parse " + string3 + " as a number");
                return null;
            }
        }
        return d;
    }

    public int getNodeCount() {
        if (this.myCurrentNetwork == null) {
            System.out.println("mhhhh where ?");
            return 0;
        }
        return this.myCurrentNetwork.getNodeCount();
    }

    public ExpressionData getExpressionData() {
        return Cytoscape.getExpressionData();
    }

    public void addSelectedSetOfNodes(AbstractQueryResultTable abstractQueryResultTable, int[][] nArray) {
        if (!this.hasGraph()) {
            RDFScape.warn("Don't know where to plot nodes. Going to create a network panel for you.");
            this.makeNewPanel("Auto");
        }
        if (abstractQueryResultTable == null) {
            RDFScape.warn("null Query. This should not happen.");
            return;
        }
        if (abstractQueryResultTable.getRowCount() < 1) {
            RDFScape.warn("Make a selection first!");
            return;
        }
        System.out.println("Plotting " + nArray.length + " to " + this.myCurrentNetwork.getTitle());
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i][0];
            int n2 = nArray[i][1];
            if (abstractQueryResultTable.isURI(n, n2)) {
                this.addSimpleURI(abstractQueryResultTable.getURI(n, n2), abstractQueryResultTable.getNamespace(n, n2), abstractQueryResultTable.getLabel(n, n2));
            }
            if (abstractQueryResultTable.isLiteral(n, n2)) {
                // empty if block
            }
            if (!abstractQueryResultTable.isBlank(n, n2)) continue;
        }
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public CyNode[] addSimpleURI(String string, String string2, String string3) {
        KnowledgeWrapper knowledgeWrapper = RDFScape.getKnowledgeEngine();
        String string4 = "";
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        ArrayList<String> arrayList = RDFScape.getCytoMapper().getCytoscapeIDsForURI(string);
        ArrayList<CyNode> arrayList2 = new ArrayList<CyNode>();
        if (arrayList.size() == 0) {
            string4 = string;
            arrayList.add(string4);
        } else if (this.commonMemory.splitEnabled && this.uri2Split.contains(string)) {
            string4 = string + nodeIDCounter++;
            arrayList.add(string4);
        }
        for (String string5 : arrayList) {
            CyNode cyNode = Cytoscape.getCyNode((String)string5, (boolean)true);
            cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "URI");
            cyAttributes.setAttribute(cyNode.getIdentifier(), "URI", string);
            cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", string3);
            cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(this.commonMemory.getNamespaceColor(string2)));
            if (this.commonMemory.collapseDataTypes && KnowledgeWrapper.hasGraphAccessSupport(knowledgeWrapper)) {
                String[][] stringArray = ((GraphQueryAnswerer)((Object)knowledgeWrapper)).getDatatypeAttributeBox(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    cyAttributes.setAttribute(cyNode.getIdentifier(), stringArray[i][0], stringArray[i][1]);
                }
            }
            this.myCurrentNetwork.addNode((Node)cyNode);
            this.commonMemory.registerURINamespace(string, string2);
            this.commonMemory.registerURICytoNode(string, cyNode);
            this.commonMemory.registerURILabel(string, string3);
            arrayList2.add(cyNode);
        }
        return arrayList2.toArray(new CyNode[0]);
    }

    public CyNode addSimpleLiteral(String string, String string2, String string3, Object object) {
        CyNode cyNode = Cytoscape.getCyNode((String)(string + "^^" + string2), (boolean)true);
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "LITERAL");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "DATATYPE", string2);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", string);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", string3);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "VALUE", string);
        this.myCurrentNetwork.addNode((Node)cyNode);
        this.commonMemory.registerLiteralCyNode(object, cyNode);
        this.commonMemory.registerLiteralNode2Label(object, string);
        if (string2 != null) {
            this.commonMemory.registerDatatypeURI2Literal(string2, object);
        }
        return cyNode;
    }

    public CyNode addSimpleBlankNode(Object object) {
        System.out.println("Adding blank node " + object.toString());
        boolean bl = false;
        System.out.println("Network : " + this.myCurrentNetwork);
        CyNode cyNode = Cytoscape.getCyNode((String)object.toString(), (boolean)true);
        System.out.println(cyNode);
        System.out.println(cyNode.getIdentifier());
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "BLANK");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", "B");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", "LIGHT_GRAY");
        this.myCurrentNetwork.addNode((Node)cyNode);
        this.commonMemory.registerBNodeCyNode(object, cyNode);
        return cyNode;
    }

    public CyNode[] addSplittedURI() {
        return null;
    }

    public CyNode searchNodeByURI(String string) {
        return null;
    }

    @Override
    public void updateView() {
        if (this.myCurrentNetworkView != null) {
            this.myCurrentNetworkView.redrawGraph(true, false);
            this.myCurrentNetworkView.fitContent();
            this.myCurrentNetworkView.updateView();
        }
    }

    @Override
    public void updateNamespaceView(String string) {
        int n;
        System.out.println("Repainting after change in ns: " + string);
        if (this.myCurrentNetworkView == null) {
            return;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        Color color = this.commonMemory.getNamespaceColor(string);
        CyNode[] cyNodeArray = this.commonMemory.getNamespaceCyNodes(string);
        for (n = 0; n < cyNodeArray.length; ++n) {
            if (cyAttributes.hasAttribute(cyNodeArray[n].getIdentifier(), "VAR")) continue;
            cyAttributes.setAttribute(cyNodeArray[n].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        cyNodeArray = this.commonMemory.getCyNodesForLiteralDatatypeURINamespace(string);
        for (n = 0; n < cyNodeArray.length; ++n) {
            if (cyAttributes.hasAttribute(cyNodeArray[n].getIdentifier(), "VAR")) continue;
            cyAttributes.setAttribute(cyNodeArray[n].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        CyEdge[] cyEdgeArray = this.commonMemory.getNamespaceCyEdges(string);
        for (int i = 0; i < cyEdgeArray.length; ++i) {
            if (cyAttributes2.hasAttribute(cyEdgeArray[i].getIdentifier(), "VAR")) continue;
            cyAttributes2.setAttribute(cyEdgeArray[i].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public boolean canCollapseDatatypes() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledgeEngine());
    }

    public boolean canExtend() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledgeEngine());
    }

    public void addIncomingEdge(CyNode cyNode, AbstractQueryResultTable abstractQueryResultTable, int n, CommonMemory commonMemory) {
        CyNode cyNode2 = null;
        CyNode[] cyNodeArray = null;
        if (abstractQueryResultTable.isURI(n, 0)) {
            cyNodeArray = this.addSimpleURI(abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0));
            for (int i = 0; i < cyNodeArray.length; ++i) {
                this.addSimpleEdge(cyNodeArray[i], abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
            }
        }
        if (abstractQueryResultTable.isLiteral(n, 0)) {
            cyNode2 = this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, 0), abstractQueryResultTable.getDatatypeType(n, 0), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, 0)), abstractQueryResultTable.getValueAt(n, 0));
            this.addSimpleEdge(cyNode2, abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
        }
        if (abstractQueryResultTable.isBlank(n, 0)) {
            cyNode2 = this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, 0));
            this.addSimpleEdge(cyNode2, abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
        }
        CyNode[] cyNodeArray2 = new CyNode[]{cyNode};
        CyLayoutAlgorithm cyLayoutAlgorithm = this.getMyDefaultLayout();
        if (this.myCurrentNetworkView.getNodeViewCount() < 5) {
            this.layoutAll();
        } else if (this.myCurrentNetworkView.getNodeViewCount() < 15) {
            this.myCurrentNetworkView.applyLockedLayout(CyLayouts.getDefaultLayout(), cyNodeArray2, new CyEdge[0]);
        }
        this.myCurrentNetworkView.redrawGraph(false, true);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.setZoom(this.myCurrentNetworkView.getZoom() * 0.8);
        this.myCurrentNetworkView.updateView();
    }

    private CyLayoutAlgorithm getMyDefaultLayout() {
        CyLayoutAlgorithm cyLayoutAlgorithm = CyLayouts.getDefaultLayout();
        if (cyLayoutAlgorithm.getName().equalsIgnoreCase("grid")) {
            System.out.println("Default layout was grid... I'll use circular");
            CyLayouts.getLayout((String)"jgraph-circle");
        }
        return cyLayoutAlgorithm;
    }

    public void addOutgoingEdge(CyNode cyNode, AbstractQueryResultTable abstractQueryResultTable, int n, CommonMemory commonMemory) {
        CyNode[] cyNodeArray = null;
        CyNode cyNode2 = null;
        CyEdge cyEdge = null;
        if (abstractQueryResultTable.isURI(n, 1)) {
            cyNodeArray = this.addSimpleURI(abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1));
            for (int i = 0; i < cyNodeArray.length; ++i) {
                cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNodeArray[i], commonMemory);
            }
        }
        if (abstractQueryResultTable.isLiteral(n, 1)) {
            cyNode2 = this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, 1), abstractQueryResultTable.getDatatypeType(n, 1), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, 1)), abstractQueryResultTable.getValueAt(n, 1));
            cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNode2, commonMemory);
        }
        if (abstractQueryResultTable.isBlank(n, 1)) {
            cyNode2 = this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, 1));
            cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNode2, commonMemory);
        }
        System.out.println("Adding outgoing edge");
        CyNode[] cyNodeArray2 = new CyNode[]{cyNode};
        CyLayoutAlgorithm cyLayoutAlgorithm = this.getMyDefaultLayout();
        if (this.myCurrentNetworkView.getNodeViewCount() < 5) {
            this.layoutAll();
        } else if (this.myCurrentNetworkView.getNodeViewCount() < 15) {
            this.myCurrentNetworkView.applyLockedLayout(CyLayouts.getDefaultLayout(), cyNodeArray2, new CyEdge[0]);
        }
        this.myCurrentNetworkView.redrawGraph(false, true);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.setZoom(this.myCurrentNetworkView.getZoom() * 0.8);
        this.myCurrentNetworkView.updateView();
    }

    private CyEdge addSimpleEdge(CyNode cyNode, String string, String string2, String string3, CyNode cyNode2, CommonMemory commonMemory) {
        CyEdge cyEdge = Cytoscape.getCyEdge((String)cyNode.getIdentifier(), (String)string, (String)cyNode2.getIdentifier(), (String)"_concept_");
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        System.out.println("Adding edge with the following attributes:\nCOLOR " + DefaultSettings.translateColor2String(commonMemory.getNamespaceColor(string2)) + "\n" + "URI " + string + "\n" + "LABEL " + string3 + "\n");
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(commonMemory.getNamespaceColor(string2)));
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "URI", string);
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "LABEL", string3);
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "TYPE", "PROPERTY");
        this.myCurrentNetwork.addEdge((Edge)cyEdge);
        this.commonMemory.registerURINamespace(string, string2);
        this.commonMemory.registerURICytoEdge(string, cyEdge);
        this.commonMemory.registerURILabel(string, string3);
        return cyEdge;
    }

    public String[][] getTripleWithVariablesArrayList() {
        Object object;
        if (this.myCurrentNetwork.getTitle() == null) {
            return new String[0][3];
        }
        this.tempFilterConditions = new ArrayList();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Iterator iterator = this.myCurrentNetwork.edgesIterator();
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        while (iterator.hasNext()) {
            String[] stringArray;
            Object object2;
            Object object3;
            object = (Edge)iterator.next();
            String[] stringArray2 = object.getSource();
            Node node = object.getTarget();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (cyAttributes.hasAttribute(stringArray2.getIdentifier(), "VAR")) {
                string = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "VAR");
                if (cyAttributes.hasAttribute(stringArray2.getIdentifier(), "FILTER")) {
                    object3 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "FILTER");
                    object2 = new String[]{string, object3, "F"};
                    this.tempFilterConditions.add(object2);
                }
            } else {
                object3 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "TYPE");
                if (object3.equalsIgnoreCase("BLANK")) {
                    string = "?b" + bNodeCounter++;
                }
                if (object3.equalsIgnoreCase("LITERAL")) {
                    object2 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "VALUE");
                    string = "?l" + literalNodeCounter++;
                    stringArray = new String[]{string, object2, "P"};
                    this.tempFilterConditions.add(stringArray);
                }
                if (object3.equalsIgnoreCase("URI")) {
                    string = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "URI");
                }
            }
            string2 = cyAttributes2.hasAttribute(object.getIdentifier(), "VAR") ? cyAttributes2.getStringAttribute(object.getIdentifier(), "VAR") : cyAttributes2.getStringAttribute(object.getIdentifier(), "URI");
            if (cyAttributes.hasAttribute(node.getIdentifier(), "VAR")) {
                string3 = cyAttributes.getStringAttribute(node.getIdentifier(), "VAR");
                if (cyAttributes.hasAttribute(node.getIdentifier(), "FILTER")) {
                    object3 = cyAttributes.getStringAttribute(node.getIdentifier(), "FILTER");
                    object2 = new String[]{string3, object3, "F"};
                    this.tempFilterConditions.add(object2);
                }
            } else {
                object3 = cyAttributes.getStringAttribute(node.getIdentifier(), "TYPE");
                if (object3.equalsIgnoreCase("BLANK")) {
                    string3 = "?b" + bNodeCounter++;
                }
                if (object3.equalsIgnoreCase("LITERAL")) {
                    object2 = cyAttributes.getStringAttribute(node.getIdentifier(), "VALUE");
                    string3 = "?l" + literalNodeCounter++;
                    stringArray = new String[]{string3, object2, "P"};
                    this.tempFilterConditions.add(stringArray);
                }
                if (object3.equalsIgnoreCase("URI")) {
                    string3 = cyAttributes.getStringAttribute(node.getIdentifier(), "URI");
                }
            }
            object3 = new String[]{string, string2, string3};
            System.out.println("Pattern: " + string + "---" + string2 + "---" + string3);
            arrayList.add((String[])object3);
        }
        System.out.println("Filters: ");
        for (String[] stringArray2 : this.tempFilterConditions) {
            System.out.println(stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2]);
        }
        object = new String[0][3];
        return (String[][])arrayList.toArray((T[])object);
    }

    public String[][] getFilterConditionsArray() {
        String[][] stringArray = new String[0][3];
        if (this.tempFilterConditions.size() == 0) {
            return stringArray;
        }
        return (String[][])this.tempFilterConditions.toArray((T[])stringArray);
    }

    public void searchURIs(AbstractQueryResultTable abstractQueryResultTable) {
        if (!this.hasGraph()) {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (int j = 0; j < abstractQueryResultTable.getColumnCount(); ++j) {
                if (!abstractQueryResultTable.isURI(i, j)) continue;
                CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(abstractQueryResultTable.getURI(i, j));
                for (int k = 0; k < cyNodeArray.length; ++k) {
                    this.myCurrentNetwork.setSelectedNodeState((Node)cyNodeArray[k], true);
                }
            }
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public void addURIs(AbstractQueryResultTable abstractQueryResultTable) {
        if (!this.hasGraph()) {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (int j = 0; j < abstractQueryResultTable.getColumnCount(); ++j) {
                if (!abstractQueryResultTable.isURI(i, j)) continue;
                this.addSimpleURI(abstractQueryResultTable.getURI(i, j), abstractQueryResultTable.getNamespace(i, j), abstractQueryResultTable.getLabel(i, j));
            }
        }
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public void searchPattern(AbstractQueryResultTable abstractQueryResultTable) {
        if (!this.hasGraph()) {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        System.out.println("Going to search for this pattern");
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            CyEdge cyEdge;
            int n;
            System.out.println("Checking result line #" + i);
            CyNode[] cyNodeArray = this.searchGenericNodeFromTable(abstractQueryResultTable, i, 0, false);
            CyNode[] cyNodeArray2 = this.searchGenericNodeFromTable(abstractQueryResultTable, i, 2, false);
            Hashtable<String, CyEdge> hashtable2 = (Hashtable<String, CyEdge>)hashtable.get(abstractQueryResultTable.getURI(i, 1));
            if (hashtable2 == null) {
                System.out.println("First time I see uri: " + abstractQueryResultTable.getURI(i, 1));
                hashtable2 = new Hashtable<String, CyEdge>();
                CyEdge[] cyEdgeArray = this.commonMemory.getCyEdgesFromURI(abstractQueryResultTable.getURI(i, 1));
                for (n = 0; n < cyEdgeArray.length; ++n) {
                    System.out.println("Processing edge #" + n);
                    cyEdge = (CyNode)cyEdgeArray[n].getSource();
                    CyNode cyNode = (CyNode)cyEdgeArray[n].getTarget();
                    hashtable2.put(cyEdge.getIdentifier() + cyNode.getIdentifier(), cyEdgeArray[n]);
                }
                hashtable.put(abstractQueryResultTable.getURI(i, 1), hashtable2);
            }
            for (int j = 0; j < cyNodeArray.length; ++j) {
                for (n = 0; n < cyNodeArray2.length; ++n) {
                    cyEdge = (CyEdge)hashtable2.get(cyNodeArray[j].getIdentifier() + cyNodeArray2[j].getIdentifier());
                    if (cyEdge == null) continue;
                    this.myCurrentNetwork.setSelectedEdgeState((Edge)cyEdge, true);
                    this.myCurrentNetwork.setSelectedNodeState(cyEdge.getSource(), true);
                    this.myCurrentNetwork.setSelectedNodeState(cyEdge.getTarget(), true);
                }
            }
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public void addPattern(AbstractQueryResultTable abstractQueryResultTable) {
        if (!this.hasGraph()) {
            RDFScape.warn("Don't know where to plot it. Going to create a network panel for you");
            this.makeNewPanel("Auto");
        }
        if (abstractQueryResultTable.getRowCount() == 0) {
            RDFScape.warn("No matches.");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            CyNode[] cyNodeArray = null;
            CyNode[] cyNodeArray2 = null;
            cyNodeArray = this.addGenericNodeFromTable(abstractQueryResultTable, i, 0);
            cyNodeArray2 = this.addGenericNodeFromTable(abstractQueryResultTable, i, 2);
            for (int j = 0; j < cyNodeArray.length; ++j) {
                for (int k = 0; k < cyNodeArray2.length; ++k) {
                    this.addSimpleEdge(cyNodeArray[j], abstractQueryResultTable.getURI(i, 1), abstractQueryResultTable.getNamespace(i, 1), abstractQueryResultTable.getLabel(i, 1), cyNodeArray2[k], this.commonMemory);
                }
            }
        }
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    private CyNode[] addGenericNodeFromTable(AbstractQueryResultTable abstractQueryResultTable, int n, int n2) {
        if (abstractQueryResultTable.isURI(n, n2)) {
            return this.addSimpleURI(abstractQueryResultTable.getURI(n, n2), abstractQueryResultTable.getNamespace(n, n2), abstractQueryResultTable.getLabel(n, n2));
        }
        if (abstractQueryResultTable.isLiteral(n, n2)) {
            CyNode[] cyNodeArray = new CyNode[]{this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, n2), abstractQueryResultTable.getDatatypeType(n, n2), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, n2)), abstractQueryResultTable.getValueAt(n, n2))};
            return cyNodeArray;
        }
        if (abstractQueryResultTable.isBlank(n, n2)) {
            CyNode[] cyNodeArray = new CyNode[]{this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, n2))};
            return cyNodeArray;
        }
        return null;
    }

    private CyNode[] searchGenericNodeFromTable(AbstractQueryResultTable abstractQueryResultTable, int n, int n2, boolean bl) {
        if (abstractQueryResultTable.isURI(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(abstractQueryResultTable.getURI(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    if (!bl) continue;
                    this.myCurrentNetwork.setSelectedNodeState((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        if (abstractQueryResultTable.isLiteral(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodeForLiteralNode(abstractQueryResultTable.getValueAt(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    if (!bl) continue;
                    this.myCurrentNetwork.setSelectedNodeState((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        if (abstractQueryResultTable.isBlank(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodesForBNode(abstractQueryResultTable.getValueAt(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    if (!bl) continue;
                    this.myCurrentNetwork.setSelectedNodeState((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        return new CyNode[0];
    }

    public void updateURILabel(String string) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(string);
        for (int i = 0; i < cyNodeArray.length; ++i) {
            String string2 = this.commonMemory.getLabelForURI(string);
            if (string2 == null) continue;
            cyAttributes.setAttribute(cyNodeArray[i].getIdentifier(), "LABEL", string2);
        }
    }

    public void addSplitConditions(AbstractQueryResultTable abstractQueryResultTable) {
        System.out.println("Split!");
        if (abstractQueryResultTable.getColumnCount() != 1) {
            System.out.println("I want only uris!");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            if (!abstractQueryResultTable.isURI(i, 0)) continue;
            this.uri2Split.add(abstractQueryResultTable.getURI(i, 0));
        }
    }

    public void restoreSplitConditions() {
        this.uri2Split = new HashSet();
    }

    public int[] mapNodes(Hashtable hashtable) {
        Iterator iterator;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        int[] nArray = new int[]{0, 0};
        if (this.myCurrentNetwork == null) {
            return nArray;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        Iterator iterator2 = this.myCurrentNetwork.nodesIterator();
        int n2 = 0;
        this.analyzeAttributes();
        RDFScape.getCommonMemory().registerNameSpace("http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#");
        RDFScape.getCommonMemory().registerPrefix("http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#", "n" + Cytoscape.getCurrentNetwork().getIdentifier());
        RDFScape.getCommonMemory().registerNameSpaceColor("http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#", DefaultSettings.translateString2Color("ORANGE"));
        while (iterator2.hasNext()) {
            String string;
            System.out.print("Checking node # " + n2++ + " : ");
            iterator = (CyNode)iterator2.next();
            System.out.println(iterator.getIdentifier());
            if (cyAttributes.hasAttribute(iterator.getIdentifier(), "URI")) {
                string = cyAttributes.getStringAttribute(iterator.getIdentifier(), "URI");
                ++n;
                hashSet.add(string);
                this.extractNode((CyNode)iterator, string, cyAttributes);
                continue;
            }
            string = (String)hashtable.get(iterator.getIdentifier());
            System.out.println(iterator.getIdentifier() + "->" + string);
            if (string == null) continue;
            ++n;
            hashSet.add(string);
            cyAttributes.setAttribute(iterator.getIdentifier(), "URI", string);
            this.extractNode((CyNode)iterator, string, cyAttributes);
        }
        iterator = this.myCurrentNetwork.edgesIterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string;
            CyEdge cyEdge = (CyEdge)iterator.next();
            if (cyAttributes2.hasAttribute(cyEdge.getIdentifier(), "URI")) {
                string = cyAttributes2.getStringAttribute(cyEdge.getIdentifier(), "URI");
                this.extractEdge(cyEdge, string, cyAttributes2);
                continue;
            }
            string = (String)hashtable.get(cyEdge.getIdentifier());
            if (string == null) continue;
            this.extractEdge(cyEdge, string, cyAttributes2);
        }
        this.updateView();
        nArray[0] = n;
        nArray[1] = hashSet.size();
        System.out.println("Nodes matched: " + n);
        System.out.println("URIs resolved: " + hashSet.size());
        if (this.networkHasMenu.get(this.myCurrentNetworkView.getIdentifier()) == null) {
            this.myCurrentNetworkView.addNodeContextMenuListener((NodeContextMenuListener)this.menuListener);
            this.myCurrentNetworkView.addEdgeContextMenuListener((EdgeContextMenuListener)this.menuListener);
        }
        this.networkHasMenu.put(this.myCurrentNetwork.getIdentifier(), new Boolean(true));
        RDFScape.getKnowledgeEngine().touch();
        return nArray;
    }

    private void extractNode(CyNode cyNode, String string, CyAttributes cyAttributes) {
        this.commonMemory.registerURICytoNode(string, cyNode);
        String string2 = cyNode.getIdentifier();
        String string3 = string;
        if (KnowledgeWrapper.hasGraphAccessSupport(RDFScape.getKnowledgeEngine())) {
            Constable constable;
            int n;
            System.out.println("NEW-NODE-EXCTRACTION-UNOPTIMIZED-BEGIN");
            for (n = 0; n < this.nodeDoubleAttributesNames.length; ++n) {
                if (!cyAttributes.hasAttribute(string2, this.nodeDoubleAttributesNames[n])) continue;
                System.out.println("Found String attribute " + this.nodeDoubleAttributesNames[n] + " for node " + string2);
                constable = cyAttributes.getDoubleAttribute(string2, this.nodeDoubleAttributesNames[n]);
                ((GraphQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).addTypedDataStatement(string, "http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#" + this.nodeDoubleAttributesNames[n], constable, "Double");
            }
            for (n = 0; n < this.nodeBooleanAttributesNames.length; ++n) {
                if (!cyAttributes.hasAttribute(string2, this.nodeBooleanAttributesNames[n])) continue;
                System.out.println("Found String attribute " + this.nodeBooleanAttributesNames[n] + " for node " + string2);
                constable = cyAttributes.getBooleanAttribute(string2, this.nodeBooleanAttributesNames[n]);
                ((GraphQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).addTypedDataStatement(string, "http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#" + this.nodeBooleanAttributesNames[n], constable, "Boolean");
            }
            for (n = 0; n < this.nodeIntegerAttributesNames.length; ++n) {
                if (!cyAttributes.hasAttribute(string2, this.nodeIntegerAttributesNames[n])) continue;
                System.out.println("Found String attribute " + this.nodeIntegerAttributesNames[n] + " for node " + string2);
                constable = cyAttributes.getIntegerAttribute(string2, this.nodeIntegerAttributesNames[n]);
                ((GraphQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).addTypedDataStatement(string, "http://rdfscape/network" + Cytoscape.getCurrentNetwork().getIdentifier() + "#" + this.nodeIntegerAttributesNames[n], constable, "Integer");
            }
            System.out.println("NEW-NODE-EXTRACTION-UNOPTIMIZED-END");
        }
        this.commonMemory.registerURILabel(string, string3);
    }

    private void extractEdge(CyEdge cyEdge, String string, CyAttributes cyAttributes) {
        this.commonMemory.registerURICytoEdge(string, cyEdge);
        String string2 = string;
        this.commonMemory.registerURILabel(string, string2);
    }

    public boolean hasGraph() {
        System.out.println("Number of graphs: " + Cytoscape.getNetworkSet().size());
        if (!Cytoscape.viewExists((String)Cytoscape.getCurrentNetwork().getIdentifier())) {
            return false;
        }
        return Cytoscape.getNetworkSet().size() > 0;
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.myCurrentNetworkView;
    }

    public boolean isEditable() {
        String string = this.myCurrentNetwork.getTitle();
        if (string == null) {
            return false;
        }
        return this.isEditable.contains(string);
    }

    public boolean isVariable(NodeView nodeView) {
        CyNode cyNode = (CyNode)nodeView.getNode();
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.hasAttribute(cyNode.getIdentifier(), "VAR");
    }

    public boolean isVariable(EdgeView edgeView) {
        CyEdge cyEdge = (CyEdge)edgeView.getEdge();
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        return cyAttributes.hasAttribute(cyEdge.getIdentifier(), "VAR");
    }

    public void layoutAll() {
        JMenu jMenu = Cytoscape.getDesktop().getCyMenus().getLayoutMenu();
        MenuElement[] menuElementArray = jMenu.getSubElements();
        MenuElement[] menuElementArray2 = ((JPopupMenu)menuElementArray[0]).getSubElements();
        JMenuItem jMenuItem = null;
        for (int i = 0; i < menuElementArray2.length && !(jMenuItem = (JMenuItem)menuElementArray2[i]).getText().equals("yFiles"); ++i) {
        }
        menuElementArray = jMenuItem.getSubElements();
        menuElementArray2 = ((JPopupMenu)menuElementArray[0]).getSubElements();
        AbstractButton abstractButton = null;
        for (int i = 0; i < menuElementArray2.length && !(abstractButton = (JMenuItem)menuElementArray2[i]).getText().equals("Circular"); ++i) {
        }
        abstractButton.doClick();
    }

    public void displayAdaptAfterMassAddition() {
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public void displayAdaptAfterSingleAdditon(CyNode cyNode) {
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    private void analyzeAttributes() {
        int n;
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        this.edgeAttributes = Cytoscape.getEdgeAttributes();
        this.nodeAttributesNames = this.nodeAttributes.getAttributeNames();
        this.edgeAttributesNames = this.edgeAttributes.getAttributeNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (n = 0; n < this.nodeAttributesNames.length; ++n) {
            if (this.nodeAttributes.getType(this.nodeAttributesNames[n]) == 4) {
                arrayList.add(this.nodeAttributesNames[n]);
            }
            if (this.nodeAttributes.getType(this.nodeAttributesNames[n]) == 2) {
                arrayList2.add(this.nodeAttributesNames[n]);
            }
            if (this.nodeAttributes.getType(this.nodeAttributesNames[n]) == 1) {
                arrayList3.add(this.nodeAttributesNames[n]);
            }
            if (this.nodeAttributes.getType(this.nodeAttributesNames[n]) != 3) continue;
            arrayList4.add(this.nodeAttributesNames[n]);
        }
        this.nodeStringAttributesNames = arrayList.toArray(this.nodeStringAttributesNames);
        this.nodeDoubleAttributesNames = arrayList2.toArray(this.nodeDoubleAttributesNames);
        this.nodeBooleanAttributesNames = arrayList3.toArray(this.nodeBooleanAttributesNames);
        this.nodeIntegerAttributesNames = arrayList4.toArray(this.nodeIntegerAttributesNames);
        arrayList = new ArrayList();
        arrayList2 = new ArrayList();
        arrayList3 = new ArrayList();
        arrayList4 = new ArrayList();
        for (n = 0; n < this.edgeAttributesNames.length; ++n) {
            if (this.edgeAttributes.getType(this.edgeAttributesNames[n]) == 4) {
                arrayList.add(this.edgeAttributesNames[n]);
            }
            if (this.edgeAttributes.getType(this.edgeAttributesNames[n]) == 2) {
                arrayList2.add(this.edgeAttributesNames[n]);
            }
            if (this.edgeAttributes.getType(this.edgeAttributesNames[n]) == 1) {
                arrayList3.add(this.edgeAttributesNames[n]);
            }
            if (this.edgeAttributes.getType(this.edgeAttributesNames[n]) != 3) continue;
            arrayList4.add(this.edgeAttributesNames[n]);
        }
        this.edgeStringAttributesNames = arrayList.toArray(this.edgeStringAttributesNames);
        this.edgeDoubleAttributesNames = arrayList2.toArray(this.edgeDoubleAttributesNames);
        this.edgeBooleanAttributesNames = arrayList3.toArray(this.edgeBooleanAttributesNames);
        this.edgeIntegerAttributesNames = arrayList4.toArray(this.edgeIntegerAttributesNames);
        System.out.println("Had a look at attributes, found: ");
        System.out.println(this.nodeStringAttributesNames.length + " node String attributes");
        System.out.println(this.nodeDoubleAttributesNames.length + " node Double attributes");
        System.out.println(this.nodeBooleanAttributesNames.length + " node Boolean attributes");
        System.out.println(this.nodeIntegerAttributesNames.length + " node Integer attributes");
        System.out.println(this.edgeStringAttributesNames.length + " edge String attributes");
        System.out.println(this.edgeDoubleAttributesNames.length + " edge Double attributes");
        System.out.println(this.edgeBooleanAttributesNames.length + " edge Boolean attributes");
        System.out.println(this.edgeIntegerAttributesNames.length + " edge Integer attributes");
        this.nodeStringAttributes = new HashSet<String>(Arrays.asList(this.nodeStringAttributesNames));
        this.nodeDoubleAttributes = new HashSet<String>(Arrays.asList(this.nodeDoubleAttributesNames));
        this.nodeBooleanAttributes = new HashSet<String>(Arrays.asList(this.nodeBooleanAttributesNames));
        this.nodeIntegerAttributes = new HashSet<String>(Arrays.asList(this.nodeIntegerAttributesNames));
        this.edgeStringAttributes = new HashSet<String>(Arrays.asList(this.edgeStringAttributesNames));
        this.edgeDoubleAttributes = new HashSet<String>(Arrays.asList(this.edgeDoubleAttributesNames));
        this.edgeBooleanAttributes = new HashSet<String>(Arrays.asList(this.edgeBooleanAttributesNames));
        this.edgeIntegerAttributes = new HashSet<String>(Arrays.asList(this.edgeIntegerAttributesNames));
    }
}

