/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.ontologyhandling;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.ontologyhandling.OntologyLoaderManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OntologyManagerLoaderPanel
extends AbstractModulePanel {
    OntologyLoaderManager ontologyManager = null;
    JButton loadButton = null;
    JButton addOntologyButton = null;
    JButton deleteOntologyButton = null;
    JTable ontologyTable = null;

    public OntologyManagerLoaderPanel(OntologyLoaderManager ontologyLoaderManager) {
        this.ontologyManager = ontologyLoaderManager;
        this.redLightText = "<html>You should use correct URLs of ontologies</html>";
        this.yellowLightText = "<html>You should load some ontology at this point</html>";
        this.greenLightText = "<html>Ontologies loaded with no problems</html>";
        this.myTabText = "2) Load ontologies";
        this.myTabTooltip = "<html>Load your ontologies (or change/create their list)</html>";
        this.addOntologyButton = new JButton("add");
        this.deleteOntologyButton = new JButton("delete");
        this.loadButton = new JButton("load ontologies");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.addOntologyButton, "West");
        jPanel.add((Component)this.deleteOntologyButton, "East");
        jPanel.add((Component)this.loadButton, "Center");
        this.addOntologyButton.addActionListener(new AddOntologyButtonListener());
        this.deleteOntologyButton.addActionListener(new DeleteOntologyButtonListener());
        this.loadButton.addActionListener(new LoadButtonListener());
        this.ontologyTable = new JTable(this.ontologyManager);
        JScrollPane jScrollPane = new JScrollPane(this.ontologyTable);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
        TableColumn tableColumn = this.ontologyTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new StatusCellRenderer());
    }

    @Override
    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToLoadOntologies";
    }

    @Override
    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>This list shows all ontologies present in the system. You can alter this list with the <b>add</b> and <b>delete</b> button <br>Once <b>load ontologies</b> is issued, the oucome of the loading operation is reported with a message and an error code.</html>", Utilities.getHelpIcon("ontologyLoaderStatusButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Adds a new ontology to the list. A form will be povided to enter the URL of the ontology. This can be a web accessible URL (http:// ) or a URL relative to the local file system (file://)", Utilities.getHelpIcon("addontologyButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Deletes the ontology currently selected in the list.<br>Only one ontology at a time can be deleted, and ontologies succefully loaded cannot be deleted (reset is anyway possible through the analysis settings panel)</html>", Utilities.getHelpIcon("deleteOntologyButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Issues loading of ontologies (this may take some time)</html>", Utilities.getHelpIcon("loadOntologiesButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Changes the current analysis context to the selected one.</html>", Utilities.getHelpIcon("activateContextButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    @Override
    public String getPanelName() {
        return "Loading ontologies";
    }

    @Override
    public int getStatusLevel() {
        if (this.ontologyManager.ontologiesPresentAndCorrectlyLoaded()) {
            return 3;
        }
        if (this.ontologyManager.ontologiesPresentAndNeverLoaded()) {
            return 2;
        }
        return 1;
    }

    @Override
    public void refresh() {
    }

    private class StatusCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public StatusCellRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = (String)object;
            this.setText(string);
            if (string.startsWith("Loading")) {
                this.setBackground(Color.YELLOW);
            } else if (string.startsWith("Read ")) {
                this.setBackground(Color.GREEN);
            } else if (string.startsWith("ERROR")) {
                this.setBackground(Color.RED);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    private class LoadButtonListener
    implements ActionListener {
        private LoadButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OntologyManagerLoaderPanel.this.ontologyManager.loadOntologiesFromScratch();
        }
    }

    private class DeleteOntologyButtonListener
    implements ActionListener {
        private int[] toDelete = null;

        private DeleteOntologyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.toDelete = OntologyManagerLoaderPanel.this.ontologyTable.getSelectedRows();
            for (int i = 0; i < this.toDelete.length; ++i) {
                OntologyManagerLoaderPanel.this.ontologyManager.deleteOntology(this.toDelete[i]);
            }
        }
    }

    private class AddOntologyButtonListener
    implements ActionListener {
        private AddOntologyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane jOptionPane = new JOptionPane();
            String string = JOptionPane.showInputDialog("Enter URL for ontology (http:// or file:// must be prefixed", (Object)"");
            OntologyManagerLoaderPanel.this.ontologyManager.addURL(string);
        }
    }
}

