/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.patterns;

import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.browsing.ResultTableViewer;
import fr.pasteur.sysbio.rdfscape.computing.PatternEvaluatedTable;
import fr.pasteur.sysbio.rdfscape.ontologyhandling.RDFResourceWrapper;
import fr.pasteur.sysbio.rdfscape.ontologyhandling.RDFWrappersFactory;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public class PatternElementPanel
extends JPanel {
    PatternElement myPatternElement = null;
    JButton plotValueButton = null;
    JButton computeButton = null;
    JButton plotPValueButton = null;
    JComboBox randOptionBox = null;
    JButton searchVariableButton = null;
    JButton addVariableButton = null;
    JButton searchPatternButton = null;
    JButton addPatternButton = null;
    JButton deletePatternButton = null;

    public PatternElementPanel(PatternElement patternElement) {
        System.out.println("Building pattern panel. LimitedMode= " + DefaultSettings.limitedMode);
        this.myPatternElement = patternElement;
        if (!DefaultSettings.limitedMode) {
            this.setLayout(new GridLayout(2, 2));
        } else {
            this.setLayout(new GridLayout(2, 1));
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(new ImageIcon(this.myPatternElement.getImage())));
        jTabbedPane.add((Component)jPanel, "graph");
        JTable jTable = new JTable(this.myPatternElement);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTabbedPane.add((Component)jScrollPane, "Pattern");
        final ResultTableViewer resultTableViewer = new ResultTableViewer();
        resultTableViewer.setEnabled(false);
        JScrollPane jScrollPane2 = new JScrollPane(resultTableViewer);
        jTabbedPane.add((Component)jScrollPane2, "Matches");
        final JTextArea jTextArea = new JTextArea();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternElementPanel.this.myPatternElement.addPatternFunction(jTextArea.getText());
                if (PatternElementPanel.this.myPatternElement.hasValidRule()) {
                    PatternElementPanel.this.computeButton.setEnabled(true);
                } else {
                    PatternElementPanel.this.computeButton.setEnabled(false);
                }
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Evaluation function"));
        JButton jButton = new JButton("Commit");
        jButton.addActionListener(actionListener);
        jPanel2.add((Component)jTextArea, "Center");
        jPanel2.add((Component)jButton, "South");
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        JLabel jLabel = new JLabel("Chart");
        final JTable jTable2 = new JTable(this.myPatternElement.getPatternEvaluatedData());
        JScrollPane jScrollPane3 = new JScrollPane(jTable2);
        jTabbedPane2.add((Component)jLabel, "Chart");
        jTabbedPane2.add((Component)jScrollPane3, "Results");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resultTableViewer.setModel(PatternElementPanel.this.myPatternElement.searchVariable());
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resultTableViewer.setModel(PatternElementPanel.this.myPatternElement.addVariable());
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resultTableViewer.setModel(PatternElementPanel.this.myPatternElement.searchPattern());
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resultTableViewer.setModel(PatternElementPanel.this.myPatternElement.addPattern());
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEvaluatedTable patternEvaluatedTable = PatternElementPanel.this.myPatternElement.computeFunction(0, (String)PatternElementPanel.this.randOptionBox.getSelectedItem());
                if (patternEvaluatedTable.getRowCount() > 0) {
                    PatternElementPanel.this.plotValueButton.setEnabled(true);
                    resultTableViewer.setModel(PatternElementPanel.this.myPatternElement.getPatternMatchedTable());
                } else {
                    PatternElementPanel.this.plotValueButton.setEnabled(false);
                }
                jTable2.setModel(patternEvaluatedTable);
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternElementPanel.this.myPatternElement.addValues();
            }
        };
        ActionListener actionListener8 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternElementPanel.this.myPatternElement.addPValues();
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this pattern?");
                if (n == 0) {
                    PatternElementPanel.this.myPatternElement.remove();
                }
            }
        };
        JPanel jPanel3 = new JPanel();
        this.searchVariableButton = new JButton("Search variables");
        this.addVariableButton = new JButton("Add variables");
        this.searchPatternButton = new JButton("Search patterns");
        this.addPatternButton = new JButton("Add patterns");
        this.deletePatternButton = new JButton("Delete pattern");
        this.deletePatternButton.setBackground(Color.RED);
        this.deletePatternButton.setOpaque(true);
        this.refreshAfterKnowledgeWrapperChange();
        this.computeButton = new JButton("Compute Function");
        this.computeButton.setEnabled(false);
        this.plotValueButton = new JButton("Plot value");
        this.plotValueButton.setEnabled(false);
        this.plotPValueButton = new JButton("Plot pvalue");
        this.plotPValueButton.setEnabled(false);
        this.searchVariableButton.addActionListener(actionListener2);
        this.addVariableButton.addActionListener(actionListener3);
        this.searchPatternButton.addActionListener(actionListener4);
        this.addPatternButton.addActionListener(actionListener5);
        this.computeButton.addActionListener(actionListener6);
        this.plotValueButton.addActionListener(actionListener7);
        this.plotPValueButton.addActionListener(actionListener8);
        this.deletePatternButton.addActionListener(actionListener9);
        final JTextField jTextField = new JTextField(5);
        JButton jButton2 = new JButton("Random");
        String[] stringArray = new String[]{"total", "gene"};
        this.randOptionBox = new JComboBox<String>(stringArray);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 3));
        jPanel4.setBorder(new TitledBorder("Random eval"));
        ActionListener actionListener10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                try {
                    n = new Integer(jTextField.getText());
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n > 0) {
                    PatternEvaluatedTable patternEvaluatedTable = PatternElementPanel.this.myPatternElement.computeFunction(n, (String)PatternElementPanel.this.randOptionBox.getSelectedItem());
                    jTable2.setModel(patternEvaluatedTable);
                    PatternElementPanel.this.plotPValueButton.setEnabled(true);
                } else {
                    PatternElementPanel.this.plotPValueButton.setEnabled(false);
                }
            }
        };
        jButton2.addActionListener(actionListener10);
        jPanel4.add(jTextField);
        jPanel4.add(jButton2);
        jPanel4.add(this.randOptionBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder("Add rule"));
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        String[] stringArray2 = new String[]{"value", "pvalue"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        String[] stringArray3 = new String[]{">", "<"};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray3);
        final JTextField jTextField2 = new JTextField(5);
        jPanel6.setLayout(new GridLayout(1, 5));
        String[] stringArray4 = new String[]{"pattern", "rule"};
        final JComboBox<String> jComboBox3 = new JComboBox<String>(stringArray4);
        final JTextArea jTextArea2 = new JTextArea();
        JButton jButton3 = new JButton("Add Rule/Pattern");
        ActionListener actionListener11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternElementPanel.this.myPatternElement.triggerRule((String)jComboBox.getSelectedItem(), (String)jComboBox2.getSelectedItem(), jTextField2.getText(), jTextArea2.getText(), (String)jComboBox3.getSelectedItem());
            }
        };
        jButton3.addActionListener(actionListener11);
        jTextArea2.setBorder(new TitledBorder("rule"));
        jPanel6.add(jComboBox);
        jPanel6.add(jComboBox2);
        jPanel6.add(jTextField2);
        jPanel6.add(jComboBox3);
        jPanel6.add(jButton3);
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jTextArea2, "Center");
        JPanel jPanel7 = new JPanel();
        if (!DefaultSettings.limitedMode) {
            jPanel7.setLayout(new GridLayout(3, 3));
        }
        if (DefaultSettings.limitedMode) {
            jPanel7.setLayout(new GridLayout(2, 3));
        }
        jPanel7.add(this.searchVariableButton);
        jPanel7.add(this.addVariableButton);
        jPanel7.add(new JLabel());
        jPanel7.add(this.searchPatternButton);
        jPanel7.add(this.addPatternButton);
        jPanel7.add(this.deletePatternButton);
        if (!DefaultSettings.limitedMode) {
            jPanel7.add(this.computeButton);
        }
        if (!DefaultSettings.limitedMode) {
            jPanel7.add(this.plotValueButton);
        }
        if (!DefaultSettings.limitedMode) {
            jPanel7.add(this.plotPValueButton);
        }
        if (!DefaultSettings.limitedMode) {
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel7, "North");
            jPanel3.add((Component)jPanel4, "South");
            jPanel3.add((Component)jPanel5, "Center");
        }
        if (DefaultSettings.limitedMode) {
            jPanel3.add(jPanel7);
        }
        this.add(jTabbedPane);
        if (!DefaultSettings.limitedMode) {
            this.add(jTabbedPane2);
        }
        if (!DefaultSettings.limitedMode) {
            this.add(jPanel2);
        }
        this.add(jPanel3);
    }

    public void refreshAfterKnowledgeWrapperChange() {
        if (this.myPatternElement.canAddAndSearchPatterns()) {
            this.searchVariableButton.setEnabled(true);
            this.addVariableButton.setEnabled(true);
            this.searchPatternButton.setEnabled(true);
            this.addPatternButton.setEnabled(true);
        } else {
            this.searchVariableButton.setEnabled(false);
            this.addVariableButton.setEnabled(false);
            this.searchPatternButton.setEnabled(false);
            this.addPatternButton.setEnabled(false);
        }
    }

    public class BiteRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return null;
        }
    }

    public class UriRenderer
    extends JLabel
    implements TableCellRenderer {
        RDFWrappersFactory myWrapperFactory;

        public UriRenderer(RDFWrappersFactory rDFWrappersFactory) {
            this.setOpaque(true);
            this.myWrapperFactory = rDFWrappersFactory;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RDFResourceWrapper rDFResourceWrapper = this.myWrapperFactory.makeRDFResourceWrapper((String)object);
            this.setForeground(rDFResourceWrapper.getColor());
            this.setText(rDFResourceWrapper.getDisplayText());
            return this;
        }
    }
}

