/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.query;

import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class StringQueryEngine
extends MyQueryEngine {
    private StringQueryPanel myPanel = null;

    public StringQueryEngine() throws Exception {
        try {
            RDQLQueryAnswerer rDQLQueryAnswerer = (RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine());
        }
        catch (Exception exception) {
            throw new Exception("StringQuery not supported by this KnowledgeWrapper");
        }
        this.myPanel = new StringQueryPanel(this);
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    public void setQuery(String string) {
    }

    @Override
    public AbstractQueryResultTable makeQuery() {
        String string = "";
        if (this.myPanel.getIsApprox()) {
            string = "SELECT ?x WHERE (?x ?y ?z) AND ( ?x =~/" + this.myPanel.getText() + "/ || ?z =~ /" + this.myPanel.getText() + "/)";
            System.out.println("Approx query");
        } else {
            string = "SELECT ?x WHERE (?x ?y ?z) AND ( ?x =/" + this.myPanel.getText() + "/ || ?z = /" + this.myPanel.getText() + "/)";
            System.out.println("Exact query");
        }
        try {
            return ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(string);
        }
        catch (Exception exception) {
            RDFScape.warn("Try to make a RDQL query (you thought it was a string...) albeit I don't know how. This should not happen");
            return new JenaQueryResultTable();
        }
    }

    @Override
    public String getLabel() {
        return "StringQuery";
    }

    @Override
    public void reset() {
    }

    private class StringQueryPanel
    extends JPanel {
        private StringQueryEngine stringQueryManagerItem = null;
        private JTextField resource = null;
        private JCheckBox approx = null;

        public StringQueryPanel(StringQueryEngine stringQueryEngine2) {
            this.stringQueryManagerItem = stringQueryEngine2;
            this.setBorder(new TitledBorder("String query"));
            this.resource = new JTextField(30);
            this.approx = new JCheckBox("Approx");
            this.reset();
            this.add(this.resource);
            this.add(this.approx);
        }

        public void reset() {
            this.resource.setText("");
            this.approx.setSelected(false);
        }

        public String getText() {
            return this.resource.getText();
        }

        public boolean getIsApprox() {
            return this.approx.isSelected();
        }
    }
}

