/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class QueryIterProject
extends QueryIterConvert {
    VarExprList projectionVars;

    public QueryIterProject(QueryIterator input, VarExprList vars, ExecutionContext qCxt) {
        super(input, QueryIterProject.project(vars, qCxt), qCxt);
        this.projectionVars = vars;
    }

    static QueryIterConvert.Converter project(VarExprList vars, ExecutionContext qCxt) {
        if (vars.getExprs().isEmpty()) {
            return new Projection(vars.getVars(), qCxt);
        }
        return new ProjectionExpr(vars, qCxt);
    }

    public VarExprList getProjectionVars() {
        return this.projectionVars;
    }

    protected void releaseResources() {
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.print(" ");
        PrintUtils.printList(out, (Collection)this.projectionVars.getVars());
    }

    static class ProjectionExpr
    implements QueryIterConvert.Converter {
        FunctionEnv funcEnv;
        VarExprList projectionVars;

        ProjectionExpr(VarExprList vars, ExecutionContext qCxt) {
            this.projectionVars = vars;
            this.funcEnv = qCxt;
        }

        public Binding convert(Binding bind) {
            BindingMap b = new BindingMap(bind);
            Iterator iter = this.projectionVars.getVars().iterator();
            while (iter.hasNext()) {
                Node n;
                Var v = (Var)((Object)iter.next());
                if (!this.projectionVars.hasExpr(v) || (n = this.projectionVars.get(v, bind, this.funcEnv)) == null) continue;
                b.add(v, n);
            }
            return new BindingProject(this.projectionVars.getVars(), b);
        }
    }

    static class Projection
    implements QueryIterConvert.Converter {
        List projectionVars;

        Projection(List vars, ExecutionContext qCxt) {
            this.projectionVars = vars;
        }

        public Binding convert(Binding bind) {
            return new BindingProject(this.projectionVars, bind);
        }
    }
}

