/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import com.ibm.icu.util.StringTokenizer;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapperOptionPanel;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapperPanel;
import fr.pasteur.sysbio.rdfscape.cytomapper.MapperTable;
import fr.pasteur.sysbio.rdfscape.cytomapper.MappingRule;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class CytoMapper
implements RDFScapeModuleInterface,
Contextualizable {
    CytoscapeDealer cytoscapeDealer = null;
    CytoMapperPanel myPanel = null;
    CytoMapperOptionPanel myOptionPanel = null;
    Hashtable<String, MappingRule> mappingRuleList = null;
    MapperTable mapperTable = null;
    public int clashes = 0;
    public int totalURIs = 0;
    public int totalIDs = 0;
    public int totalMatchedID = 0;
    public int totalMatchedURI = 0;
    public int multi = 0;
    ExpressionData myData = null;
    double[][] dataMatrix = null;
    Hashtable<String, Integer> uriToDataIndex = null;
    Hashtable conditionToDataMapping = null;
    Hashtable<String, String> id2URI = null;
    Hashtable<String, ArrayList<String>> uri2ID = null;
    int numberOfConditions = 0;
    int numberOfGenesWithData = 0;
    int numberOfURIsWithData = 0;
    int numberOfDataGenesInUse = 0;

    public CytoMapper() throws Exception {
        System.out.print("Init CytoMapper...");
        this.mapperTable = new MapperTable();
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Unable to build CytoMapper : missing ContextManager");
        }
        if (RDFScape.getCytoscapeDealer() == null) {
            throw new Exception("Unable to build CytoMapper : missing Cytoscape Dealer");
        }
        System.out.print("prerequisites ok");
        RDFScape.getContextManager().addContextualizableElement(this);
        this.cytoscapeDealer = RDFScape.getCytoscapeDealer();
        this.initialize();
        System.out.println("CytoMapper init successful");
    }

    @Override
    public boolean initialize() {
        this.mappingRuleList = new Hashtable();
        this.uriToDataIndex = new Hashtable();
        this.conditionToDataMapping = new Hashtable();
        if (this.myOptionPanel != null) {
            this.myOptionPanel.reset();
            this.myOptionPanel.resetAfterKnowledgeBaseChange();
        }
        this.id2URI = new Hashtable();
        this.uri2ID = new Hashtable();
        this.resetMapping();
        return true;
    }

    public void resetMapping() {
        this.id2URI = new Hashtable();
        this.uri2ID = new Hashtable();
        this.mapperTable.reset();
        this.clashes = 0;
        this.totalURIs = 0;
        this.totalIDs = 0;
        this.totalMatchedID = 0;
        this.totalMatchedURI = 0;
        this.multi = 0;
    }

    public CytoMapperOptionPanel getOptionPanel() {
        if (this.myOptionPanel == null) {
            this.myOptionPanel = new CytoMapperOptionPanel(this);
        }
        return this.myOptionPanel;
    }

    public CytoMapperPanel getCytoMapperPanel() {
        if (this.myPanel == null) {
            this.myPanel = new CytoMapperPanel(this);
        }
        return this.myPanel;
    }

    public void addMappingRule(MappingRule mappingRule) {
        this.mappingRuleList.put(mappingRule.name, mappingRule);
        this.myOptionPanel.refresh();
    }

    public void parseAndAddMappingRule(String string) {
        String string2 = new String();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        System.out.println("Parsing rule:\n" + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("NAME:")) {
                string3 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("ID:")) {
                string5 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("URI:")) {
                string4 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("PATTERN:")) {
                string2 = string2.concat(stringTokenizer.nextToken());
                continue;
            }
            string2 = string2.concat(" " + string6);
        }
        MappingRule mappingRule = new MappingRule();
        mappingRule.name = string3;
        mappingRule.patternText = string2;
        mappingRule.uriVar = string4;
        mappingRule.idVar = string5;
        if (mappingRule.isValid()) {
            this.addMappingRule(mappingRule);
            System.out.println("Got it\n");
        } else {
            System.out.println("Didn't like it\n");
        }
    }

    public Hashtable getGenesMapping() {
        return this.uriToDataIndex;
    }

    public Hashtable getConditionMappings() {
        return this.conditionToDataMapping;
    }

    public void resolve() {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        this.resetMapping();
        for (String string : this.mappingRuleList.keySet()) {
            System.out.println("rule : " + string);
            MappingRule mappingRule = this.mappingRuleList.get(string);
            String string2 = "SELECT " + mappingRule.uriVar + " " + mappingRule.idVar + " \n WHERE " + mappingRule.patternText + "\n";
            String string3 = new String();
            String[] stringArray = commonMemory.getNamespaces();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = commonMemory.getNamespacePrefix(stringArray[i]);
                if (string4 == null || string4.equalsIgnoreCase("")) continue;
                string3 = string3 + string4 + " for <" + stringArray[i] + ">,\n";
            }
            if (string3.length() > 1) {
                string3 = string3.substring(0, string3.length() - 2);
                string2 = string2 + "USING\n" + string3 + "\n";
            }
            System.out.println(string2);
            AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(string2);
            this.analyze(abstractQueryResultTable);
            this.mapperTable.add(abstractQueryResultTable);
            this.mapperTable.fireTableDataChanged();
            RDFScape.mappingActionPerformed();
        }
    }

    private void analyze(AbstractQueryResultTable abstractQueryResultTable) {
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            if (!abstractQueryResultTable.isURI(i, 0) || !abstractQueryResultTable.isLiteral(i, 1)) continue;
            String string = abstractQueryResultTable.getURI(i, 0);
            String string2 = abstractQueryResultTable.getDatatypeValue(i, 1);
            ArrayList<String> arrayList = this.uri2ID.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.uri2ID.put(string, arrayList);
            } else if (!arrayList.contains(string2)) {
                ++this.multi;
            }
            arrayList.add(string2);
            if (this.id2URI.get(string2) == null) {
                this.id2URI.put(string2, string);
                continue;
            }
            if (this.id2URI.get(string2).equals(string)) continue;
            ++this.clashes;
            System.out.println("Clash for:\n " + string2 + " " + string + "\nVs");
            System.out.println(string2 + " " + this.id2URI.get(string2) + "\n");
        }
        this.totalIDs = this.id2URI.keySet().size();
        this.totalURIs = this.uri2ID.keySet().size();
    }

    private void analyzeExtended(AbstractQueryResultTable abstractQueryResultTable) {
        System.out.println("Analyzing matchings");
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            System.out.print(i + ":");
            if (!abstractQueryResultTable.isURI(i, 0)) continue;
            String string = abstractQueryResultTable.getURI(i, 0);
            System.out.print(string + "->");
            String string2 = null;
            if (abstractQueryResultTable.isLiteral(i, 1)) {
                string2 = abstractQueryResultTable.getDatatypeValue(i, 1);
                System.out.print(string2 + "(l)");
            } else if (abstractQueryResultTable.isURI(i, 0)) {
                string2 = abstractQueryResultTable.getURI(i, 1);
                System.out.print(string2);
            } else {
                System.out.println("X");
                break;
            }
            ArrayList<String> arrayList = this.uri2ID.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.uri2ID.put(string, arrayList);
            } else if (!arrayList.contains(string2)) {
                ++this.multi;
            }
            arrayList.add(string2);
            if (this.id2URI.get(string2) == null) {
                this.id2URI.put(string2, string);
                continue;
            }
            if (this.id2URI.get(string2).equals(string)) continue;
            ++this.clashes;
            System.out.println("Clash for:\n " + string2 + " " + string + "\nVs");
            System.out.println(string2 + " " + this.id2URI.get(string2) + "\n");
        }
        this.totalIDs = this.id2URI.keySet().size();
        this.totalURIs = this.uri2ID.keySet().size();
    }

    public void map() {
        System.out.println("Map");
        int[] nArray = this.cytoscapeDealer.mapNodes(this.id2URI);
        this.totalMatchedID = nArray[0];
        this.totalMatchedURI = nArray[1];
    }

    public boolean preLinkData() {
        this.myData = this.cytoscapeDealer.getExpressionData();
        if (this.myData == null) {
            System.out.println("No microarray data present");
            RDFScape.warn("Load microarray data first!");
            return false;
        }
        this.numberOfConditions = this.myData.getNumberOfConditions();
        System.out.println("Number of conditions for expression data: " + this.numberOfConditions);
        this.numberOfGenesWithData = this.myData.getNumberOfGenes();
        System.out.println("Total number of \"genes\" with associated data: " + this.myData.getNumberOfGenes());
        System.out.println("I have a " + this.myData.getNumberOfGenes() + " x " + this.myData.getNumberOfConditions() + " matrix in mind");
        return true;
    }

    public void linkData() {
        AbstractList abstractList;
        this.numberOfURIsWithData = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.uri2ID.keySet()) {
            String string2;
            ArrayList<String> arrayList = this.uri2ID.get(string);
            if (arrayList.size() > 1) {
                System.out.println("More than one Cytoscape Node for URI: " + string + ", considering only an arbitrary one");
            }
            if (arrayList.size() == 0) {
                System.out.println("No IDs for URI: " + string + ", this should not happen here!");
            }
            if ((abstractList = this.myData.getMeasurements(string2 = arrayList.get(0))) == null) {
                System.out.println("No measures found");
                continue;
            }
            boolean bl = true;
            for (Object object : abstractList) {
                if (object == null) {
                    bl = false;
                    continue;
                }
                if (!object.toString().equalsIgnoreCase("")) continue;
                bl = false;
            }
            if (!bl) continue;
            hashSet.add(string);
        }
        System.out.println("Filling matrix " + hashSet.size() + " x " + this.numberOfConditions);
        this.dataMatrix = new double[hashSet.size()][this.numberOfConditions];
        int n = 0;
        int n2 = 0;
        for (String string2 : hashSet) {
            Object object;
            abstractList = this.uri2ID.get(string2);
            String string = (String)((ArrayList)abstractList).get(0);
            Vector vector = this.myData.getMeasurements(string);
            System.out.println(string2 + " -> " + string + " #" + vector.size());
            this.uriToDataIndex.put(string2, new Integer(n));
            n2 = 0;
            object = vector.iterator();
            while (object.hasNext()) {
                mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)object.next();
                this.dataMatrix[n][n2] = mRNAMeasurement2.getRatio();
                ++n2;
            }
            ++n;
        }
        this.numberOfURIsWithData = hashSet.size();
        this.numberOfDataGenesInUse = hashSet.size();
        System.out.println("TEST:");
        for (int i = 0; i < this.dataMatrix.length; ++i) {
            for (int j = 0; j < this.dataMatrix[i].length; ++j) {
                System.out.print(this.dataMatrix[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public double[][] getDataMatrix() {
        return this.dataMatrix;
    }

    @Override
    public void reset() {
        this.initialize();
    }

    public void update() {
    }

    public boolean isInValidState() {
        return this.canOperate();
    }

    @Override
    public boolean canOperate() {
        return true;
    }

    @Override
    public boolean loadFromActiveContext() {
        this.initialize();
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Unable to locate mapping rules");
            return false;
        }
        try {
            Object var4_4 = null;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                System.out.println("Reading mapping rule : " + fileArray[i].getName());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                int n = 0;
                while ((n = bufferedReader.read(cArray)) >= 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                String string2 = stringBuffer.toString();
                if (!fileArray[i].isFile()) continue;
                this.parseAndAddMappingRule(string2);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to load mapping rules");
            return false;
        }
        return true;
    }

    @Override
    public boolean saveToContext() {
        System.out.println("Saving...");
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Unable to locate mapping rules");
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        Enumeration<String> enumeration = this.mappingRuleList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            System.out.println("Going to save: " + string2);
            MappingRule mappingRule = this.mappingRuleList.get(string2);
            File file2 = new File(string + "/" + string2);
            try {
                FileWriter fileWriter = new FileWriter(file2);
                fileWriter.write("NAME: " + mappingRule.getName() + "\n" + "ID: " + mappingRule.getID() + "\n" + "URI: " + mappingRule.getURI() + "\n" + "PATTERN: " + mappingRule.getRuleString());
                fileWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Unable to save mapping rule to file " + string + "/" + string2);
                return false;
            }
        }
        return true;
    }

    public boolean canResolve() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledgeEngine());
    }

    public int getNumberOfMatchedIDs() {
        return this.totalMatchedID;
    }

    public int getNumberOfMatchedURIs() {
        return this.totalMatchedURI;
    }

    public int getNumberOfURIsToBeMatched() {
        return this.totalURIs;
    }

    public int getNumberOfNodesToBeMatched() {
        return RDFScape.getCytoscapeDealer().getNodeCount();
    }

    @Override
    public void touch() {
    }

    public int getNumberOfMappingRules() {
        return this.mappingRuleList.size();
    }

    public int getNumberOfAvailableData() {
        return this.numberOfGenesWithData;
    }

    public int getNumberOfURIWithData() {
        return this.numberOfURIsWithData;
    }

    public int getNumberOfDataExtracted() {
        return this.numberOfDataGenesInUse;
    }
}

