/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.ext;

import fr.pasteur.sysbio.rdfscape.ext.FishEyeMenu;
import fr.pasteur.sysbio.rdfscape.ext.Item;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JWindow;

class FishEyeWindow
extends JWindow
implements MouseListener,
MouseMotionListener,
KeyListener {
    static final int MAX_ANTIALIAS_SIZE = 10;
    static Image up = null;
    static Image down = null;
    FishEyeMenu menu = null;
    Item[] items;
    int numItems = 0;
    Font[] fonts;
    Font[] boldFonts;
    int desiredFocusLength = 11;
    int desiredMaxFontSize = 12;
    int focusLength = this.desiredFocusLength;
    int maxFontSize = this.desiredMaxFontSize;
    int minFontSize = this.desiredMaxFontSize;
    float desiredSpacing = 0.5f;
    float minDesiredSpacing = 0.1f;
    int desiredSpace = (int)((float)this.maxFontSize * this.desiredSpacing);
    int minSpace;
    int borderLeft = this.desiredMaxFontSize + 5;
    int borderRight = 3;
    int labelBorderLeft = 3;
    int borderY = 3;
    int mouseY = 0;
    Image backBuffer = null;
    Graphics gb = null;
    Color backgroundColor = new Color(207, 207, 207);
    Color hilightColor = new Color(144, 151, 207);
    Color labelColor = Color.black;
    int selectionIndex = 0;
    int focusIndex = 0;
    int[] focusIndexLUT;
    String[] labelLUT;
    int[] labelPosLUT;
    int[][] sizeLUT;
    int[][] spaceLUT;
    int flFocusPosition;
    int[] flSizeLUT;
    int[] flSpaceLUT;
    int numLabels = 0;
    boolean focusLock = false;

    public FishEyeWindow(FishEyeMenu fishEyeMenu) {
        int n;
        this.menu = fishEyeMenu;
        this.items = new Item[10];
        for (n = 0; n < this.items.length; ++n) {
            this.items[n] = new Item();
        }
        this.fonts = new Font[this.maxFontSize + 1];
        for (n = 1; n <= this.maxFontSize; ++n) {
            this.fonts[n] = new Font(null, 0, n);
        }
        this.boldFonts = new Font[this.maxFontSize + 1];
        for (n = 1; n <= this.maxFontSize; ++n) {
            this.boldFonts[n] = new Font(null, 1, n);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        if (up == null) {
            URL uRL = this.getClass().getClassLoader().getResource("arrow-up.gif");
            up = Toolkit.getDefaultToolkit().createImage(uRL);
            uRL = this.getClass().getClassLoader().getResource("arrow-down.gif");
            down = Toolkit.getDefaultToolkit().createImage(uRL);
        }
    }

    public void setDesiredMaxFontSize(int n) {
        if (n > this.desiredMaxFontSize) {
            int n2;
            Font[] fontArray = new Font[n + 1];
            Font[] fontArray2 = new Font[n + 1];
            for (n2 = 1; n2 <= this.desiredMaxFontSize; ++n2) {
                fontArray[n2] = this.fonts[n2];
                fontArray2[n2] = this.boldFonts[n2];
            }
            for (n2 = this.desiredMaxFontSize + 1; n2 <= n; ++n2) {
                fontArray[n2] = new Font(null, 0, n2);
                fontArray2[n2] = new Font(null, 1, n2);
            }
            this.fonts = fontArray;
            this.boldFonts = fontArray2;
        }
        this.desiredMaxFontSize = n;
        this.desiredSpace = (int)((float)n * this.desiredSpacing);
        this.borderLeft = n + 5;
    }

    public void setDesiredFocusLength(int n) {
        this.desiredFocusLength = n;
        this.calculateSizes();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.calculateSizes();
            this.focusIndex = 0;
            this.selectionIndex = 0;
            this.mouseY = 0;
            this.focusLock = false;
            this.labelColor = Color.black;
        }
        super.setVisible(bl);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getX() < this.getSize().width / 2) {
            if (this.focusLock) {
                this.repaint();
            }
            this.focusLock = false;
        } else {
            if (!this.focusLock) {
                this.flFocusPosition = this.borderY;
                for (n = 0; n < this.numItems; ++n) {
                    this.flSizeLUT[n] = this.sizeLUT[this.focusIndex][n];
                    this.flSpaceLUT[n] = this.spaceLUT[this.focusIndex][n];
                    if (n >= this.focusIndex) continue;
                    this.flFocusPosition += this.flSizeLUT[n] + this.flSpaceLUT[n];
                }
            }
            this.focusLock = true;
        }
        this.mouseY = mouseEvent.getY();
        if (this.focusLock) {
            int n2;
            int n3;
            n = 0;
            if (this.mouseY > this.flFocusPosition) {
                n3 = this.flFocusPosition;
                this.selectionIndex = this.focusIndex;
                n2 = this.focusIndex;
                while (n2 < this.numItems) {
                    if (this.flSizeLUT[n2] < this.maxFontSize) {
                        this.flSizeLUT[n2] = this.maxFontSize;
                        this.flSpaceLUT[n2] = this.desiredSpace;
                        n = 1;
                    }
                    this.selectionIndex = n2++;
                    if (this.mouseY < (n3 += this.flSizeLUT[n2] + this.flSpaceLUT[n2])) break;
                }
                if (++n2 < this.numItems && this.flSizeLUT[n2] < this.maxFontSize) {
                    boolean bl = false;
                    while (n2 < this.numItems && !bl) {
                        if (this.flSizeLUT[n2] == this.minFontSize) {
                            bl = true;
                        }
                        if (this.flSizeLUT[n2] < this.maxFontSize) {
                            int n4 = n2;
                            this.flSizeLUT[n4] = this.flSizeLUT[n4] + 1;
                            if (this.flSizeLUT[n2] == this.maxFontSize) {
                                this.flSpaceLUT[n2] = this.desiredSpace;
                                n = 1;
                            }
                        }
                        ++n2;
                    }
                }
            } else if (this.focusIndex > 0) {
                n3 = this.flFocusPosition - this.flSizeLUT[this.focusIndex - 1] - this.flSpaceLUT[this.focusIndex - 1];
                this.selectionIndex = this.focusIndex;
                for (n2 = this.focusIndex - 1; n2 >= 0; --n2) {
                    if (this.flSizeLUT[n2] < this.maxFontSize) {
                        this.flSizeLUT[n2] = this.maxFontSize;
                        this.flSpaceLUT[n2] = this.desiredSpace;
                        n = 1;
                    }
                    this.selectionIndex = n2;
                    if (this.mouseY > n3) break;
                    n3 -= this.flSizeLUT[n2] + this.flSpaceLUT[n2];
                }
                if (--n2 >= 0 && this.flSizeLUT[n2] < this.maxFontSize) {
                    boolean bl = false;
                    while (n2 >= 0 && !bl) {
                        if (this.flSizeLUT[n2] == this.minFontSize) {
                            bl = true;
                        }
                        if (this.flSizeLUT[n2] < this.maxFontSize) {
                            int n5 = n2;
                            this.flSizeLUT[n5] = this.flSizeLUT[n5] + 1;
                            if (this.flSizeLUT[n2] == this.maxFontSize) {
                                this.flSpaceLUT[n2] = this.desiredSpace;
                                n = 1;
                            }
                        }
                        --n2;
                    }
                }
            }
            if (n != 0) {
                n2 = this.backgroundColor.getRed();
                n3 = this.labelColor.getRed() + 30;
                if (n3 > n2) {
                    n3 = n2;
                }
                this.labelColor = new Color(n3, n3, n3);
            }
            this.repaint();
        } else {
            n = this.focusIndex;
            this.selectionIndex = this.focusIndex = this.focusIndexLUT[this.mouseY];
            this.labelColor = Color.black;
            this.repaintDamagedRegion(n);
        }
    }

    void repaintDamagedItem(int n) {
        int n2;
        int n3 = this.borderY;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += this.sizeLUT[this.focusIndex][n2] + this.spaceLUT[this.focusIndex][n2];
        }
        n2 = this.sizeLUT[this.focusIndex][n] + this.spaceLUT[this.focusIndex][n];
        this.repaint(this.borderLeft, n3, this.getSize().width - this.borderLeft - this.borderRight, n2);
    }

    void repaintDamagedRegion(int n) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = this.borderY;
        for (n3 = 0; n3 < this.numItems; ++n3) {
            if (n4 == -1 && this.sizeLUT[n][n3] > this.minFontSize) {
                n4 = n8;
            } else if (n4 >= 0 && this.sizeLUT[n][n3] == this.minFontSize) {
                n6 = n8 - n4;
                break;
            }
            n8 += this.sizeLUT[n][n3] + this.spaceLUT[n][n3];
        }
        if (n6 == -1) {
            n6 = this.getSize().height - n4;
        }
        n8 = this.borderY;
        for (n3 = 0; n3 < this.numItems; ++n3) {
            if (n5 == -1 && this.sizeLUT[this.focusIndex][n3] > this.minFontSize) {
                n5 = n8;
            } else if (n5 >= 0 && this.sizeLUT[this.focusIndex][n3] == this.minFontSize) {
                n7 = n8 - n5;
                break;
            }
            n8 += this.sizeLUT[this.focusIndex][n3] + this.spaceLUT[this.focusIndex][n3];
        }
        if (n7 == -1) {
            n7 = this.getSize().height - n5;
        }
        if (n4 < n5) {
            n8 = n4;
            n2 = n7 + (n5 - n4);
        } else {
            n8 = n5;
            n2 = n6 + (n4 - n5);
        }
        this.repaint(this.borderLeft, n8, this.getSize().width - this.borderLeft - this.borderRight, n2);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.items[this.selectionIndex].menuItem.doClick();
        this.menu.fireMenuCanceled();
        this.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        block0 : switch (n) {
            case 38: {
                if (this.selectionIndex <= 0) break;
                --this.selectionIndex;
                --this.focusIndex;
                this.repaint();
                break;
            }
            case 40: {
                if (this.selectionIndex >= this.numItems - 1) break;
                ++this.selectionIndex;
                ++this.focusIndex;
                this.repaint();
                break;
            }
            case 10: {
                this.items[this.selectionIndex].menuItem.doClick();
                this.menu.fireMenuCanceled();
                break;
            }
            default: {
                char c = Character.toUpperCase(keyEvent.getKeyChar());
                if (!Character.isLetter(c)) break;
                if (Character.toUpperCase(this.items[this.selectionIndex].label.charAt(0)) == c) {
                    ++this.selectionIndex;
                    ++this.focusIndex;
                    this.repaint();
                }
                if (this.selectionIndex < this.numItems && Character.toUpperCase(this.items[this.selectionIndex].label.charAt(0)) == c) break;
                for (int i = 0; i < this.numItems; ++i) {
                    if (Character.toUpperCase(this.items[i].label.charAt(0)) != c) continue;
                    this.selectionIndex = i;
                    this.focusIndex = i;
                    this.repaint();
                    break block0;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void add(JMenuItem jMenuItem) {
        try {
            this.items[this.numItems].menuItem = jMenuItem;
            this.items[this.numItems].label = jMenuItem.getText();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Item[] itemArray = new Item[this.numItems == 0 ? 1 : 2 * this.numItems];
            System.arraycopy(this.items, 0, itemArray, 0, this.numItems);
            this.items = itemArray;
            for (int i = this.numItems; i < this.items.length; ++i) {
                this.items[i] = new Item();
            }
            this.items[this.numItems].menuItem = jMenuItem;
            this.items[this.numItems].label = jMenuItem.getText();
        }
        ++this.numItems;
    }

    public void calculateSizes() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        this.focusLength = this.desiredFocusLength;
        this.maxFontSize = this.desiredMaxFontSize;
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        for (n8 = 0; n8 < this.numItems; ++n8) {
            float f = (float)this.fonts[this.maxFontSize].getStringBounds(this.items[n8].label, fontRenderContext).getWidth();
            if (!(f > (float)n9)) continue;
            n9 = (int)f + this.borderLeft + this.borderRight;
        }
        Point point = this.getLocation();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        n11 = dimension.height - point.y - 30;
        int n12 = n9 - (this.borderLeft + this.borderRight);
        int n13 = n11 - 2 * this.borderY;
        boolean bl = false;
        do {
            for (n7 = this.maxFontSize; n7 >= 1; --n7) {
                n6 = this.calculateWindowHeight(n7);
                if (n6 > n11) continue;
                n10 = n6;
                this.minFontSize = n7;
                this.minSpace = n7 == this.maxFontSize ? this.desiredSpace : (int)((float)this.minFontSize * this.minDesiredSpacing);
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.focusLength > 2) {
                this.focusLength -= 2;
                continue;
            }
            --this.maxFontSize;
        } while (!bl);
        if (n7 < this.maxFontSize) {
            n10 = n11;
        }
        this.setSize(n9, n10);
        this.backBuffer = null;
        this.sizeLUT = new int[this.numItems][this.numItems];
        this.spaceLUT = new int[this.numItems][this.numItems];
        this.flSizeLUT = new int[this.numItems];
        this.flSpaceLUT = new int[this.numItems];
        for (n8 = 0; n8 < this.numItems; ++n8) {
            int n14 = this.focusLength / 2;
            n5 = this.borderY;
            for (n4 = 0; n4 < this.numItems; ++n4) {
                int n15;
                n6 = Math.abs(n4 - n8);
                if (n6 > n14) {
                    n7 = this.maxFontSize - (n6 -= n14);
                    n15 = (int)((float)n7 * this.desiredSpacing);
                    if (n7 <= this.minFontSize) {
                        n7 = this.minFontSize;
                        n15 = this.minSpace;
                    }
                } else {
                    n7 = this.maxFontSize;
                    n15 = this.desiredSpace;
                }
                this.sizeLUT[n8][n4] = n7;
                this.spaceLUT[n8][n4] = n15;
                n5 += n7 + n15;
            }
            n3 = this.getSize().height - n5 - 2 * this.borderY;
            if (n3 <= 0) continue;
            int n16 = n8 - n14 - 1;
            for (int i = n8 + n14 + 1; n3 > 0 && (n16 >= 0 || i < this.numItems); --n16, ++i) {
                n2 = n16;
                n = i;
                for (int j = 0; j < this.maxFontSize - this.minFontSize; ++j) {
                    if (n2 >= 0) {
                        if (n3 > 0 && this.sizeLUT[n8][n2] < this.maxFontSize) {
                            int[] nArray = this.sizeLUT[n8];
                            int n17 = n2;
                            nArray[n17] = nArray[n17] + 1;
                            --n3;
                        }
                        if (n3 > 0 && this.spaceLUT[n8][n2] < this.desiredSpace) {
                            int[] nArray = this.spaceLUT[n8];
                            int n18 = n2;
                            nArray[n18] = nArray[n18] + 1;
                            --n3;
                        }
                        --n2;
                    }
                    if (n3 <= 0 || n >= this.numItems) continue;
                    if (this.sizeLUT[n8][n] < this.maxFontSize) {
                        int[] nArray = this.sizeLUT[n8];
                        int n19 = n;
                        nArray[n19] = nArray[n19] + 1;
                        --n3;
                    }
                    if (n3 > 0 && this.spaceLUT[n8][n] < this.desiredSpace) {
                        int[] nArray = this.spaceLUT[n8];
                        int n20 = n;
                        nArray[n20] = nArray[n20] + 1;
                        --n3;
                    }
                    ++n;
                }
            }
        }
        this.focusIndexLUT = new int[n10];
        n8 = 0;
        while (n8 < this.numItems) {
            n5 = this.borderY;
            for (n4 = 0; n4 < n8; ++n4) {
                n5 += this.sizeLUT[n8][n4] + this.spaceLUT[n8][n4];
            }
            this.focusIndexLUT[n5] = n8++;
        }
        for (n8 = 1; n8 < n10; ++n8) {
            if (this.focusIndexLUT[n8] != 0) continue;
            this.focusIndexLUT[n8] = this.focusIndexLUT[n8 - 1];
        }
        n3 = 32;
        n = 0;
        this.labelLUT = new String[26];
        this.labelPosLUT = new int[26];
        this.numLabels = 0;
        for (n8 = 0; n8 < this.numItems; ++n8) {
            n2 = Character.toUpperCase(this.items[n8].label.charAt(0));
            if (n3 == n2) continue;
            n5 = this.borderY;
            for (n4 = 0; n4 < n8; ++n4) {
                n5 += this.sizeLUT[n8][n4] + this.spaceLUT[n8][n4];
            }
            if ((n5 += this.sizeLUT[n8][n8]) <= n + this.maxFontSize + 1) continue;
            this.labelLUT[this.numLabels] = new Character((char)n2).toString();
            this.labelPosLUT[this.numLabels] = n5;
            ++this.numLabels;
            n = n5;
            n3 = n2;
        }
    }

    public int calculateWindowHeight(int n) {
        int n2 = this.focusLength;
        int n3 = this.numItems;
        if (n == this.maxFontSize) {
            int n4 = n3 * (this.maxFontSize + this.desiredSpace);
            return n4;
        }
        if (n3 < n2) {
            n2 = n3;
        }
        int n5 = n2 * (this.maxFontSize + this.desiredSpace);
        n3 -= n2;
        for (int i = this.maxFontSize - 1; i > n; --i) {
            int n6 = (int)((float)i * this.desiredSpacing);
            n5 += 2 * (i + n6);
            if ((n3 -= 2) <= 0) break;
        }
        n5 += n3 * (n + (int)((float)n * this.minDesiredSpacing));
        return n5 += 2 * this.borderY;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = false;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        Rectangle rectangle = graphics.getClipBounds();
        if (this.backBuffer == null) {
            this.backBuffer = this.createImage(n3, n4);
            this.gb = this.backBuffer.getGraphics();
        }
        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.gb.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.gb.setColor(this.backgroundColor);
        this.gb.fill3DRect(0, 0, n3, n4, true);
        int n5 = this.borderY;
        int n6 = 0;
        int n7 = n4 - this.borderY;
        int n8 = 0;
        if (this.focusLock) {
            bl = true;
            n5 = this.flFocusPosition;
            for (n2 = this.focusIndex - 1; n2 >= 0; --n2) {
                n8 = this.flSizeLUT[n2];
                n = this.flSpaceLUT[n2];
                if (n8 == this.minFontSize) {
                    n6 = n5 + n8 + n;
                    break;
                }
                n5 -= n8 + n;
            }
            n5 = this.flFocusPosition;
            for (n2 = this.focusIndex; n2 < this.numItems; ++n2) {
                n8 = this.flSizeLUT[n2];
                n = this.flSpaceLUT[n2];
                if (n8 == this.minFontSize) {
                    n7 = n5;
                    break;
                }
                n5 += n8 + n;
            }
            if (n6 < this.borderY) {
                n6 = this.borderY;
            }
        } else {
            bl = true;
            for (n2 = 0; n2 < this.numItems; ++n2) {
                n8 = this.sizeLUT[this.focusIndex][n2];
                n = this.spaceLUT[this.focusIndex][n2];
                if (bl) {
                    if (n8 > this.minFontSize) {
                        n6 = n5;
                        bl = false;
                    }
                } else if (n8 == this.minFontSize) {
                    n7 = n5 - n8;
                    break;
                }
                n5 += n8 + n;
            }
        }
        this.gb.setColor(Color.lightGray);
        if (this.focusLock) {
            this.gb.fillRect(n3 / 2, n6, n3 / 2 - this.borderRight, n7 - n6);
        } else {
            this.gb.drawRect(n3 / 2, n6, n3 / 2 - this.borderRight, n7 - n6);
        }
        this.gb.setColor(Color.black);
        int n9 = this.borderLeft;
        n5 = this.borderY;
        if (!this.focusLock) {
            for (n2 = 0; n2 < this.numItems; ++n2) {
                n8 = this.sizeLUT[this.focusIndex][n2];
                n = this.spaceLUT[this.focusIndex][n2];
                if (n5 >= rectangle.y && n5 <= rectangle.y + rectangle.height) {
                    if (this.selectionIndex == n2) {
                        this.gb.setColor(this.hilightColor);
                        this.gb.fillRect(this.borderLeft, n5, n3 - (this.borderLeft + this.borderRight), n8 + n);
                        this.gb.setColor(Color.black);
                    } else {
                        this.gb.setColor(Color.black);
                    }
                    if (n8 > 10 && bl2) {
                        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                        bl2 = false;
                    } else if (n8 <= 10 && !bl2) {
                        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        bl2 = true;
                    }
                    this.gb.setFont(this.fonts[n8]);
                    this.gb.drawString(this.items[n2].label, n9, n5 + n8);
                }
                n5 += n + n8;
            }
        } else {
            if (this.focusIndex > 0) {
                n5 = this.flFocusPosition - this.flSizeLUT[this.focusIndex - 1] - this.flSpaceLUT[this.focusIndex - 1];
                for (n2 = this.focusIndex - 1; n2 >= 0 && n5 >= this.borderY; --n2) {
                    n8 = this.flSizeLUT[n2];
                    n = this.flSpaceLUT[n2];
                    if (this.selectionIndex == n2) {
                        this.gb.setColor(this.hilightColor);
                        this.gb.fillRect(this.borderLeft, n5, n3 - (this.borderLeft + this.borderRight), n8 + n);
                    }
                    this.gb.setColor(Color.black);
                    if (n8 > 10 && bl2) {
                        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                        bl2 = false;
                    } else if (n8 <= 10 && !bl2) {
                        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        bl2 = true;
                    }
                    this.gb.setFont(this.fonts[n8]);
                    this.gb.drawString(this.items[n2].label, n9, n5 + n8);
                    if (n2 <= 0) continue;
                    n5 -= this.flSizeLUT[n2 - 1] + this.flSpaceLUT[n2 - 1];
                }
            }
            n5 = this.flFocusPosition;
            for (n2 = this.focusIndex; n2 < this.numItems && n5 <= n4 - this.borderY; n5 += n + n8, ++n2) {
                n8 = this.flSizeLUT[n2];
                n = this.flSpaceLUT[n2];
                if (this.selectionIndex == n2) {
                    this.gb.setColor(this.hilightColor);
                    this.gb.fillRect(this.borderLeft, n5, n3 - (this.borderLeft + this.borderRight), n8 + n);
                }
                this.gb.setColor(Color.black);
                if (n8 > 10 && bl2) {
                    ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    bl2 = false;
                } else if (n8 <= 10 && !bl2) {
                    ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    bl2 = true;
                }
                this.gb.setFont(this.fonts[n8]);
                this.gb.drawString(this.items[n2].label, n9, n5 + n8);
            }
        }
        this.gb.setFont(this.boldFonts[this.maxFontSize]);
        this.gb.setColor(this.labelColor);
        ((Graphics2D)this.gb).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        for (n2 = 0; n2 < this.numLabels; ++n2) {
            this.gb.drawString(this.labelLUT[n2], this.labelBorderLeft, this.labelPosLUT[n2]);
        }
        if (n6 > this.borderY) {
            this.gb.drawImage(up, 3 * n3 / 4, n6 + 5, this);
        }
        if (n7 < n4 - this.borderY) {
            this.gb.drawImage(down, 3 * n3 / 4, n7 - 15, this);
        }
        graphics.drawImage(this.backBuffer, 0, 0, this);
    }
}

