/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.knowledge;

import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RichResource;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.util.ArrayList;

public abstract class KnowledgeWrapper {
    abstract boolean canAddontologies();

    public abstract boolean canAddRules();

    public abstract String addOntology(String var1);

    public abstract boolean addRuleSet(ArrayList var1);

    public abstract void setReasonerParameter(String var1, String var2);

    abstract RichResource getResourceHandler(String var1);

    public abstract void clear();

    public abstract void reset();

    public abstract void touch();

    public abstract String[][] getReasonerOptions();

    public abstract String[] getReasonerActualOptions();

    public abstract String[] getReasonerOptionNames();

    public abstract String[] getReasonerOptionsDefaultValues();

    public abstract String[][] getRuleOptions();

    public abstract String[] getRuleOptionDefaultValues();

    public abstract String[] getRuleOptionsNames();

    public abstract String validateRule(String var1);

    public abstract ArrayList getAvailableQueryManagers();

    public KnowledgeWrapper() throws Exception {
        System.out.println("\tBuilding KnowledgeWraper");
        if (RDFScape.getCommonMemory() == null) {
            throw new Exception("Unable to initialize knowledge wrapper : missing CommonMemory");
        }
        RDFScape.getCommonMemory().relinkURIID();
    }

    public static boolean hasRDQLSupport(KnowledgeWrapper knowledgeWrapper) {
        try {
            RDQLQueryAnswerer rDQLQueryAnswerer = (RDQLQueryAnswerer)((Object)knowledgeWrapper);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean hasGraphAccessSupport(KnowledgeWrapper knowledgeWrapper) {
        try {
            GraphQueryAnswerer graphQueryAnswerer = (GraphQueryAnswerer)((Object)knowledgeWrapper);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

