/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.ontologyhandling;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import java.awt.Color;
import java.util.Map;

public class RDFResourceWrapper {
    private String URI = null;
    private String shortURI = null;
    private String colorString = null;
    private String colorHexString = null;
    private Color color = null;
    private String namespace = null;
    private String prefix = null;
    private String shortname = null;
    private Map attributes = null;
    private String displayText = null;
    private String idAttribute = null;
    private RDFScape myRDFScapeInstance = null;
    private RDFNode myNode = null;
    private boolean active = false;
    private boolean isValid = true;
    private Color defaultColor = Color.BLACK;
    private String defaultColorString = "BLACK";
    private String defaultColorStringHex = "#000000";
    private Resource jenaNode = null;
    private boolean isLiteral = false;
    private static int bnodeCounter = 0;
    private String bnodeString = null;

    public RDFResourceWrapper(String string) {
        this.URI = string;
        this.displayText = string;
        this.bnodeString = "?b" + bnodeCounter;
        ++bnodeCounter;
    }

    public String getURI() {
        return this.URI;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setIsActive(boolean bl) {
        this.active = bl;
    }

    public void setNamespace(String string) {
        this.namespace = string;
        if (this.namespace == null) {
            this.isValid = false;
            this.active = false;
            this.checkIfLiteral();
        }
        if (this.namespace.equals("")) {
            this.isValid = false;
            this.active = false;
            this.checkIfLiteral();
        }
    }

    private void checkIfLiteral() {
        if (this.URI.indexOf("^^") >= 0) {
            this.isLiteral = true;
        }
        this.displayText = this.shortname;
    }

    public void setColorString(String string) {
        this.colorString = string;
    }

    public void setShortURI(String string) {
        this.shortname = string;
    }

    public void setColorHexString(String string) {
        this.colorHexString = string;
    }

    public Color getColor() {
        if (this.active) {
            return this.color;
        }
        return this.defaultColor;
    }

    public String getColorHexString() {
        if (this.active) {
            return this.colorHexString;
        }
        return this.defaultColorStringHex;
    }

    public String getColorString() {
        if (this.active) {
            return this.colorString;
        }
        return this.defaultColorString;
    }

    public String getDisplayText() {
        if (this.isLiteral) {
            int n = this.URI.indexOf("^^", 0);
            return this.URI.substring(0, n);
        }
        if (this.active) {
            return this.shortname;
        }
        return this.URI;
    }

    public boolean getIsActive() {
        return this.active;
    }

    public String getDisplayTextBracket() {
        String string = new String("<");
        return string.concat(this.getDisplayText()).concat(">");
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void addJenaNode(Resource resource) {
        this.jenaNode = resource;
    }

    public boolean isBlank() {
        if (this.jenaNode == null) {
            return false;
        }
        return this.jenaNode.isAnon();
    }

    public Resource getOntoNode() {
        return this.jenaNode;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public String getBnodeVarName() {
        return this.bnodeString;
    }
}

