/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.patterns;

import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.computing.EvaluationNode;
import fr.pasteur.sysbio.rdfscape.computing.Parser;
import fr.pasteur.sysbio.rdfscape.computing.PatternEvaluatedTable;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElementPanel;
import fr.pasteur.sysbio.rdfscape.patterns.PatternManager;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.awt.Image;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PatternElement
extends AbstractTableModel {
    private Image myImage = null;
    private String[][] myTriplesArray = null;
    private Hashtable preciseFilterConditions = null;
    private Hashtable filterConditions = null;
    private String name = null;
    private String formula = null;
    private EvaluationNode myRuleEvaluationNode = null;
    private String ontologyCondition = null;
    private int randomgeneration = 0;
    private PatternElementPanel myPanel = null;
    PatternManager myPatternManager = null;
    private String selectClause = null;
    private String patternClause = null;
    private String andClause = null;
    private String namespaceClause = null;
    private String[] varList = null;
    private AbstractQueryResultTable patternMatchedTable = null;
    private boolean hasValidPatternMatchedTable = false;
    private PatternEvaluatedTable patternEvaluatedTable = null;
    private boolean hasValidPatternEvaluatedTable = false;

    public PatternElement(String string, PatternManager patternManager) {
        this.name = string;
        this.patternMatchedTable = new JenaQueryResultTable();
        this.preciseFilterConditions = new Hashtable();
        this.filterConditions = new Hashtable();
        this.myPatternManager = patternManager;
    }

    public Image getImage() {
        return this.myImage;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String string) {
        this.formula = string;
        this.hasValidPatternEvaluatedTable = false;
    }

    public Image getMyImage() {
        return this.myImage;
    }

    public void setMyImage(Image image) {
        this.myImage = image;
    }

    public String getName() {
        return this.name;
    }

    public PatternElementPanel getMyPanel() {
        return this.myPanel;
    }

    public int getRandomgeneration() {
        return this.randomgeneration;
    }

    public String getOntologyCondition() {
        return this.ontologyCondition;
    }

    public void setOntologyCondition(String string) {
        this.ontologyCondition = string;
    }

    public PatternElementPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new PatternElementPanel(this);
        }
        return this.myPanel;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public String getPatternClause() {
        return this.patternClause;
    }

    public String getWhereClause() {
        return "WHERE  " + this.getPatternClause();
    }

    public String getANDClause() {
        return this.andClause;
    }

    public String getNamespaceClause() {
        return this.namespaceClause;
    }

    public void setNamespaceClause(String string) {
        this.namespaceClause = string;
    }

    public void searchPattern(boolean bl) {
        int n;
        this.fillPatternMatchedTable();
        System.out.println("Rows: " + this.patternMatchedTable.getRowCount());
        if (this.patternMatchedTable.getRowCount() == 0) {
            return;
        }
        System.out.println("+");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < this.patternMatchedTable.getColumnCount(); ++n) {
            hashtable.put("?" + this.patternMatchedTable.getColumnName(n), new Integer(n));
            System.out.println("index :" + this.patternMatchedTable.getColumnName(n) + "->" + n);
            System.out.println(n);
        }
        System.out.println("->" + this.myTriplesArray.length);
        for (n = 0; n < this.patternMatchedTable.getRowCount(); ++n) {
            System.out.println("Answer row: " + n);
            for (int i = 0; i < this.myTriplesArray.length; ++i) {
                System.out.println("Pattern row: " + i);
                String[] stringArray = new String[3];
                for (int j = 0; j < 3; ++j) {
                    System.out.println(">" + this.myTriplesArray[i][j]);
                    if (this.myTriplesArray[i][j].indexOf("?") != 0) {
                        stringArray[j] = this.myTriplesArray[i][j];
                        continue;
                    }
                    int n2 = (Integer)hashtable.get(this.myTriplesArray[i][j]);
                    System.out.println("->" + i);
                    stringArray[j] = (String)this.patternMatchedTable.getValueAt(n, n2);
                }
            }
        }
    }

    public void setPatternManager(PatternManager patternManager) {
        this.myPatternManager = patternManager;
    }

    public void addPatternFunction(String string) {
        this.hasValidPatternEvaluatedTable = false;
        Parser parser = new Parser();
        this.myRuleEvaluationNode = parser.parse(string);
        System.out.println(this.myRuleEvaluationNode.dump());
        if (this.myRuleEvaluationNode.hasErrors()) {
            RDFScape.warn("Wrong Syntax: " + this.myRuleEvaluationNode.getGlobalErrorString());
        }
        this.myRuleEvaluationNode.setupPatternIndependentEvaluation();
        System.out.println(this.myRuleEvaluationNode.dump());
    }

    public PatternEvaluatedTable computeFunction(int n, String string) {
        this.fillPatternMatchedTable();
        System.out.println("Query result: rows= " + this.patternMatchedTable.getRowCount());
        if (this.patternMatchedTable.getRowCount() >= 0) {
            System.out.println("Setting matches");
            this.myRuleEvaluationNode.setPatternMatches(this.patternMatchedTable);
            System.out.println("Computing... random #=" + n + " (" + string + ")");
            this.myRuleEvaluationNode.computeValues(n, string);
            this.patternEvaluatedTable = this.myRuleEvaluationNode.getDataResultTable();
            this.hasValidPatternEvaluatedTable = true;
            return this.patternEvaluatedTable;
        }
        return new PatternEvaluatedTable(0);
    }

    public boolean hasValidRule() {
        if (this.myRuleEvaluationNode == null) {
            return false;
        }
        return !this.myRuleEvaluationNode.hasErrors();
    }

    public void addValues() {
    }

    public void addPValues() {
    }

    public void triggerRule(String string, String string2, String string3, String string4, String string5) {
        System.out.println("Triggering " + string + " " + string2 + " " + string3 + "-> Rule: " + string4 + " (" + string5 + " )");
        if (!this.hasValidPatternEvaluatedTable || !this.hasValidPatternMatchedTable) {
            System.out.println("No evaluation done");
            return;
        }
        for (int i = 0; i < this.patternEvaluatedTable.getRowCount(); ++i) {
            Double d = (Double)this.patternEvaluatedTable.getValueAt(i, 1);
            double d2 = d;
            Double d3 = new Double(string3);
            double d4 = d3;
            boolean bl = false;
            if (string.equals("value")) {
                if (string2.equals(">")) {
                    boolean bl2 = bl = d2 > d4;
                }
                if (string2.equals("<")) {
                    bl = d2 < d4;
                }
            }
            System.out.println("Building rule!!");
            if (string5.equalsIgnoreCase("rule")) {
                this.myPatternManager.makeRuleOutOf(string4, this.patternMatchedTable, (String)this.patternEvaluatedTable.getValueAt(i, 0));
            }
            if (!string5.equalsIgnoreCase("pattern")) continue;
            this.myPatternManager.makePatternOutOf(string4, this.patternMatchedTable, (String)this.patternEvaluatedTable.getValueAt(i, 0));
        }
    }

    public TableModel getPatternMatchedTable() {
        return this.patternMatchedTable;
    }

    private void fillPatternMatchedTable() {
        if (!this.hasValidPatternMatchedTable) {
            String string = this.getSelectClause() + this.getWhereClause() + this.getANDClause() + this.getNamespaceClause();
            if (!KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledgeEngine())) {
                return;
            }
            this.patternMatchedTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(this.myPatternManager.makeRDQLQueryFromPattern(this));
            this.hasValidPatternMatchedTable = true;
        }
    }

    public PatternEvaluatedTable getPatternEvaluatedData() {
        if (this.hasValidPatternEvaluatedTable) {
            return this.patternEvaluatedTable;
        }
        return new PatternEvaluatedTable(0);
    }

    public void addTriples(String[][] stringArray) {
        this.myTriplesArray = stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        this.varList = new String[0];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (stringArray[i][j].indexOf("?") != 0) continue;
                hashSet.add(stringArray[i][j]);
            }
        }
        this.varList = hashSet.toArray(this.varList);
        this.fireTableDataChanged();
    }

    public void addFilterConditions(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i][2].equalsIgnoreCase("P")) {
                this.preciseFilterConditions.put(stringArray[i][0], stringArray[i][1]);
            }
            if (!stringArray[i][2].equalsIgnoreCase("F")) continue;
            this.filterConditions.put(stringArray[i][0], stringArray[i][1]);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.myTriplesArray.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Source";
        }
        if (n == 1) {
            return "Property";
        }
        if (n == 2) {
            return "Object";
        }
        return "";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.myTriplesArray[n][n2];
        String string2 = (String)this.filterConditions.get(string);
        String string3 = (String)this.preciseFilterConditions.get(string);
        if (string2 != null) {
            return "~/" + string2 + "/";
        }
        if (string3 != null) {
            return string3;
        }
        if (RDFScape.getCommonMemory().getLabelForURI(string) != null) {
            return RDFScape.getCommonMemory().getLabelForURI(string);
        }
        return string;
    }

    public boolean canAddAndSearchPatterns() {
        return this.myPatternManager.canAddAndSearchPatterns();
    }

    public String[] getVariables() {
        return this.varList;
    }

    public String[][] getTriples() {
        return this.myTriplesArray;
    }

    public Hashtable getFilterConditions() {
        return this.filterConditions;
    }

    public Hashtable getPreciseFilterConditions() {
        return this.preciseFilterConditions;
    }

    public AbstractQueryResultTable searchVariable() {
        return this.myPatternManager.searchVariable(this);
    }

    public AbstractQueryResultTable addVariable() {
        return this.myPatternManager.addVariable(this);
    }

    public AbstractQueryResultTable searchPattern() {
        return this.myPatternManager.searchPattern(this);
    }

    public AbstractQueryResultTable addPattern() {
        return this.myPatternManager.addPattern(this);
    }

    public void remove() {
        this.myPatternManager.remove(this);
    }
}

