/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.utils.ATermUtils;

public class CachedNode {
    public static final Individual TOP_IND = new Individual(ATermUtils.TOP);
    public static final Individual BOTTOM_IND = new Individual(ATermUtils.BOTTOM);
    public static final Individual DUMMY_IND = new Individual(ATermUtils.makeTermAppl("_DUMMY_"));
    Individual node;
    DependencySet depends;

    private CachedNode(Individual node, DependencySet depends) {
        this.node = node;
        this.depends = depends.copy();
    }

    public static CachedNode createTopNode() {
        return new CachedNode(TOP_IND, DependencySet.INDEPENDENT);
    }

    public static CachedNode createBottomNode() {
        return new CachedNode(BOTTOM_IND, DependencySet.INDEPENDENT);
    }

    public static CachedNode createSatisfiableNode() {
        return new CachedNode(DUMMY_IND, DependencySet.INDEPENDENT);
    }

    public static CachedNode createNode(Individual node, DependencySet depends) {
        return new CachedNode(node, depends);
    }

    public boolean isIncomplete() {
        return this.node == DUMMY_IND;
    }

    public boolean isComplete() {
        return this.node != DUMMY_IND;
    }

    public boolean isTop() {
        return this.node == TOP_IND;
    }

    public boolean isBottom() {
        return this.node == BOTTOM_IND;
    }

    public String toString() {
        return this.node + " " + this.depends;
    }
}

