/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OptimizedDoubleBlocking;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RuleBranch;
import org.mindswap.pellet.SROIQStrategy;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Interpreter;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rules.BindingGeneratorStrategy;
import org.mindswap.pellet.rules.BindingGeneratorStrategyImpl;
import org.mindswap.pellet.rules.ContinuousReteTransformer;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.rules.TrivialSatisfactionHelpers;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.Timer;

public class ContinuousRulesStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;
    private ContinuousReteTransformer continuousTransformer;
    private Map<Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding>, Integer> rulesApplied;
    private RulesToReteTranslator ruleTranslator;
    boolean runRules;

    public ContinuousRulesStrategy(ABox abox) {
        super(abox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(abox);
        this.continuousTransformer = new ContinuousReteTransformer(abox);
        this.rulesApplied = new HashMap<Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding>, Integer>();
        this.ruleTranslator = new RulesToReteTranslator(abox);
        this.runRules = true;
        if (!abox.getKB().getExpressivity().hasComplexSubRoles()) {
            this.blocking = new OptimizedDoubleBlocking();
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        if (subj.isRootNominal() && obj.isRootNominal()) {
            this.runRules = true;
        }
        super.addEdge(subj, pred, obj, ds);
    }

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        if (node.isRootNominal()) {
            this.runRules = true;
        }
        super.addType(node, c, ds);
    }

    private void applyFact(Fact fact) {
        if (fact.getElements().size() == 3) {
            DependencySet ds = fact.getDependencySet();
            Constant pred = (Constant)fact.getElements().get(0);
            Individual subj = this.abox.getIndividual(((Constant)fact.getElements().get(1)).getValue());
            if (subj.isMerged()) {
                ds = ds.union(subj.getMergeDependency(true), this.abox.doExplanation());
                subj = subj.getSame();
            }
            ATermAppl objTerm = ((Constant)fact.getElements().get(2)).getValue();
            if (pred.equals(Compiler.TYPE)) {
                ATermAppl type = objTerm;
                this.addType(subj, type, fact.getDependencySet());
            } else {
                Node obj = this.abox.getNode(objTerm);
                if (obj != null && obj.isMerged()) {
                    ds = ds.union(ds, this.abox.doExplanation());
                    obj = obj.getSame();
                }
                if (pred.equals(Compiler.SAME_AS)) {
                    Individual ind2 = (Individual)obj;
                    this.mergeTo(ind2, subj, fact.getDependencySet());
                } else if (pred.equals(Compiler.DIFF_FROM)) {
                    Individual ind2 = (Individual)obj;
                    subj.setDifferent(ind2, fact.getDependencySet());
                } else {
                    Role r = this.abox.getRole(pred.getValue());
                    if (obj == null && r.isDatatypeRole()) {
                        obj = this.abox.addLiteral(objTerm);
                    }
                    this.addEdge(subj, r, obj, fact.getDependencySet());
                }
            }
        }
    }

    public void applyRULERule() {
        Collection<Rule> reteRules = this.ruleTranslator.translateRules(this.abox.getKB().getRules());
        for (org.mindswap.pellet.rules.model.Rule rule : this.abox.getKB().getRules()) {
            Rule transformed = this.continuousTransformer.transformRule(rule);
            reteRules.add(transformed);
        }
        Interpreter interp = new Interpreter(this.abox);
        interp.rete.compile(reteRules);
        Set<Fact> facts = interp.rete.compileFacts(this.abox);
        interp.addFacts(facts, true);
        interp.run();
        HashSet<Fact> rulesToApply = new HashSet<Fact>();
        for (Fact fact : interp.inferredFacts) {
            this.applyFact(fact);
            if (this.abox.isClosed()) {
                return;
            }
            if (fact.getElements().size() <= 3 || !((Constant)fact.getElements().get(0)).equals(ContinuousReteTransformer.VARBINDING)) continue;
            rulesToApply.add(fact);
        }
        int total = 0;
        block2: for (Fact ruleBinding : rulesToApply) {
            Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding> pair = this.continuousTransformer.translateFact(ruleBinding);
            org.mindswap.pellet.rules.model.Rule rule = (org.mindswap.pellet.rules.model.Rule)pair.first;
            VariableBinding initial = (VariableBinding)pair.second;
            for (VariableBinding binding : this.bindingStrategy.createGenerator(rule, initial)) {
                Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding> ruleKey = new Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding>(rule, binding);
                if (this.rulesApplied.containsKey(ruleKey)) continue;
                ++total;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding: " + binding));
                    log.debug((Object)("total:" + total));
                }
                if (this.abox.isClosed()) continue block2;
                int branch = this.createDisjunctionsFromBinding(binding, rule, ruleBinding.getDependencySet());
                if (branch < 0) continue;
                this.rulesApplied.put(ruleKey, branch);
            }
        }
    }

    ABox complete() {
        this.completionTimer.start();
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                Timer t;
                this.completionTimer.check();
                this.abox.changed = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb"));
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    t = this.timers.startTimer("rule-nominal");
                    this.applyNominalRule(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-guess");
                this.applyGuessingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-max");
                this.applyMaxRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    t = this.timers.startTimer("check-dt-count");
                    this.checkDatatypeCount(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                    t = this.timers.startTimer("rule-lit");
                    this.applyLiteralRule();
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-unfold");
                this.applyUnfoldingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-disj");
                this.applyDisjunctionRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-some");
                this.applySomeValuesRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-min");
                this.applyMinRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (this.abox.changed || !this.runRules) continue;
                t = this.timers.startTimer("rule-rule");
                this.runRules = false;
                this.applyRULERule();
                t.stop();
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this.abox.getBranches().get(i);
                    ++unexploredBranch.tryNext;
                    if (unexploredBranch.tryNext < unexploredBranch.tryCount) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.branch + " tryNext = " + unexploredBranch.tryNext + " tryCount = " + unexploredBranch.tryCount);
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.branch);
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }

    private int createDisjunctionsFromBinding(VariableBinding binding, org.mindswap.pellet.rules.model.Rule rule, DependencySet ds) {
        ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> individuals = new ArrayList<ATermAppl>();
        int index = 0;
        DisjunctionVisitor visitor = new DisjunctionVisitor(binding);
        TrivialSatisfactionHelpers atomTester = new TrivialSatisfactionHelpers(this.abox);
        if (rule.getHead().size() == 0) {
            log.warn((Object)("Empty head for rule " + rule));
        }
        for (RuleAtom atom : rule.getHead()) {
            if (atomTester.isAtomTrue(atom, binding)) continue;
            atom.accept(visitor);
            if (visitor.getDisjunct() != null) {
                disjuncts.add(visitor.getDisjunct());
                individuals.add(visitor.getIndividual());
                ++index;
                continue;
            }
            log.warn((Object)("Cannot handle atom " + atom + " in head of rule!"));
            return -1;
        }
        for (RuleAtom atom : rule.getBody()) {
            if (atomTester.isAtomTrue(atom, binding)) continue;
            atom.accept(visitor);
            if (visitor.getDisjunct() == null) continue;
            disjuncts.add(ATermUtils.normalize(ATermUtils.negate(visitor.getDisjunct())));
            individuals.add(visitor.getIndividual());
            ++index;
        }
        ATerm[] disj = new ATermAppl[disjuncts.size()];
        ATermAppl[] inds = new ATermAppl[individuals.size()];
        disj = disjuncts.toArray(disj);
        inds = individuals.toArray(inds);
        ATermAppl disjunction = ATermUtils.makeOr(ATermUtils.makeList(disj));
        if (!this.abox.isClosed()) {
            RuleBranch r = new RuleBranch(this.abox, this, this.abox.getIndividual(inds[0]).getSame(), inds, disjunction, new DependencySet(this.abox.getBranches().size()), (ATermAppl[])disj);
            this.addBranch(r);
            r.tryBranch();
            return r.branch;
        }
        return -1;
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        if (y.isRootNominal() && z.isRootNominal()) {
            this.runRules = true;
        }
        super.mergeTo(y, z, ds);
    }

    public void restore(Branch branch) {
        super.restore(branch);
        int total = 0;
        Iterator<Map.Entry<Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding>, Integer>> ruleAppIter = this.rulesApplied.entrySet().iterator();
        while (ruleAppIter.hasNext()) {
            Map.Entry<Pair<org.mindswap.pellet.rules.model.Rule, VariableBinding>, Integer> ruleBranchEntry = ruleAppIter.next();
            if (ruleBranchEntry.getValue() <= branch.branch) continue;
            ruleAppIter.remove();
            this.runRules = true;
            ++total;
        }
    }

    private class DisjunctionVisitor
    implements RuleAtomVisitor {
        private VariableBinding binding;
        private ATermAppl disjunct;
        private ATermAppl individual;

        public DisjunctionVisitor(VariableBinding binding) {
            this.binding = binding;
        }

        public ATermAppl getDisjunct() {
            return this.disjunct;
        }

        public ATermAppl getIndividual() {
            return this.individual;
        }

        public void visit(BuiltInAtom atom) {
            this.disjunct = null;
            this.individual = null;
        }

        public void visit(ClassAtom atom) {
            this.disjunct = (ATermAppl)atom.getPredicate();
            this.individual = this.binding.get((AtomIObject)atom.getArgument()).getName();
        }

        public void visit(DataRangeAtom atom) {
            this.disjunct = null;
            this.individual = null;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(this.binding.get((AtomDObject)atom.getArgument2()).getName()));
            this.disjunct = ATermUtils.negate(ATermUtils.makeAllValues((ATerm)atom.getPredicate(), notO));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.disjunct = ATermUtils.negate(ATermUtils.makeValue(this.binding.get((AtomIObject)atom.getArgument2()).getName()));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(IndividualPropertyAtom atom) {
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue(this.binding.get((AtomIObject)atom.getArgument2()).getName()));
            this.disjunct = ATermUtils.negate(ATermUtils.makeAllValues((ATerm)atom.getPredicate(), notO));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(SameIndividualAtom atom) {
            this.disjunct = ATermUtils.makeValue(this.binding.get((AtomIObject)atom.getArgument2()).getName());
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }
    }
}

