/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

public class Expressivity {
    KnowledgeBase kb;
    private boolean hasNegation = false;
    private boolean hasInverse = false;
    private boolean hasFunctionality = false;
    private boolean hasCardinality = false;
    private boolean hasCardinalityQ = false;
    private boolean hasFunctionalityD = false;
    private boolean hasCardinalityD = false;
    private boolean hasTransitivity = false;
    private boolean hasRoleHierarchy = false;
    private boolean hasReflexivity = false;
    private boolean hasIrreflexivity = false;
    private boolean hasDisjointRoles = false;
    private boolean hasAntiSymmetry = false;
    private boolean hasComplexSubRoles = false;
    private boolean hasDatatype = false;
    private boolean hasKeys = false;
    private boolean hasDomain;
    private boolean hasRange;
    private Set<ATermAppl> nominals = new HashSet<ATermAppl>();
    private Visitor visitor;

    Expressivity(KnowledgeBase kb) {
        this.kb = kb;
        this.nominals = new HashSet<ATermAppl>();
        this.visitor = new Visitor();
    }

    private Expressivity(Expressivity expr) {
        this.kb = expr.kb;
        this.visitor = new Visitor();
        this.hasNegation = expr.hasNegation;
        this.hasInverse = expr.hasInverse;
        this.hasDatatype = expr.hasDatatype;
        this.hasCardinality = expr.hasCardinality;
        this.hasCardinalityQ = expr.hasCardinalityQ;
        this.hasFunctionality = expr.hasFunctionality;
        this.hasTransitivity = expr.hasTransitivity;
        this.hasRoleHierarchy = expr.hasRoleHierarchy;
        this.hasReflexivity = expr.hasReflexivity;
        this.hasIrreflexivity = expr.hasIrreflexivity;
        this.hasAntiSymmetry = expr.hasAntiSymmetry;
        this.hasDisjointRoles = expr.hasDisjointRoles;
        this.hasComplexSubRoles = expr.hasComplexSubRoles;
        this.hasFunctionalityD = expr.hasFunctionalityD;
        this.hasCardinalityD = expr.hasCardinalityD;
        this.hasDomain = expr.hasDomain;
        this.hasRange = expr.hasRange;
        this.nominals = new HashSet<ATermAppl>(expr.nominals);
    }

    public void compute() {
        this.processIndividuals();
        this.processClasses();
        this.processRoles();
    }

    public Expressivity compute(ATermAppl c) {
        if (c == null) {
            return this;
        }
        Expressivity expressivity = new Expressivity(this);
        expressivity.visitor.visit(c);
        return expressivity;
    }

    public String toString() {
        String dl = "";
        dl = this.hasNegation ? "ALC" : "AL";
        if (this.hasTransitivity) {
            dl = dl + "R+";
        }
        if (dl.equals("ALCR+")) {
            dl = "S";
        }
        if (this.hasComplexSubRoles) {
            dl = "SR";
        } else if (this.hasRoleHierarchy) {
            dl = dl + "H";
        }
        if (this.hasNominal()) {
            dl = dl + "O";
        }
        if (this.hasInverse) {
            dl = dl + "I";
        }
        if (this.hasCardinalityQ) {
            dl = dl + "Q";
        } else if (this.hasCardinality) {
            dl = dl + "N";
        } else if (this.hasFunctionality) {
            dl = dl + "F";
        }
        if (this.hasDatatype) {
            dl = this.hasKeys ? dl + "(Dk)" : dl + "(D)";
        }
        return dl;
    }

    protected void processClasses() {
        TBox tbox = this.kb.getTBox();
        List<Pair<ATermAppl, Set<ATermAppl>>> UC = tbox.getUC();
        if (UC != null) {
            this.hasNegation = true;
            for (Pair pair : UC) {
                this.visitor.visit((ATermAppl)pair.first);
            }
        }
        for (ATermAppl aTermAppl : this.kb.getAllClasses()) {
            List<Pair<ATermAppl, Set<ATermAppl>>> unfoldC = tbox.unfold(aTermAppl);
            if (unfoldC == null) continue;
            for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldC) {
                this.visitor.visit((ATermAppl)pair.first);
            }
        }
    }

    protected void processIndividuals() {
        IndividualIterator i = this.kb.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            ATermAppl nominal = ATermUtils.makeValue(ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal)) continue;
                this.visitor.visit(term);
            }
        }
    }

    protected void processIndividual(ATermAppl i, ATermAppl concept) {
        ATermAppl nominal = ATermUtils.makeValue(i);
        if (concept.equals(nominal)) {
            return;
        }
        this.visitor.visit(concept);
    }

    protected void processRoles() {
        for (Role r : this.kb.getRBox().getRoles()) {
            ATermAppl range;
            ATermAppl domain;
            if (r.isDatatypeRole()) {
                this.hasDatatype = true;
                if (r.isInverseFunctional()) {
                    this.hasKeys = true;
                }
            }
            if (r.isAnon()) {
                for (Role subRole : r.getSubRoles()) {
                    if (subRole.isAnon()) continue;
                    this.hasInverse = true;
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                this.hasInverse = true;
            }
            if (r.isFunctional()) {
                this.hasFunctionality = true;
            }
            if (r.isTransitive()) {
                this.hasTransitivity = true;
            }
            if (r.isReflexive()) {
                this.hasReflexivity = true;
            }
            if (r.isIrreflexive()) {
                this.hasIrreflexivity = true;
            }
            if (r.isAntisymmetric()) {
                this.hasAntiSymmetry = true;
            }
            if (!r.getDisjointRoles().isEmpty()) {
                this.hasDisjointRoles = true;
            }
            if (r.hasComplexSubRole()) {
                this.hasComplexSubRoles = true;
            }
            if (r.getSubRoles().size() > 1) {
                this.hasRoleHierarchy = true;
            }
            if ((domain = r.getDomain()) != null) {
                this.hasDomain |= !domain.equals(ATermUtils.TOP);
                this.visitor.visit(domain);
            }
            if ((range = r.getRange()) == null) continue;
            this.hasRange |= !range.equals(ATermUtils.TOP);
            this.visitor.visit(range);
        }
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public boolean hasCardinalityQ() {
        return this.hasCardinalityQ;
    }

    public boolean hasFunctionality() {
        return this.hasFunctionality;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public boolean hasCardinalityD() {
        return this.hasCardinalityD;
    }

    public boolean hasFunctionalityD() {
        return this.hasFunctionalityD;
    }

    public boolean hasInverse() {
        return this.hasInverse;
    }

    public boolean hasNegation() {
        return this.hasNegation;
    }

    public boolean hasNominal() {
        return !this.nominals.isEmpty();
    }

    public boolean hasRoleHierarchy() {
        return this.hasRoleHierarchy;
    }

    public boolean hasReflexivity() {
        return this.hasReflexivity;
    }

    public boolean hasIrreflexivity() {
        return this.hasIrreflexivity;
    }

    public boolean hasAntiSymmmetry() {
        return this.hasAntiSymmetry;
    }

    public boolean hasDisjointRoles() {
        return this.hasDisjointRoles;
    }

    public boolean hasComplexSubRoles() {
        return this.hasComplexSubRoles;
    }

    public boolean hasTransitivity() {
        return this.hasTransitivity;
    }

    public boolean hasDomain() {
        return this.hasDomain;
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public Set getNominals() {
        return this.nominals;
    }

    public boolean hasKeys() {
        return this.hasKeys;
    }

    class Visitor
    extends ATermBaseVisitor
    implements ATermVisitor {
        Visitor() {
        }

        public void visitTerm(ATermAppl term) {
        }

        void visitRole(ATermAppl p) {
            if (!ATermUtils.isPrimitive(p)) {
                Expressivity.this.hasInverse = true;
            }
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitOr(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitNot(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitSome(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitAll(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitCard(ATermAppl term) {
            this.visitMin(term);
            this.visitMax(term);
        }

        public void visitMin(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                Expressivity.this.hasCardinalityQ = true;
            } else if (cardinality > 2) {
                Expressivity.this.hasCardinality = true;
                if (Expressivity.this.kb.getRole(term.getArgument(0)).isDatatypeRole()) {
                    Expressivity.this.hasCardinalityD = true;
                }
            } else if (cardinality > 0) {
                Expressivity.this.hasFunctionality = true;
                if (Expressivity.this.kb.getRole(term.getArgument(0)).isDatatypeRole()) {
                    Expressivity.this.hasFunctionalityD = true;
                }
            }
        }

        public void visitMax(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                Expressivity.this.hasCardinalityQ = true;
            } else if (cardinality > 1) {
                Expressivity.this.hasCardinality = true;
            } else if (cardinality > 0) {
                Expressivity.this.hasFunctionality = true;
            }
        }

        public void visitHasValue(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visitValue((ATermAppl)term.getArgument(1));
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nom = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nom)) {
                Expressivity.this.nominals.add(nom);
            }
        }

        public void visitOneOf(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitSelf(ATermAppl term) {
            Expressivity.this.hasReflexivity = true;
            Expressivity.this.hasIrreflexivity = true;
        }

        public void visitSubClass(ATermAppl term) {
            throw new InternalReasonerException("This function should never be called!");
        }
    }
}

