/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndividualIterator
implements Iterator<Individual> {
    protected Map nodes;
    protected List nodeList;
    protected int index;
    protected int start;
    protected int stop;

    public IndividualIterator(ABox abox) {
        this(abox, true);
    }

    protected IndividualIterator(ABox abox, boolean findNext) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = 0;
        this.stop = this.nodeList.size();
        this.index = this.start;
        if (findNext) {
            this.findNext();
        }
    }

    public IndividualIterator(ABox abox, int start, int stop) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = start;
        this.stop = Math.max(stop, this.nodeList.size());
        this.index = start;
        this.findNext();
    }

    public int getIndex() {
        return this.index;
    }

    protected void findNext() {
        Node node;
        while (this.index < this.stop && ((node = (Node)this.nodes.get(this.nodeList.get(this.index))).isPruned() || !(node instanceof Individual))) {
            ++this.index;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset() {
        this.index = this.start;
        this.findNext();
    }

    public void jump(int i) {
        this.index = i;
    }

    @Override
    public Individual next() {
        this.findNext();
        Individual ind = (Individual)this.nodes.get(this.nodeList.get(this.index++));
        return ind;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

