/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class KRSSLoader {
    public static final Log log = LogFactory.getLog(KRSSLoader.class);
    public static boolean DEBUG = false;
    private StreamTokenizer in;
    private KnowledgeBase kb;
    private XSDAtomicType xsdInt;
    private ArrayList terms;
    private Map disjoints;
    private boolean forceUppercase = false;
    private static final int QUOTE = 124;

    public boolean isForceUppercase() {
        return this.forceUppercase;
    }

    public void setForceUppercase(boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    private void initTokenizer(Reader reader) {
        this.in = new StreamTokenizer(reader);
        this.in.lowerCaseMode(false);
        this.in.commentChar(59);
        this.in.wordChars(47, 47);
        this.in.wordChars(95, 95);
        this.in.wordChars(42, 42);
        this.in.wordChars(63, 63);
        this.in.wordChars(37, 37);
        this.in.wordChars(62, 62);
        this.in.wordChars(60, 60);
        this.in.wordChars(61, 61);
        this.in.quoteChar(124);
    }

    private void skipNext() throws IOException {
        this.in.nextToken();
    }

    private void skipNext(int token) throws IOException {
        ATermUtils.assertTrue(token == this.in.nextToken());
    }

    private void skipNext(String token) throws IOException {
        this.in.nextToken();
        ATermUtils.assertTrue(token.equals(this.in.sval));
    }

    private boolean peekNext(int token) throws IOException {
        int next = this.in.nextToken();
        this.in.pushBack();
        return token == next;
    }

    private String nextString() throws IOException {
        this.in.nextToken();
        switch (this.in.ttype) {
            case -3: 
            case 124: {
                return this.in.sval;
            }
            case -2: {
                return String.valueOf(this.in.nval);
            }
        }
        throw new RuntimeException("Expecting string found " + (char)this.in.ttype);
    }

    private int nextInt() throws IOException {
        this.in.nextToken();
        return (int)this.in.nval;
    }

    private Object nextNumber() throws IOException {
        this.in.nextToken();
        String strVal = String.valueOf((long)this.in.nval);
        return this.xsdInt.getValue(strVal, null);
    }

    private ATermAppl nextTerm() throws IOException {
        String token = this.nextString();
        if (this.forceUppercase) {
            token = token.toUpperCase();
        }
        return ATermUtils.makeTermAppl(token);
    }

    private ATermAppl[] parseExprList() throws IOException {
        int count = 0;
        while (this.peekNext(40)) {
            this.skipNext();
            ++count;
        }
        ArrayList<ATermAppl> terms = new ArrayList<ATermAppl>();
        while (true) {
            if (this.peekNext(41)) {
                if (count == 0) break;
                this.skipNext();
                if (--count != 0) continue;
                break;
            }
            if (this.peekNext(40)) {
                this.skipNext();
                ++count;
                continue;
            }
            terms.add(this.parseExpr());
        }
        return terms.toArray(new ATermAppl[terms.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ATermAppl parseExpr() throws IOException {
        int n;
        ATermAppl a = null;
        int token = this.in.nextToken();
        String s = this.in.sval;
        if (token == -3 || token == 124) {
            if (s.equalsIgnoreCase("TOP")) return ATermUtils.TOP;
            if (s.equalsIgnoreCase("*TOP*")) return ATermUtils.TOP;
            if (s.equalsIgnoreCase(":TOP")) {
                return ATermUtils.TOP;
            }
            if (s.equalsIgnoreCase("BOTTOM")) return ATermUtils.BOTTOM;
            if (s.equalsIgnoreCase("*BOTTOM*")) {
                return ATermUtils.BOTTOM;
            }
            if (!this.forceUppercase) return ATermUtils.makeTermAppl(s);
            s = s.toUpperCase();
            return ATermUtils.makeTermAppl(s);
        }
        if (token == -2) {
            return ATermUtils.makeTermAppl(String.valueOf(this.in.nval));
        }
        if (token == 58) {
            s = this.nextString();
            if (s.equalsIgnoreCase("TOP")) {
                return ATermUtils.TOP;
            }
            if (!s.equalsIgnoreCase("BOTTOM")) throw new RuntimeException("Parse exception after ':' " + s);
            return ATermUtils.BOTTOM;
        }
        if (token == 40) {
            token = this.in.nextToken();
            ATermUtils.assertTrue(token == -3);
            s = this.in.sval;
            if (s.equalsIgnoreCase("NOT")) {
                ATermAppl c = this.parseExpr();
                a = ATermUtils.makeNot(c);
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
            } else if (s.equalsIgnoreCase("AND")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeAnd(list);
            } else if (s.equalsIgnoreCase("OR")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeOr(list);
            } else if (s.equalsIgnoreCase("ONE-OF")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    this.kb.addIndividual(c);
                    list = list.insert(ATermUtils.makeValue(c));
                }
                a = ATermUtils.makeOr(list);
            } else if (s.equalsIgnoreCase("ALL")) {
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeAllValues(r, c);
            } else if (s.equalsIgnoreCase("SOME")) {
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeSomeValues(r, c);
            } else if (s.equalsIgnoreCase("AT-LEAST") || s.equalsIgnoreCase("ATLEAST")) {
                int n2 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMin((ATerm)r, n2, (ATerm)c);
            } else if (s.equalsIgnoreCase("AT-MOST") || s.equalsIgnoreCase("ATMOST")) {
                int n3 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMax((ATerm)r, n3, (ATerm)c);
            } else if (s.equalsIgnoreCase("EXACTLY")) {
                int n4 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeCard(r, n4, c);
            } else if (s.equalsIgnoreCase("A")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty(r);
                this.kb.addFunctionalProperty(r);
                a = ATermUtils.makeMin((ATerm)r, 1, (ATerm)ATermUtils.TOP_LIT);
            } else if (s.equalsIgnoreCase("MIN") || s.equals(">=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty(r);
                Object val = this.nextNumber();
                XSDAtomicType dt = this.xsdInt.restrictMinInclusive(val);
                String dtName = this.kb.addDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else if (s.equalsIgnoreCase("MAX") || s.equals("<=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty(r);
                Object val = this.nextNumber();
                XSDAtomicType dt = this.xsdInt.restrictMaxInclusive(val);
                String dtName = this.kb.addDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else if (s.equals("=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty(r);
                Object val = this.nextNumber();
                Datatype dt = this.xsdInt.singleton(val);
                String dtName = this.kb.addDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else {
                if (!s.equalsIgnoreCase("INV")) throw new RuntimeException("Unknown expression " + s);
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty(r);
                a = this.kb.getProperty(r).getInverse().getName();
            }
            if (this.in.nextToken() == 41) return a;
            throw new RuntimeException("Parse exception at term " + s);
        }
        if (token == 35) {
            n = this.nextInt();
            if (this.peekNext(35)) {
                this.skipNext();
                a = (ATermAppl)this.terms.get(n);
                if (a != null) return a;
                throw new RuntimeException("Parse exception: #" + n + "# is not defined");
            }
            this.skipNext("=");
            a = this.parseExpr();
            while (this.terms.size() <= n) {
                this.terms.add(null);
            }
        } else {
            if (token != -1) throw new RuntimeException("Invalid token");
            return null;
        }
        this.terms.set(n, a);
        return a;
    }

    public void load(Reader reader, KnowledgeBase kb) throws IOException {
        this.kb = kb;
        this.xsdInt = (XSDAtomicType)kb.getDatatypeReasoner().getDatatype("http://www.w3.org/2001/XMLSchema#int");
        this.initTokenizer(reader);
        this.terms = new ArrayList();
        this.disjoints = new HashMap();
        int token = this.in.nextToken();
        while (token != -1) {
            ATermAppl x;
            ATermAppl p;
            ATermAppl p1;
            ATermAppl c;
            if (token == 35) {
                this.in.ordinaryChar(124);
                token = this.in.nextToken();
                while (token != 35) {
                    token = this.in.nextToken();
                }
                this.in.quoteChar(124);
                token = this.in.nextToken();
                if (token == -1) break;
            }
            if (token != 40) {
                throw new RuntimeException("Expecting '(' but found " + this.in);
            }
            String str = this.nextString();
            if (str.equalsIgnoreCase("DEFINE-ROLE") || str.equalsIgnoreCase("DEFINE-PRIMITIVE-ROLE") || str.equalsIgnoreCase("DEFPRIMROLE") || str.equalsIgnoreCase("DEFINE-ATTRIBUTE") || str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE") || str.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY")) {
                boolean primDef;
                ATermAppl r = this.nextTerm();
                boolean dataProp = str.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY");
                boolean functional = str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE");
                boolean bl = primDef = str.indexOf("PRIm") != -1;
                if (dataProp) {
                    kb.addDatatypeProperty(r);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("DEFINE-DATATYPE-ROLE " + r));
                    }
                } else {
                    kb.addObjectProperty(r);
                    if (functional) {
                        kb.addFunctionalProperty(r);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("DEFINE-PRIMITIVE-ATTRIBUTE " + r));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("DEFINE-PRIMITIVE-ROLE " + r));
                    }
                }
                while (!this.peekNext(41)) {
                    String cmd;
                    if (this.peekNext(58)) {
                        this.skipNext(58);
                        cmd = this.nextString();
                        if (cmd.equalsIgnoreCase("parents")) {
                            ATermAppl s;
                            boolean paren = this.peekNext(40);
                            if (paren) {
                                this.skipNext(40);
                                while (!this.peekNext(41)) {
                                    s = this.nextTerm();
                                    if (s.getName().equals("NIL")) continue;
                                    kb.addObjectProperty(s);
                                    kb.addSubProperty(r, s);
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("PARENT-ROLE " + r + " " + s));
                                }
                                this.skipNext(41);
                                continue;
                            }
                            s = this.nextTerm();
                            if (s.toString().equalsIgnoreCase("NIL")) continue;
                            kb.addObjectProperty(s);
                            kb.addSubProperty(r, s);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("PARENT-ROLE " + r + " " + s));
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("feature")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            kb.addFunctionalProperty(r);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("FUNCTIONAL-ROLE " + r));
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("transitive")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            kb.addTransitiveProperty(r);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("TRANSITIVE-ROLE " + r));
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("range")) {
                            ATermAppl range = this.parseExpr();
                            kb.addClass(range);
                            kb.addRange(r, range);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("RANGE " + r + " " + range));
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("domain")) {
                            ATermAppl domain = this.parseExpr();
                            kb.addClass(domain);
                            kb.addDomain(r, domain);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("DOMAIN " + r + " " + domain));
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("inverse")) {
                            ATermAppl inv = this.nextTerm();
                            kb.addInverseProperty(r, inv);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("INVERSE " + r + " " + inv));
                            continue;
                        }
                        throw new RuntimeException("Invalid role spec " + cmd);
                    }
                    if (this.peekNext(40)) {
                        this.skipNext(40);
                        cmd = this.nextString();
                        if (cmd.equalsIgnoreCase("domain-range")) {
                            ATermAppl domain = this.nextTerm();
                            ATermAppl range = this.nextTerm();
                            kb.addDomain(r, domain);
                            kb.addRange(r, range);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("DOMAIN-RANGE " + r + " " + domain + " " + range));
                            }
                        } else {
                            throw new RuntimeException("Invalid role spec");
                        }
                        this.skipNext(41);
                        continue;
                    }
                    ATermAppl s = this.parseExpr();
                    if (dataProp) {
                        kb.addDatatypeProperty(s);
                    } else {
                        kb.addObjectProperty(r);
                    }
                    if (primDef) {
                        kb.addSubProperty(r, s);
                    } else {
                        kb.addEquivalentProperty(r, s);
                    }
                    log.debug((Object)("PARENT-ROLE " + r + " " + s));
                }
            } else if (str.equalsIgnoreCase("DEFINE-PRIMITIVE-CONCEPT") || str.equalsIgnoreCase("DEFPRIMCONCEPT")) {
                c = this.nextTerm();
                kb.addClass(c);
                ATermAppl expr = null;
                if (!this.peekNext(41) && !(expr = this.parseExpr()).getName().equals("NIL")) {
                    kb.addClass(expr);
                    kb.addSubClass(c, expr);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DEFINE-PRIMITIVE-CONCEPT " + c + " " + (expr == null ? "" : expr.toString())));
                }
            } else if (str.equalsIgnoreCase("DEFINE-DISJOINT-PRIMITIVE-CONCEPT")) {
                c = this.nextTerm();
                kb.addClass(c);
                this.skipNext(40);
                while (!this.peekNext(41)) {
                    ATermAppl expr = this.parseExpr();
                    ArrayList<ATermAppl> prevDefinitions = (ArrayList<ATermAppl>)this.disjoints.get(expr);
                    if (prevDefinitions == null) {
                        prevDefinitions = new ArrayList<ATermAppl>();
                    }
                    for (ATermAppl d : prevDefinitions) {
                        kb.addDisjointClass(c, d);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("DEFINE-PRIMITIVE-DISJOINT " + c + " " + d));
                    }
                    prevDefinitions.add(c);
                }
                this.skipNext(41);
                ATermAppl expr = this.parseExpr();
                kb.addSubClass(c, expr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DEFINE-PRIMITIVE-CONCEPT " + c + " " + expr));
                }
            } else if (str.equalsIgnoreCase("DEFINE-CONCEPT") || str.equalsIgnoreCase("DEFCONCEPT") || str.equalsIgnoreCase("EQUAL_C")) {
                c = this.nextTerm();
                kb.addClass(c);
                ATermAppl expr = this.parseExpr();
                kb.addEquivalentClass(c, expr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DEFINE-CONCEPT " + c + " " + expr));
                }
            } else if (str.equalsIgnoreCase("IMPLIES") || str.equalsIgnoreCase("IMPLIES_C")) {
                ATermAppl c1 = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                kb.addClass(c1);
                kb.addClass(c2);
                kb.addSubClass(c1, c2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IMPLIES " + c1 + " " + c2));
                }
            } else if (str.equalsIgnoreCase("IMPLIES_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                kb.addProperty(p1);
                kb.addProperty(p2);
                kb.addSubProperty(p1, p2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IMPLIES_R " + p1 + " " + p2));
                }
            } else if (str.equalsIgnoreCase("EQUAL_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                kb.addObjectProperty(p1);
                kb.addObjectProperty(p2);
                kb.addEquivalentProperty(p1, p2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EQUAL_R " + p1 + " " + p2));
                }
            } else if (str.equalsIgnoreCase("DOMAIN")) {
                p = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                kb.addProperty(p);
                kb.addClass(c2);
                kb.addDomain(p, c2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DOMAIN " + p + " " + c2));
                }
            } else if (str.equalsIgnoreCase("RANGE")) {
                p = this.parseExpr();
                ATermAppl c3 = this.parseExpr();
                kb.addProperty(p);
                kb.addClass(c3);
                kb.addRange(p, c3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RANGE " + p + " " + c3));
                }
            } else if (str.equalsIgnoreCase("FUNCTIONAL")) {
                p = this.parseExpr();
                kb.addProperty(p);
                kb.addFunctionalProperty(p);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FUNCTIONAL " + p));
                }
            } else if (str.equalsIgnoreCase("TRANSITIVE")) {
                p = this.parseExpr();
                kb.addObjectProperty(p);
                kb.addTransitiveProperty(p);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TRANSITIVE " + p));
                }
            } else if (str.equalsIgnoreCase("DISJOINT")) {
                ATermAppl[] list = this.parseExprList();
                for (int i = 0; i < list.length - 1; ++i) {
                    ATermAppl c1 = list[i];
                    for (int j = i + 1; j < list.length; ++j) {
                        ATermAppl c2 = list[j];
                        kb.addClass(c2);
                        kb.addDisjointClass(c1, c2);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("DISJOINT " + c1 + " " + c2));
                    }
                }
            } else if (str.equalsIgnoreCase("DEFINDIVIDUAL")) {
                x = this.nextTerm();
                kb.addIndividual(x);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DEFINDIVIDUAL " + x));
                }
            } else if (str.equalsIgnoreCase("INSTANCE")) {
                x = this.nextTerm();
                ATermAppl c4 = this.parseExpr();
                kb.addIndividual(x);
                kb.addType(x, c4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("INSTANCE " + x + " " + c4));
                }
            } else if (str.equalsIgnoreCase("RELATED")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                ATermAppl r = this.nextTerm();
                kb.addIndividual(x);
                kb.addIndividual(y);
                kb.addPropertyValue(r, x, y);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RELATED " + x + " - " + r + " -> " + y));
                }
            } else if (str.equalsIgnoreCase("DIFFERENT")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                kb.addIndividual(x);
                kb.addIndividual(y);
                kb.addDifferent(x, y);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DIFFERENT " + x + " " + y));
                }
            } else if (str.equalsIgnoreCase("DATATYPE-ROLE-FILLER")) {
                x = this.nextTerm();
                ATermAppl y = ATermUtils.makePlainLiteral(this.nextString());
                ATermAppl r = this.nextTerm();
                kb.addIndividual(x);
                kb.addIndividual(y);
                kb.addPropertyValue(r, x, y);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DATATYPE-ROLE-FILLER " + x + " - " + r + " -> " + y));
                }
            } else {
                throw new RuntimeException("Unknown command " + str);
            }
            this.skipNext(41);
            token = this.in.nextToken();
        }
    }

    public void load(InputStream stream, KnowledgeBase kb) throws IOException {
        this.load(new InputStreamReader(stream), kb);
    }

    public void load(String file, KnowledgeBase kb) throws IOException {
        this.load(new FileReader(file), kb);
    }

    public void verifyTBox(String file, KnowledgeBase kb) throws Exception {
        this.initTokenizer(new FileReader(file));
        boolean failed = false;
        int verifiedCount = 0;
        int token = this.in.nextToken();
        while (token != 41 && token != -1) {
            ATermAppl t;
            ATermUtils.assertTrue(token == 40);
            ++verifiedCount;
            ATermAppl c = null;
            if (this.peekNext(40)) {
                ATermAppl[] list = this.parseExprList();
                c = list[0];
                Set<ATermAppl> eqs = kb.getEquivalentClasses(c);
                for (int i = 1; i < list.length; ++i) {
                    ATermAppl t2 = list[i];
                    if (eqs.contains(t2)) continue;
                    log.error((Object)(t2 + " is not equivalent to " + c));
                    failed = true;
                }
            } else {
                c = this.parseExpr();
            }
            Set<ATermAppl> supers = SetUtils.union(kb.getSuperClasses(c, true));
            Set<ATermAppl> subs = SetUtils.union(kb.getSubClasses(c, true));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Verify (" + verifiedCount + ") " + c + " " + supers + " " + subs));
            }
            if (this.peekNext(40)) {
                ATermAppl[] terms = this.parseExprList();
                for (int i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (supers.contains(t)) continue;
                    log.error((Object)(t + " is not a superclass of " + c + " "));
                    failed = true;
                }
            } else {
                this.skipNext();
            }
            if (this.peekNext(40)) {
                ATermAppl[] terms = this.parseExprList();
                for (int i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (subs.contains(t)) continue;
                    HashSet<ATermAppl> temp = new HashSet<ATermAppl>(subs);
                    Set<ATermAppl> sames = kb.getEquivalentClasses(t);
                    temp.retainAll(sames);
                    if (temp.size() != 0) continue;
                    log.error((Object)(t + " is not a subclass of " + c));
                    failed = true;
                }
            }
            this.skipNext();
            token = this.in.nextToken();
        }
        ATermUtils.assertTrue(this.in.nextToken() == -1);
        if (failed) {
            throw new RuntimeException("Classification results are not correct!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyABox(String file, KnowledgeBase kb) throws Exception {
        boolean longFormat;
        this.initTokenizer(new FileReader(file));
        boolean bl = longFormat = !this.peekNext(40);
        while (!this.peekNext(-1)) {
            boolean isType;
            if (longFormat) {
                this.skipNext("Command");
                this.skipNext(61);
            }
            this.skipNext(40);
            this.skipNext("INDIVIDUAL-INSTANCE?");
            ATermAppl ind = this.nextTerm();
            ATermAppl c = this.parseExpr();
            if (log.isDebugEnabled()) {
                log.debug((Object)("INDIVIDUAL-INSTANCE? " + ind + " " + c));
            }
            this.skipNext(41);
            if (longFormat) {
                this.skipNext(45);
                this.skipNext(62);
                String result = this.nextString();
                if (result.equalsIgnoreCase("T")) {
                    isType = true;
                } else {
                    if (!result.equalsIgnoreCase("NIL")) throw new RuntimeException("Unknown result " + result);
                    isType = false;
                }
            } else {
                isType = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(" -> " + isType));
            }
            if (kb.isType(ind, c) == isType) continue;
            throw new RuntimeException("Individual " + ind + " is " + (isType ? "not" : "") + " an instance of " + c);
        }
    }
}

