/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    public static final Log log = LogFactory.getLog(Node.class);
    public static final boolean DEBUG = false;
    public static final int BLOCKABLE = Integer.MAX_VALUE;
    public static final int NOMINAL = 0;
    public static final int CHANGED = 127;
    public static final int UNCHANGED = 0;
    public static final int ATOM = 0;
    public static final int OR = 1;
    public static final int SOME = 2;
    public static final int ALL = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int NOM = 6;
    public static final int TYPES = 7;
    private int status;
    protected ABox abox;
    protected ATermAppl name;
    protected Map<ATermAppl, DependencySet> depends;
    protected int depth = 1;
    private boolean isRoot;
    private boolean isConceptRoot;
    protected Node mergedTo = this;
    protected EdgeList inEdges;
    protected DependencySet mergeDepends = null;
    protected DependencySet pruned = null;
    protected Set<Node> merged;
    protected Map<Node, DependencySet> differents;
    int branch;

    protected Node(ATermAppl name, ABox abox) {
        this.name = name;
        this.abox = abox;
        this.isRoot = !ATermUtils.isAnon(name);
        this.isConceptRoot = false;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.differents = new HashMap<Node, DependencySet>();
        this.depends = new HashMap<ATermAppl, DependencySet>();
        this.inEdges = new EdgeList();
        this.branch = 0;
        this.status = 127;
    }

    protected Node(Node node, ABox abox) {
        this.name = node.getName();
        this.abox = abox;
        this.isRoot = node.isRoot;
        this.isConceptRoot = node.isConceptRoot;
        this.mergeDepends = node.mergeDepends;
        this.mergedTo = node.mergedTo;
        this.merged = node.merged;
        this.pruned = node.pruned;
        this.differents = node.differents;
        this.depends = new HashMap<ATermAppl, DependencySet>(node.depends);
        if (abox == null) {
            this.mergedTo = null;
            this.inEdges = new EdgeList(node.inEdges.size());
            for (int i = 0; i < node.inEdges.size(); ++i) {
                Edge edge = node.inEdges.edgeAt(i);
                Node to = this;
                Individual from = new Individual(edge.getFrom().getName());
                Edge newEdge = new Edge(edge.getRole(), from, to, edge.getDepends());
                this.inEdges.addEdge(newEdge);
            }
        } else {
            this.inEdges = node.inEdges;
        }
        this.branch = node.branch;
        this.status = 127;
    }

    protected void updateNodeReferences() {
        this.mergedTo = this.abox.getNode(this.mergedTo.getName());
        HashMap<Node, DependencySet> diffs = new HashMap<Node, DependencySet>(this.differents.size());
        for (Map.Entry<Node, DependencySet> entry : this.differents.entrySet()) {
            Node node = entry.getKey();
            diffs.put(this.abox.getNode(node.getName()), entry.getValue());
        }
        this.differents = diffs;
        if (this.merged != null) {
            HashSet<Node> sames = new HashSet<Node>(this.merged.size());
            for (Node node : this.merged) {
                sames.add(this.abox.getNode(node.getName()));
            }
            this.merged = sames;
        }
        EdgeList oldEdges = this.inEdges;
        this.inEdges = new EdgeList(oldEdges.size());
        for (int i = 0; i < oldEdges.size(); ++i) {
            Edge edge = oldEdges.edgeAt(i);
            Individual from = this.abox.getIndividual(edge.getFrom().getName());
            Edge newEdge = new Edge(edge.getRole(), from, this, edge.getDepends());
            this.inEdges.addEdge(newEdge);
            if (this.isPruned()) continue;
            from.getOutEdges().addEdge(newEdge);
        }
    }

    public Node copy() {
        return this.copyTo(null);
    }

    public boolean isChanged() {
        return this.status != 0;
    }

    public boolean isChanged(int type) {
        return (this.status & 1 << type) != 0;
    }

    public void setChanged(boolean changed) {
        this.status = changed ? 127 : 0;
    }

    public void setChanged(int type, boolean changed) {
        if (changed) {
            this.status |= 1 << type;
            QueueElement newElement = new QueueElement(this.getName(), null);
            if ((type == 3 || type == 4) && PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.completionQueue.add(newElement, CompletionQueue.DATATYPELIST);
            }
            if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.completionQueue.addEffected(this.abox.getBranch(), this.getName());
            }
        } else {
            this.status &= ~(1 << type);
            if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.completionQueue.addEffected(this.abox.getBranch(), this.getName());
            }
        }
    }

    public boolean isConceptRoot() {
        return this.isConceptRoot;
    }

    public void setConceptRoot(boolean isConceptRoot) {
        this.isConceptRoot = isConceptRoot;
    }

    public boolean isBnode() {
        return this.name.getName().startsWith("bNode");
    }

    public boolean isNamedIndividual() {
        return this.isRoot && !this.isConceptRoot && !this.isBnode();
    }

    public boolean isRoot() {
        return this.isRoot || this.isNominal();
    }

    public abstract boolean isLeaf();

    public boolean isRootNominal() {
        return this.isRoot && this.isNominal();
    }

    public abstract Node copyTo(ABox var1);

    protected void addInEdge(Edge edge) {
        this.inEdges.addEdge(edge);
    }

    public EdgeList getInEdges() {
        return this.inEdges;
    }

    public boolean removeInEdge(Edge edge) {
        boolean removed = this.inEdges.removeEdge(edge);
        if (!removed) {
            if (this.abox.isClosed()) {
                System.out.println(" Removing in edge and abox is closed");
            }
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public void removeInEdges() {
        this.inEdges = new EdgeList();
    }

    public boolean restore(int branch) {
        DependencySet d;
        ATermAppl c2;
        if (this.pruned != null) {
            if (this.pruned.branch > branch) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RESTORE: " + this + " merged node " + this.mergedTo + " " + this.mergeDepends));
                }
                if (this.mergeDepends.branch > branch) {
                    this.undoSetSame();
                }
                this.unprune(branch);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DO NOT RESTORE: pruned node " + this + " = " + this.mergedTo + " " + this.mergeDepends));
                }
                return false;
            }
        }
        ArrayList<ATermAppl> conjunctions = new ArrayList<ATermAppl>();
        this.status = 127;
        Iterator<Object> i = this.getTypes().iterator();
        while (i.hasNext()) {
            boolean removeType;
            c2 = i.next();
            d = this.getDepends(c2);
            boolean bl = PelletOptions.USE_SMART_RESTORE ? d.max() >= branch : (removeType = d.branch > branch);
            if (removeType) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RESTORE: " + this + " remove type " + c2 + " " + d + " " + branch));
                }
                i.remove();
                this.removeType(c2);
                continue;
            }
            if (!PelletOptions.USE_SMART_RESTORE || !ATermUtils.isAnd(c2)) continue;
            conjunctions.add(c2);
        }
        if (PelletOptions.USE_SMART_RESTORE) {
            for (ATermAppl c2 : conjunctions) {
                d = this.getDepends(c2);
                ATermList cs = (ATermList)c2.getArgument(0);
                while (!cs.isEmpty()) {
                    ATermAppl conj = (ATermAppl)cs.getFirst();
                    this.addType(conj, d);
                    cs = cs.getNext();
                }
            }
        }
        if ((c2 = this.abox.typeAssertions.get(this.name)) != null) {
            this.addType(c2, DependencySet.INDEPENDENT);
        }
        i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Node node = (Node)entry.getKey();
            DependencySet d2 = (DependencySet)entry.getValue();
            if (d2.branch <= branch) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RESTORE: " + this.name + " delete difference " + node));
            }
            i.remove();
        }
        i = this.inEdges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            DependencySet d3 = e.getDepends();
            if (d3.branch <= branch) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RESTORE: " + this.name + " delete reverse edge " + e));
            }
            i.remove();
        }
        return true;
    }

    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
        }
        if (this.isMerged()) {
            return;
        }
        if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.completionQueue.addEffected(this.abox.getBranch(), this.getName());
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
    }

    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.status = 127;
    }

    public boolean hasType(ATerm c) {
        return this.depends.containsKey(c);
    }

    public boolean hasObviousType(ATermAppl c) {
        DependencySet ds = this.getDepends(c);
        if (ds != null && ds.isIndependent()) {
            return true;
        }
        if (this.isIndividual() && ATermUtils.isSomeValues(c)) {
            Individual ind = (Individual)this;
            ATermAppl r = (ATermAppl)c.getArgument(0);
            ATermAppl d = (ATermAppl)c.getArgument(1);
            Role role = this.abox.getRole(r);
            EdgeList edges = ind.getRNeighborEdges(role);
            for (int e = 0; e < edges.size(); ++e) {
                Node y;
                Edge edge = edges.edgeAt(e);
                if (!edge.getDepends().isIndependent() || !(y = edge.getNeighbor(ind)).hasObviousType(d)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasObviousType(Collection coll) {
        for (ATermAppl c : coll) {
            DependencySet ds = this.getDepends(c);
            if (ds == null || !ds.isIndependent()) continue;
            return true;
        }
        return false;
    }

    public Individual getParent() {
        if (this.isBlockable()) {
            if (this.inEdges.size() == 0) {
                return null;
            }
            int n = this.inEdges.size();
            for (int i = 0; i < n; ++i) {
                Edge edge = this.inEdges.edgeAt(i);
                if (edge.getFrom().equals(this)) continue;
                return edge.getFrom();
            }
        }
        return null;
    }

    public Set getPredecessors() {
        return this.getInEdges().getPredecessors();
    }

    boolean hasPredecessor(Individual x) {
        return x.hasSuccessor(this);
    }

    public abstract boolean hasSuccessor(Node var1);

    public DependencySet getDepends(ATerm c) {
        return this.depends.get(c);
    }

    public Map getDepends() {
        return this.depends;
    }

    public Set<ATermAppl> getTypes() {
        return this.depends.keySet();
    }

    public void removeTypes() {
        this.depends.clear();
        this.status = 127;
    }

    public int prunedAt() {
        return this.pruned.branch;
    }

    public boolean isPruned() {
        return this.pruned != null;
    }

    public DependencySet getPruned() {
        return this.pruned;
    }

    public abstract void prune(DependencySet var1);

    public void unprune(int branch) {
        this.pruned = null;
        for (int i = 0; i < this.inEdges.size(); ++i) {
            Role role;
            Individual pred;
            Edge edge = this.inEdges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.branch > branch || (pred = edge.getFrom()).hasRSuccessor(role = edge.getRole(), this)) continue;
            pred.addOutEdge(edge);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("RESTORE: " + this.name + " ADD reverse edge " + edge));
        }
    }

    public abstract int getNominalLevel();

    public abstract boolean isNominal();

    public abstract boolean isBlockable();

    public abstract boolean isLiteral();

    public abstract boolean isIndividual();

    public int mergedAt() {
        return this.mergeDepends.branch;
    }

    public boolean isMerged() {
        return this.mergedTo != this;
    }

    public Node getMergedTo() {
        return this.mergedTo;
    }

    public DependencySet getMergeDependency(boolean all) {
        if (!this.isMerged() || !all) {
            return this.mergeDepends;
        }
        DependencySet ds = this.mergeDepends;
        Node node = this.mergedTo;
        while (node.isMerged()) {
            ds = ds.union(node.mergeDepends, this.abox.doExplanation());
            node = node.mergedTo;
        }
        return ds;
    }

    public Node getSame() {
        if (this.mergedTo == this) {
            return this;
        }
        return this.mergedTo.getSame();
    }

    public void undoSetSame() {
        this.mergedTo.removeMerged(this);
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.mergedTo = this;
    }

    private void addMerged(Node node) {
        if (this.merged == null) {
            this.merged = new HashSet<Node>(3);
        }
        this.merged.add(node);
    }

    private void removeMerged(Node node) {
        this.merged.remove(node);
        if (this.merged.isEmpty()) {
            this.merged = null;
        }
    }

    public void setSame(Node node, DependencySet ds) {
        if (this.isSame(node)) {
            return;
        }
        if (this.isDifferent(node)) {
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.setClash(Clash.nominal(this, ds.union(this.mergeDepends, this.abox.doExplanation()).union(node.mergeDepends, this.abox.doExplanation()), node.getName()));
            } else {
                this.abox.setClash(Clash.nominal(this, ds, node.getName()));
            }
            return;
        }
        this.mergedTo = node;
        this.mergeDepends = ds.copy();
        this.mergeDepends.branch = this.abox.getBranch();
        node.addMerged(this);
    }

    public boolean isSame(Node node) {
        return this.getSame().equals(node.getSame());
    }

    public boolean isDifferent(Node node) {
        return this.differents.containsKey(node);
    }

    public Set getDifferents() {
        return this.differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return this.differents.get(node);
    }

    public void setDifferent(Node node, DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.completionQueue.addEffected(this.abox.getBranch(), node.getName());
        }
        if (this.isDifferent(node)) {
            return;
        }
        if (this.isSame(node)) {
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.setClash(Clash.nominal(this, ds.union(this.mergeDepends, this.abox.doExplanation()).union(node.mergeDepends, this.abox.doExplanation()), node.getName()));
            } else {
                this.abox.setClash(Clash.nominal(this, ds, node.getName()));
            }
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        this.differents.put(node, ds);
        node.setDifferent(this, ds);
    }

    public void inheritDifferents(Node y, DependencySet ds) {
        for (Map.Entry<Node, DependencySet> entry : y.differents.entrySet()) {
            Node yDiff = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this.abox.doExplanation());
            this.setDifferent(yDiff, finalDS);
        }
    }

    public ATermAppl getName() {
        return this.name;
    }

    public abstract ATermAppl getTerm();

    public String getNameStr() {
        return this.name.getName();
    }

    public String toString() {
        return this.name.getName();
    }

    public List<ATermAppl> getPath() {
        LinkedList<ATermAppl> path = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            path.add(this.name);
        } else {
            Edge inEdge;
            HashSet<Node> cycle = new HashSet<Node>();
            Node node = this;
            while (!node.getInEdges().isEmpty() && !cycle.contains(node = (inEdge = node.getInEdges().edgeAt(0)).getFrom())) {
                cycle.add(node);
                path.addFirst(inEdge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                path.addFirst(node.getName());
                break;
            }
        }
        return path;
    }

    public ABox getABox() {
        return this.abox;
    }
}

