/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class TestOptimizations
extends PelletTestCase {
    public static int repeat = 1;

    public static final void main(String[] args) throws Exception {
        String file = null;
        file = "http://mged.sourceforge.net/ontologies/MGEDOntology.owl";
        file = "http://sweet.jpl.nasa.gov/ontology/earthrealm.owl";
        file = "http://www.w3.org/2001/sw/WebOnt/guide-src/wine.owl";
        if (args.length > 0) {
            file = args[0];
        }
        if (args.length > 1) {
            repeat = Integer.parseInt(args[1]);
        }
        TestOptimizations test = new TestOptimizations();
        test.run(file, repeat);
    }

    public KnowledgeBase load(String file) throws FileNotFoundException, IOException {
        KnowledgeBase kb = null;
        if (file.endsWith("akb")) {
            kb = new KnowledgeBase();
            kb.loadKRSS(new FileReader(file));
        } else {
            OWLReasoner reasoner = new OWLReasoner();
            Model model = ModelReader.read(file, ".*owl", 500);
            reasoner.load(model);
            kb = reasoner.getKB();
        }
        return kb;
    }

    public void run(String file, int repeat) throws Exception {
        KnowledgeBase kb = this.load(file);
        System.out.println(kb.getExpressivity().getNominals());
        System.out.println(kb.getInfo());
        boolean[][] options = new boolean[][]{{true, true, true, true, true, true, true}, {true, true, true, true, true, true, true}, {true, true, false, true, true, true, true}, {true, true, true, true, true, true, false}};
        TableData table = new TableData(new String[]{"Options", "Consistency", " Classify", "Realize", "# Cons", "# Subs", "# Inst"});
        for (int i = 0; i < options.length; ++i) {
            try {
                PelletOptions.USE_NOMINAL_ABSORPTION = options[i][0];
                PelletOptions.USE_HASVALUE_ABSORPTION = options[i][1];
                PelletOptions.USE_DISJUNCT_SORTING = options[i][2];
                PelletOptions.CHECK_NOMINAL_EDGES = options[i][3];
                PelletOptions.USE_SMART_RESTORE = options[i][4];
                PelletOptions.COPY_ON_WRITE = options[i][5];
                PelletOptions.USE_PSEUDO_MODEL = options[i][6];
                String name = "";
                name = options[i][0] ? name + "O" : name + "_";
                name = options[i][1] ? name + "H" : name + "_";
                name = options[i][2] ? name + "D" : name + "_";
                name = options[i][3] ? name + "M" : name + "_";
                name = options[i][4] ? name + "B" : name + "_";
                name = options[i][5] ? name + "C" : name + "_";
                name = options[i][6] ? name + "P" : name + "_";
                System.out.println("OPTIONS = " + name);
                System.out.println("   ONEOF ABSORPTION    = " + options[i][0]);
                System.out.println("   HASVALUE ABSORPTION = " + options[i][1]);
                System.out.println("   LEARNING DISJUNCT   = " + options[i][2]);
                System.out.println("   NOMINAL MODEL MERGE = " + options[i][3]);
                System.out.println("   PARTIAL BACKJUMPING = " + options[i][4]);
                System.out.println("   COPY ON WRITE       = " + options[i][5]);
                System.out.println("   PSEUDO MODEL COMPLE = " + options[i][6]);
                kb.timers.resetAll();
                for (int k = 0; k < repeat; ++k) {
                    System.out.print(k + 1 + ") ");
                    kb = this.load(file);
                    System.gc();
                    System.gc();
                    TestThread thread = new TestThread(kb);
                    thread.start();
                    thread.join(500000L);
                    if (!thread.isAlive()) continue;
                    System.out.println("****** TIMEOUT ******");
                    thread.stop();
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(name);
                row.add(new Double(TestOptimizations.getAvg(kb.timers.getTimer("consistency"))));
                row.add(new Double(TestOptimizations.getAvg(kb.timers.getTimer("classify"))));
                row.add(new Double(TestOptimizations.getAvg(kb.timers.getTimer("realize"))));
                row.add(new Double(TestOptimizations.getCount(kb.timers.getTimer("isConsistent")) / (double)repeat));
                row.add(new Double(TestOptimizations.getCount(kb.timers.getTimer("subClassSat")) / (double)repeat));
                row.add(new Double(TestOptimizations.getCount(kb.timers.getTimer("isType")) / (double)repeat));
                table.add(row);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            System.out.println();
            kb.timers.print();
        }
        System.out.println(table);
    }

    public static double getAvg(Timer timer) {
        if (timer == null) {
            return 0.0;
        }
        return timer.getAverage();
    }

    public static double getCount(Timer timer) {
        if (timer == null) {
            return 0.0;
        }
        return timer.getCount();
    }

    public static void printStats(Map stats) {
        for (ATermAppl disjunction : stats.keySet()) {
            int[] stat = (int[])stats.get(disjunction);
            ATermAppl term = (ATermAppl)disjunction.getArgument(0);
            ATermList disjuncts = (ATermList)term.getArgument(0);
            System.out.println(disjunction);
            int index = 0;
            while (!disjuncts.isEmpty()) {
                System.out.println(stat[index] + " - " + ATermUtils.negate((ATermAppl)disjuncts.getFirst()));
                disjuncts = disjuncts.getNext();
                ++index;
            }
        }
    }

    class TestThread
    extends Thread {
        KnowledgeBase kb;

        public TestThread(KnowledgeBase kb) {
            this.kb = kb;
        }

        public void run() {
            Timer t = this.kb.timers.startTimer("total");
            this.kb.ensureConsistency();
            System.out.print("Consistency: " + this.kb.timers.getTimer("consistency").getLast());
            this.kb.classify();
            System.out.print(" Classify: " + this.kb.timers.getTimer("classify").getLast());
            this.kb.realize();
            System.out.print(" Realize: " + this.kb.timers.getTimer("realize").getLast());
            t.stop();
            System.out.println(" Total: " + t.getLast());
        }
    }
}

