/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.QNameProvider;

public abstract class BaseXSDAtomicType
extends BaseDatatype
implements XSDAtomicType {
    protected GenericIntervalList values;
    protected ValueSpace valueSpace;

    protected BaseXSDAtomicType(ATermAppl name, ValueSpace valueSpace) {
        super(name);
        this.valueSpace = valueSpace;
        this.values = new GenericIntervalList(valueSpace.getMinValue(), valueSpace.getMaxValue(), valueSpace);
    }

    public abstract BaseXSDAtomicType create(GenericIntervalList var1);

    public ValueSpace getValueSpace() {
        return this.valueSpace;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return this.valueSpace.getValue(value.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public AtomicDatatype not() {
        return this.getPrimitiveType().difference(this);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            GenericIntervalList original = new GenericIntervalList(this.values);
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                GenericIntervalList.Interval interval = (GenericIntervalList.Interval)it.next();
                GenericIntervalList o = new GenericIntervalList(original);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
        }
        return this.create(result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            result.addIntervalList(this.values);
            result.addIntervalList(other.values);
        }
        return this.create(result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this == dt) {
            return EmptyDatatype.instance;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            result.addIntervalList(this.values);
            result.removeIntervalList(other.values);
        }
        return this.create(result);
    }

    public AtomicDatatype enumeration(Set enum_) {
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        for (Number number : enum_) {
            result.addInterval(number, number);
        }
        return this.create(result);
    }

    public Datatype singleton(Object value) {
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (value instanceof Number) {
            Number number = (Number)value;
            result.addInterval(number, number);
        }
        return this.create(result);
    }

    public int size() {
        return this.values.count();
    }

    public ATermAppl getValue(int i) {
        Object value = this.values.get(i);
        String lexical = this.valueSpace.getLexicalForm(value);
        return ATermUtils.makeTypedLiteral(lexical, this.getPrimitiveType().getURI());
    }

    public boolean contains(Object value) {
        if (this.valueSpace.isValid(value)) {
            return this.values.contains(value);
        }
        return false;
    }

    public XSDAtomicType deriveByRestriction(int facet, Object value) throws UnsupportedOperationException {
        try {
            Object start = this.valueSpace.getMinValue();
            Object end = this.valueSpace.getMaxValue();
            boolean incStart = true;
            boolean incEnd = true;
            if (facet == 256) {
                start = value;
            } else if (facet == 128) {
                start = value;
                incStart = false;
            } else if (facet == 32) {
                end = value;
            } else if (facet == 64) {
                end = value;
                incEnd = false;
            } else {
                return this;
            }
            GenericIntervalList intervalList = new GenericIntervalList(this.values);
            intervalList.restrictToInterval(start, incStart, end, incEnd);
            return this.create(intervalList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + facet);
        }
    }

    public XSDAtomicType restrictMin(boolean inclusive, Object value) {
        return inclusive ? this.deriveByRestriction(256, value) : this.deriveByRestriction(128, value);
    }

    public XSDAtomicType restrictMinInclusive(Object value) {
        return this.deriveByRestriction(256, value);
    }

    public XSDAtomicType restrictMinExclusive(Object value) {
        return this.deriveByRestriction(128, value);
    }

    public XSDAtomicType restrictMax(boolean inclusive, Object value) {
        return inclusive ? this.deriveByRestriction(32, value) : this.deriveByRestriction(64, value);
    }

    public XSDAtomicType restrictMaxInclusive(Object value) {
        return this.deriveByRestriction(32, value);
    }

    public XSDAtomicType restrictMaxExclusive(Object value) {
        return this.deriveByRestriction(64, value);
    }

    public XSDAtomicType restrictTotalDigits(int digits) {
        return this.deriveByRestriction(512, new Integer(digits));
    }

    public XSDAtomicType restrictFractionDigits(int digits) {
        return this.deriveByRestriction(1024, new Integer(digits));
    }

    public XSDAtomicType restrictPattern(String pattern) {
        return this.deriveByRestriction(8, pattern);
    }

    public String toString() {
        QNameProvider qnames = new QNameProvider();
        String str = this.name == null ? qnames.shortForm(this.getPrimitiveType().getName().toString()) + " " + this.values : qnames.shortForm(this.name.toString());
        return str;
    }
}

