/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.net.URI;
import java.util.Set;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationExample {
    public static void main(String[] args) throws OWLOntologyCreationException {
        String file = "http://www.cs.man.ac.uk/%7Ehorrocks/ISWC2003/Tutorial/people+pets.owl.rdf";
        String ns = "http://cohse.semanticweb.org/ontologies/people#";
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        System.out.print("Reading file " + file + "...");
        OWLOntology ontology = manager.loadOntology(URI.create(file));
        System.out.println("done.");
        OWLClass mad_cow = factory.getOWLClass(URI.create(ns + "mad+cow"));
        OWLClass animal_lover = factory.getOWLClass(URI.create(ns + "animal+lover"));
        OWLClass pet_owner = factory.getOWLClass(URI.create(ns + "pet+owner"));
        PelletOptions.USE_TRACING = true;
        Reasoner pellet = new Reasoner(manager);
        pellet.loadOntology(ontology);
        pellet.getKB().setDoExplanation(true);
        pellet.isSatisfiable((OWLDescription)mad_cow);
        Set<OWLAxiom> exp1 = pellet.getExplanation();
        ExplanationExample.printAxioms("Why is mad+cow concept unsatisfiable:", exp1);
        pellet.isSubClassOf((OWLDescription)animal_lover, (OWLDescription)pet_owner);
        Set<OWLAxiom> exp2 = pellet.getExplanation();
        ExplanationExample.printAxioms("Why is animal lover subclass of pet owner:", exp2);
    }

    public static void printAxioms(String header, Set<OWLAxiom> axioms) {
        System.out.println(header + ": ");
        for (OWLAxiom axiom : axioms) {
            System.out.println("   " + axiom);
        }
    }
}

