/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import aterm.ATermAppl;
import java.util.Iterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;

public class QuerySubsumptionExample {
    String ont = "http://owldl.com/ontologies/family.owl";
    String family = "http://www.example.org/family#";
    String prefix = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX family: <" + this.family + ">\r\n" + "SELECT * { ";
    String suffix = " }";
    KnowledgeBase kb;
    QueryParser parser;

    public static void main(String[] args) throws Exception {
        new QuerySubsumptionExample().run();
    }

    public QuerySubsumptionExample() {
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(this.ont);
        this.kb = reasoner.getKB();
        this.parser = QueryEngine.createParser();
    }

    public Query query(String queryStr) {
        return this.parser.parse(this.prefix + queryStr + this.suffix, this.kb);
    }

    public void run() {
        this.example1();
        this.example2();
        this.example3();
        this.example4();
    }

    public void example1() {
        Query q1 = this.query("?x a family:Male .");
        Query q2 = this.query("?x a family:Person .");
        System.out.println("Example 1");
        System.out.println("=========");
        System.out.println("Query 1: " + q1.toString(false));
        System.out.println("Query 2: " + q2.toString(false));
        System.out.println();
        System.out.println("Query 1 is subsumed by query 2: " + QueryEngine.isSubsumedBy(q1, q2));
        System.out.println("Query 2 is subsumed by query 1: " + QueryEngine.isSubsumedBy(q2, q1));
        System.out.println();
    }

    public void example2() {
        Query q3 = this.query("?x family:isMarriedTo ?y . ?y rdf:type family:Male");
        Query q4 = this.query("?x a family:Female .");
        System.out.println("Example 2");
        System.out.println("=========");
        System.out.println("Query 3: " + q3.toString(false));
        System.out.println("Query 4: " + q4.toString(false));
        System.out.println();
        System.out.println("Query 3 is subsumed by query 4: " + QueryEngine.isSubsumedBy(q3, q4));
        System.out.println("Query 4 is subsumed by query 3: " + QueryEngine.isSubsumedBy(q4, q3));
        System.out.println();
    }

    public void example3() {
        Query q5 = this.query("?x family:hasFather ?y . ");
        Query q6 = this.query("?x family:hasParent ?y . ?y a family:Male .");
        System.out.println();
        System.out.println("Example 3");
        System.out.println("=========");
        System.out.println("Query 5: " + q5.toString(false));
        System.out.println("Query 6: " + q6.toString(false));
        System.out.println();
        System.out.println("Query 5 is subsumed by query 6: " + QueryEngine.isSubsumedBy(q5, q6));
        System.out.println("Query 6 is subsumed by query 5: " + QueryEngine.isSubsumedBy(q5, q6));
        System.out.println("Query 5 is equivalent to query 6: " + QueryEngine.isEquivalent(q5, q6));
        System.out.println();
    }

    public void example4() {
        Query q7 = this.query("?x a family:Female; family:hasBrother ?y . ");
        Query q8 = this.query("?x a family:Female; family:hasSibling ?z .");
        System.out.println("Example 4");
        System.out.println("=========");
        System.out.println("Query 7: " + q7.toString(false));
        System.out.println("Query 8: " + q8.toString(false));
        System.out.println();
        System.out.println("Query 7 is subsumed by query 8: " + QueryEngine.isSubsumedBy(q7, q8));
        System.out.print("Subsumption mappings: ");
        QueryResults mappings = QueryEngine.getSubsumptionMappings(q7, q8);
        QueryResultBinding mapping = mappings.get(0);
        Iterator j = q8.getVars().iterator();
        while (j.hasNext()) {
            ATermAppl var = (ATermAppl)j.next();
            System.out.print(var.getArgument(0) + " -> " + mapping.getValue(var));
            if (!j.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println();
        System.out.println();
    }
}

