/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class ModelExtractor {
    private OWLReasoner reasoner;
    private KnowledgeBase kb;
    private boolean verbose;
    private boolean includeDirects;

    public ModelExtractor() {
    }

    public ModelExtractor(OWLReasoner reasoner) {
        this.setReasoner(reasoner);
    }

    public Model extractModel() {
        Model model = ModelFactory.createDefaultModel();
        model = this.extractClassModel(model);
        model = this.extractPropertyModel(model);
        if (this.kb.isRealized()) {
            model = this.extractIndividualModel(model);
        }
        return model;
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel() {
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        this.kb.classify();
        HashSet<ATermAppl> classes = new HashSet<ATermAppl>(this.kb.getClasses());
        classes.add(ATermUtils.TOP);
        classes.add(ATermUtils.BOTTOM);
        for (ATermAppl c : classes) {
            Resource r = this.reasoner.toJenaResource(c);
            model.add(r, RDF.type, (RDFNode)OWL.Class);
            model.add(OWL.Nothing, RDFS.subClassOf, (RDFNode)r);
            Set<ATermAppl> eqs = this.kb.getEquivalentClasses(c);
            eqs.add(c);
            Iterator<ATermAppl> j = eqs.iterator();
            while (j.hasNext()) {
                Resource eq = this.reasoner.toJenaResource(j.next());
                model.add(r, OWL.equivalentClass, (RDFNode)eq);
                if (!this.verbose) continue;
                model.add(r, RDFS.subClassOf, (RDFNode)eq);
                model.add(eq, RDFS.subClassOf, (RDFNode)r);
            }
            Set<Object> supers = this.verbose ? this.kb.getSuperClasses(c) : this.kb.getSuperClasses(c, true);
            supers = SetUtils.union(supers);
            Iterator<Object> j2 = supers.iterator();
            while (j2.hasNext()) {
                Resource sup = this.reasoner.toJenaResource((ATermAppl)j2.next());
                model.add(r, RDFS.subClassOf, (RDFNode)sup);
            }
            if (this.includeDirects) {
                Set<Object> direct = this.verbose ? SetUtils.union(this.kb.getSuperClasses(c, true)) : supers;
                Iterator<Object> j3 = direct.iterator();
                while (j3.hasNext()) {
                    Resource resource = this.reasoner.toJenaResource((ATermAppl)j3.next());
                    model.add(r, ReasonerVocabulary.directSubClassOf, (RDFNode)resource);
                }
            }
            Set<Set<ATermAppl>> disj = this.kb.getDisjoints(c);
            for (Set<ATermAppl> set : disj) {
                for (ATermAppl a : set) {
                    if (!this.kb.isClass(a)) continue;
                    Resource d = this.reasoner.toJenaResource(a);
                    model.add(r, OWL.disjointWith, (RDFNode)d);
                    model.add(d, OWL.disjointWith, (RDFNode)r);
                }
            }
            Set<ATermAppl> comp = this.kb.getComplements(c);
            for (ATermAppl a : comp) {
                if (!this.kb.isClass(a)) continue;
                Resource d = this.reasoner.toJenaResource(a);
                model.add(r, OWL.complementOf, (RDFNode)d);
                model.add(d, OWL.complementOf, (RDFNode)r);
            }
        }
        return model;
    }

    public Model extractIndividualModel(Model model) {
        this.kb.realize();
        Set<ATermAppl> individuals = this.kb.getIndividuals();
        for (ATermAppl ind : individuals) {
            Resource r = this.reasoner.toJenaResource(ind);
            Set<Object> types = this.verbose ? this.kb.getTypes(ind) : this.kb.getTypes(ind, true);
            types = SetUtils.union(types);
            for (ATermAppl aTermAppl : types) {
                model.add(r, RDF.type, (RDFNode)this.reasoner.toJenaResource(aTermAppl));
            }
            if (this.includeDirects) {
                Set<Object> direct = this.verbose ? SetUtils.union(this.kb.getTypes(ind, true)) : types;
                Iterator<Object> iterator = direct.iterator();
                while (iterator.hasNext()) {
                    Resource sup = this.reasoner.toJenaResource((ATermAppl)iterator.next());
                    model.add(r, ReasonerVocabulary.directRDFType, (RDFNode)sup);
                }
            }
            Collection<Role> props = this.kb.getRBox().getRoles();
            for (Role role : props) {
                ATermAppl name = role.getName();
                Resource rRole = this.reasoner.toJenaProperty(name);
                if (role.isAnon() || role.isDatatypeRole() || !role.isObjectRole()) continue;
                Set<ATermAppl> objectInds = this.kb.getIndividuals();
                for (ATermAppl objectInd : objectInds) {
                    Resource rObjectInd = this.reasoner.toJenaResource(objectInd);
                    if (!this.kb.isType(ind, ATermUtils.makeHasValue(name, objectInd))) continue;
                    Property p = (Property)rRole;
                    model.add(r, (Property)rRole, (RDFNode)rObjectInd);
                }
            }
        }
        return model;
    }

    public Model extractPropertyModel(Model model) {
        this.kb.prepare();
        Collection<Role> props = this.kb.getRBox().getRoles();
        for (Role role : props) {
            ATermAppl name = role.getName();
            if (role.isAnon()) continue;
            Resource r = this.reasoner.toJenaResource(name);
            if (role.isDatatypeRole()) {
                model.add(r, RDF.type, (RDFNode)OWL.DatatypeProperty);
            } else {
                if (!role.isObjectRole()) continue;
                model.add(r, RDF.type, (RDFNode)OWL.ObjectProperty);
            }
            model.add(r, RDF.type, (RDFNode)RDF.Property);
            if (role.isFunctional()) {
                model.add(r, RDF.type, (RDFNode)OWL.FunctionalProperty);
            }
            if (role.isInverseFunctional()) {
                model.add(r, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
            }
            if (role.isTransitive()) {
                model.add(r, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
            if (role.isSymmetric()) {
                model.add(r, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
            Set<ATermAppl> eqs = this.kb.getAllEquivalentProperties(name);
            for (ATermAppl eq : eqs) {
                Resource eqR = this.reasoner.toJenaResource(eq);
                model.add(r, OWL.equivalentProperty, (RDFNode)eqR);
                model.add(r, RDFS.subPropertyOf, (RDFNode)eqR);
            }
            Set<ATermAppl> inverses = this.kb.getInverses(name);
            for (ATermAppl inverse : inverses) {
                Resource resource = this.reasoner.toJenaResource(inverse);
                model.add(r, OWL.inverseOf, (RDFNode)resource);
            }
            Set<Object> supers = this.verbose ? this.kb.getSuperProperties(name) : this.kb.getSuperProperties(name, true);
            supers = SetUtils.union(supers);
            for (ATermAppl aTermAppl : supers) {
                model.add(r, RDFS.subPropertyOf, (RDFNode)this.reasoner.toJenaResource(aTermAppl));
            }
            if (!this.includeDirects) continue;
            Set<Object> direct = this.verbose ? SetUtils.union(this.kb.getSuperProperties(name, true)) : supers;
            for (ATermAppl aTermAppl : direct) {
                model.add(r, ReasonerVocabulary.directSubPropertyOf, (RDFNode)this.reasoner.toJenaResource(aTermAppl));
            }
        }
        return model;
    }

    public boolean isIncludeDirects() {
        return this.includeDirects;
    }

    public void setIncludeDirects(boolean includeDirects) {
        this.includeDirects = includeDirects;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.kb = reasoner.getKB();
    }
}

