/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import org.mindswap.pellet.output.ATermBaseRenderer;
import org.mindswap.pellet.output.ATermRenderer;

public class ATermAbstractSyntaxRenderer
extends ATermBaseRenderer
implements ATermRenderer {
    public void visitAnd(ATermAppl term) {
        this.out.print("intersectionOf(");
        this.visitList((ATermList)term.getArgument(0));
        this.out.print(")");
    }

    public void visitOr(ATermAppl term) {
        this.out.print("unionOf(");
        this.visitList((ATermList)term.getArgument(0));
        this.out.print(")");
    }

    public void visitNot(ATermAppl term) {
        this.out.print("complementOf(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    public void visitSome(ATermAppl term) {
        this.out.print("restriction(");
        this.visitTerm((ATermAppl)term.getArgument(0));
        this.out.print(" someValuesFrom(");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print("))");
    }

    public void visitAll(ATermAppl term) {
        this.out.print("restriction(");
        this.visitTerm((ATermAppl)term.getArgument(0));
        this.out.print(" allValuesFrom(");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print("))");
    }

    public void visitMin(ATermAppl term) {
        this.out.print("restriction(");
        this.visitTerm((ATermAppl)term.getArgument(0));
        this.out.print(" minCardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    public void visitMax(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" maxCardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    public void visitCard(ATermAppl term) {
        this.out.print("restriction(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" cardinality(" + ((ATermInt)term.getArgument(1)).getInt() + ")");
        this.out.print(")");
    }

    public void visitLiteral(ATermAppl lit) {
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        this.out.print("\"" + lexicalValue + "\"");
        if (!lang.equals("")) {
            this.out.print("@" + lang);
        } else if (!datatypeURI.equals("")) {
            this.out.print("^^");
            this.out.printURI(datatypeURI);
        }
    }

    public void visitOneOf(ATermAppl term) {
        this.out.print("oneOf(");
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl value = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)value.getArgument(0));
            if ((list = list.getNext()).isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print(")");
    }

    public void visitHasValue(ATermAppl term) {
        this.out.print("restriction(");
        this.visitTerm((ATermAppl)term.getArgument(0));
        this.out.print(" value(");
        ATermAppl value = (ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0);
        if (value.getArity() == 0) {
            this.visitTerm(value);
        } else {
            this.visitLiteral(value);
        }
        this.out.print("))");
    }

    public void visitValue(ATermAppl term) {
        this.out.print("oneOf(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    public void visitList(ATermList list) {
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            if ((list = list.getNext()).isEmpty()) continue;
            this.out.print(" ");
        }
    }

    public void visitSelf(ATermAppl term) {
        this.out.print("restriction(");
        this.visitTerm((ATermAppl)term.getArgument(0));
        this.out.print(" self)");
    }

    public void visitSubClass(ATermAppl term) {
        this.out.print("SubClassOf(");
        this.visitList(term.getArguments());
        this.out.print(")");
    }
}

