/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalTaxonomyPrinter
implements TaxonomyPrinter {
    private Taxonomy taxonomy;
    private OutputFormatter out;
    private Set<ATermAppl> bottomEquivalents;
    private Set<ATermAppl> printed;
    private static final Comparator<ATermAppl> comparator = new Comparator<ATermAppl>(){

        @Override
        public int compare(ATermAppl c, ATermAppl d) {
            return Comparators.stringComparator.compare(c.getName(), d.getName());
        }
    };
    private static final Comparator<Collection<ATermAppl>> setComparator = new Comparator<Collection<ATermAppl>>(){

        @Override
        public int compare(Collection<ATermAppl> c, Collection<ATermAppl> d) {
            return comparator.compare(c.iterator().next(), d.iterator().next());
        }
    };

    @Override
    public void print(Taxonomy taxonomy) {
        this.print(taxonomy, new OutputFormatter());
    }

    @Override
    public void print(Taxonomy taxonomy, OutputFormatter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        this.bottomEquivalents = new TreeSet<ATermAppl>(comparator);
        this.bottomEquivalents.addAll(taxonomy.getAllEquivalents(ATermUtils.BOTTOM));
        this.printed = new HashSet<ATermAppl>();
        out.println();
        TreeSet<ATermAppl> sortedTop = new TreeSet<ATermAppl>(comparator);
        sortedTop.addAll(taxonomy.getAllEquivalents(ATermUtils.TOP));
        Set<TreeSet<ATermAppl>> topGroup = Collections.singleton(sortedTop);
        this.printGroup(topGroup);
        this.taxonomy = null;
        this.out = null;
        this.bottomEquivalents = null;
        this.printed = null;
        out.println();
        out.flush();
    }

    private void printGroup(Collection<? extends Collection<ATermAppl>> concepts) {
        LinkedHashSet<Collection<ATermAppl>> nextGroup = new LinkedHashSet<Collection<ATermAppl>>();
        for (Collection<ATermAppl> collection : concepts) {
            ATermAppl firstC = collection.iterator().next();
            Set<Set<ATermAppl>> supEqs = this.taxonomy.getSupers(firstC, true);
            if (supEqs.size() > 1 && this.printed.contains(firstC)) continue;
            this.printed.add(firstC);
            this.out.print("(");
            this.printEqClass(collection);
            this.out.print(" ");
            TreeSet<Collection<ATermAppl>> sortedSupEqs = new TreeSet<Collection<ATermAppl>>(setComparator);
            Iterator<Set<ATermAppl>> j = supEqs.iterator();
            while (j.hasNext()) {
                TreeSet<ATermAppl> group = new TreeSet<ATermAppl>(comparator);
                group.addAll((Collection<ATermAppl>)j.next());
                sortedSupEqs.add(group);
            }
            this.printEqClassGroups(sortedSupEqs);
            this.out.print(" ");
            TreeSet<Collection<ATermAppl>> sortedSubEqs = new TreeSet<Collection<ATermAppl>>(setComparator);
            Set<Set<ATermAppl>> subEqs = this.taxonomy.getSubs(firstC, true);
            Iterator<Set<ATermAppl>> j2 = subEqs.iterator();
            while (j2.hasNext()) {
                TreeSet<ATermAppl> group = new TreeSet<ATermAppl>(comparator);
                group.addAll((Collection<ATermAppl>)j2.next());
                sortedSubEqs.add(group);
            }
            this.printEqClassGroups(sortedSubEqs);
            nextGroup.addAll(sortedSubEqs);
            this.out.println(")");
        }
        switch (nextGroup.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.printGroup(nextGroup);
                break;
            }
            default: {
                nextGroup.remove(this.bottomEquivalents);
                this.printGroup(nextGroup);
            }
        }
    }

    private void printEqClass(Collection<ATermAppl> concept) {
        int size = concept.size();
        ATermAppl c2 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                c2 = concept.iterator().next();
                this.printURI(c2);
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (ATermAppl c2 : concept) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printURI(c2);
                }
                this.out.print(")");
            }
        }
    }

    private void printEqClassGroups(Collection<? extends Collection<ATermAppl>> concepts) {
        int size = concepts.size();
        Object var3_3 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                Collection<ATermAppl> collection = concepts.iterator().next();
                this.out.print("(");
                this.printEqClass(collection);
                this.out.print(")");
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (Collection<ATermAppl> collection : concepts) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printEqClass(collection);
                }
                this.out.print(")");
            }
        }
    }

    private void printURI(ATermAppl c) {
        String uri = c.getName();
        if (c.equals(ATermUtils.TOP)) {
            uri = "http://www.w3.org/2002/07/owl#Thing";
        } else if (c.equals(ATermUtils.BOTTOM)) {
            uri = "http://www.w3.org/2002/07/owl#Nothing";
        }
        this.out.printURI(uri);
    }
}

