/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATermAppl;
import com.hp.hpl.jena.query.Syntax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryCost;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.ARQParser;
import org.mindswap.pellet.query.impl.DistVarsQueryExec;
import org.mindswap.pellet.query.impl.MultiQueryResults;
import org.mindswap.pellet.query.impl.NoDistVarsQueryExec;
import org.mindswap.pellet.query.impl.OptimizedQueryExec;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.query.impl.SimpleQueryExec;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.PermutationGenerator;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.SizeEstimate;
import org.mindswap.pellet.utils.Timer;

public class QueryEngine {
    public static final Log log = LogFactory.getLog(QueryEngine.class);
    public static final Syntax DEFAULT_SYNTAX = Syntax.syntaxSPARQL;
    private static DistVarsQueryExec distVars = new DistVarsQueryExec();
    private static OptimizedQueryExec optimized = new OptimizedQueryExec();
    private static SimpleQueryExec simple = new SimpleQueryExec();
    private static NoDistVarsQueryExec noVars = new NoDistVarsQueryExec();
    private static QueryExec[] queryExecs = new QueryExec[]{noVars, distVars, optimized, simple};

    public static QueryParser createParser() {
        return QueryEngine.createParser(DEFAULT_SYNTAX);
    }

    public static QueryParser createParser(Syntax syntax) {
        ARQParser parser = new ARQParser();
        parser.setSyntax(syntax);
        return parser;
    }

    public static QueryResults exec(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, DEFAULT_SYNTAX);
    }

    public static QueryResults execRDQL(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, Syntax.syntaxRDQL);
    }

    public static QueryResults execSPARQL(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, Syntax.syntaxSPARQL);
    }

    public static Query parse(String queryStr, KnowledgeBase kb) {
        return QueryEngine.parse(queryStr, kb, DEFAULT_SYNTAX);
    }

    public static Query parse(String queryStr, KnowledgeBase kb, Syntax syntax) {
        QueryParser parser = QueryEngine.createParser(syntax);
        Query query = parser.parse(queryStr, kb);
        return query;
    }

    public static QueryResults exec(String queryStr, KnowledgeBase kb, Syntax syntax) {
        Query query = QueryEngine.parse(queryStr, kb, syntax);
        return QueryEngine.exec(query);
    }

    public static QueryResults exec(Query query, KnowledgeBase kb) {
        KnowledgeBase origKB = query.getKB();
        query.setKB(kb);
        QueryResults results = QueryEngine.exec(query);
        query.setKB(origKB);
        return results;
    }

    public static QueryResults exec(Query query) {
        List queries;
        if (query.getQueryPatterns().isEmpty()) {
            QueryResultsImpl results = new QueryResultsImpl(query);
            results.add(new QueryResultBindingImpl());
            return results;
        }
        if (query.isGround()) {
            return noVars.exec(query);
        }
        if (PelletOptions.SIMPLIFY_QUERY) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Simplifying:\n" + query));
            }
            QueryEngine.simplify(query);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Split:\n" + query));
        }
        if ((queries = QueryEngine.split(query)).isEmpty()) {
            throw new InternalReasonerException("Splitting query returned no results!");
        }
        if (queries.size() == 1) {
            return QueryEngine.execSingleQuery((Query)queries.get(0));
        }
        QueryResults[] results = new QueryResults[queries.size()];
        for (int i = 0; i < queries.size(); ++i) {
            Query qry = (Query)queries.get(i);
            results[i] = QueryEngine.execSingleQuery(qry);
        }
        return new MultiQueryResults(query, results);
    }

    private static QueryResults execSingleQuery(Query query) {
        query.prepare();
        if (query.hasUndefinedPredicate()) {
            return new QueryResultsImpl(query);
        }
        if (PelletOptions.SAMPLING_RATIO > 0.0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reorder\n" + query));
            }
            query = QueryEngine.reorder(query);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Execute\n" + query));
        }
        for (int i = 0; i < queryExecs.length; ++i) {
            if (!queryExecs[i].supports(query)) continue;
            Timer timer = query.getKB().timers.startTimer("Query");
            QueryExec queryExec = queryExecs[i];
            QueryResults results = queryExec.exec(query);
            timer.stop();
            return results;
        }
        throw new InternalReasonerException("Cannot determine which query engine to use");
    }

    public static Query reorder(Query query) {
        double minCost = Double.POSITIVE_INFINITY;
        KnowledgeBase kb = query.getKB();
        if (kb.getIndividuals().size() <= 100) {
            return query;
        }
        QueryEngine.computeSizeEstimates(query);
        QueryCost queryCost = new QueryCost(query.getKB());
        List patterns = query.getQueryPatterns();
        ArrayList bestOrder = null;
        int n = patterns.size();
        PermutationGenerator gen = new PermutationGenerator(n);
        int i = 0;
        while (gen.hasMore()) {
            int[] perm = gen.getNext();
            ArrayList newPatterns = new ArrayList();
            for (int j = 0; j < n; ++j) {
                newPatterns.add(patterns.get(perm[j]));
            }
            double cost = queryCost.estimateCost(newPatterns);
            if (cost < minCost) {
                minCost = cost;
                bestOrder = newPatterns;
            }
            ++i;
        }
        if (bestOrder == patterns) {
            return query;
        }
        QueryImpl newQuery = new QueryImpl(kb);
        for (int j = 0; j < n; ++j) {
            newQuery.addPattern((QueryPattern)bestOrder.get(j));
        }
        for (ATermAppl var : query.getResultVars()) {
            newQuery.addResultVar(var);
        }
        for (ATermAppl var : query.getDistVars()) {
            newQuery.addDistVar(var);
        }
        return newQuery;
    }

    public static List split(Query query) {
        try {
            Set distVars = query.getDistVars();
            HashSet resultVars = new HashSet(query.getResultVars());
            DisjointSet disjointSet = new DisjointSet();
            List patterns = query.getQueryPatterns();
            for (QueryPattern pattern : patterns) {
                ATermAppl subj = pattern.getSubject();
                ATermAppl obj = pattern.getObject();
                if (pattern.isTypePattern()) {
                    disjointSet.add(subj);
                    continue;
                }
                disjointSet.add(subj);
                disjointSet.add(obj);
                disjointSet.union(subj, obj);
            }
            Collection equivalenceSets = disjointSet.getEquivalanceSets();
            if (equivalenceSets.size() == 1) {
                return Collections.singletonList(query);
            }
            HashMap<Object, Query> queries = new HashMap<Object, Query>();
            for (QueryPattern pattern : patterns) {
                ATermAppl subj = pattern.getSubject();
                ATermAppl pred = pattern.getPredicate();
                ATermAppl obj = pattern.getObject();
                Object representative = disjointSet.find(subj);
                Query newQuery = (Query)queries.get(representative);
                if (newQuery == null) {
                    newQuery = new QueryImpl(query.getKB());
                    queries.put(representative, newQuery);
                }
                if (resultVars.contains(subj)) {
                    newQuery.addResultVar(subj);
                } else if (distVars.contains(subj)) {
                    newQuery.addDistVar(subj);
                }
                if (pattern.isTypePattern()) {
                    newQuery.addTypePattern(subj, obj);
                    continue;
                }
                newQuery.addEdgePattern(subj, pred, obj);
                if (resultVars.contains(obj)) {
                    newQuery.addResultVar(obj);
                    continue;
                }
                if (!distVars.contains(obj)) continue;
                newQuery.addDistVar(obj);
            }
            return new ArrayList(queries.values());
        }
        catch (RuntimeException e) {
            log.warn((Object)"Query split failed, continuing with query execution.");
            e.printStackTrace();
            return Collections.singletonList(query);
        }
    }

    public static void simplify(Query query) {
        HashMap allInferredTypes = new HashMap();
        KnowledgeBase kb = query.getKB();
        Set vars = query.getObjVars();
        for (ATermAppl var : vars) {
            HashSet<ATermAppl> inferredTypes = new HashSet<ATermAppl>();
            List outList = query.findPatterns(var, null, null);
            for (QueryPattern pattern : outList) {
                ATermAppl pred = pattern.getPredicate();
                inferredTypes.addAll(kb.getDomains(pred));
            }
            List inList = query.findPatterns(null, null, var);
            for (QueryPattern pattern : inList) {
                ATermAppl pred = pattern.getPredicate();
                inferredTypes.addAll(kb.getRanges(pred));
            }
            if (inferredTypes.isEmpty()) continue;
            allInferredTypes.put(var, inferredTypes);
        }
        ArrayList patterns = new ArrayList(query.getQueryPatterns());
        for (QueryPattern pattern : patterns) {
            ATermAppl var;
            Set inferredTypes;
            if (pattern.isEdgePattern() || (inferredTypes = (Set)allInferredTypes.get(var = pattern.getSubject())) == null) continue;
            ATermAppl c = pattern.getObject();
            if (inferredTypes.contains(c)) {
                query.removePattern(pattern);
                continue;
            }
            if (!kb.isClassified()) continue;
            Set subs = kb.getTaxonomy().getSubSupers(c, false, true, true);
            Set<ATermAppl> eqs = kb.getAllEquivalentClasses(c);
            if (!SetUtils.intersects(inferredTypes, subs) && !SetUtils.intersects(inferredTypes, eqs)) continue;
            query.removePattern(pattern);
        }
    }

    public static void prepare(KnowledgeBase kb) {
        QueryEngine.computeSizeEstimates(kb);
    }

    public static void computeSizeEstimates(KnowledgeBase kb) {
        kb.getSizeEstimate().computeAll();
    }

    public static void prepare(Query ... queries) {
        QueryEngine.computeSizeEstimates(queries);
    }

    public static void computeSizeEstimates(Query ... queries) {
        if (queries == null || queries.length == 0) {
            throw new IllegalArgumentException("No query specified!");
        }
        SizeEstimate sizeEstimate = queries[0].getKB().getSizeEstimate();
        HashSet<ATermAppl> concepts = new HashSet<ATermAppl>();
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
        for (int j = 0; j < queries.length; ++j) {
            Query query = queries[j];
            List patterns = query.getQueryPatterns();
            for (int i = 0; i < patterns.size(); ++i) {
                QueryPattern pattern = (QueryPattern)patterns.get(i);
                if (pattern.isTypePattern()) {
                    if (sizeEstimate.isComputed(pattern.getObject())) continue;
                    concepts.add(pattern.getObject());
                    continue;
                }
                if (sizeEstimate.isComputed(pattern.getPredicate())) continue;
                properties.add(pattern.getPredicate());
            }
        }
        sizeEstimate.compute(concepts, properties);
    }

    public static boolean execBoolean(Query query) {
        return noVars.execBoolean(query);
    }

    public static boolean isEquivalent(Query q1, Query q2) {
        return QueryEngine.isSubsumedBy(q1, q2) && QueryEngine.isSubsumedBy(q2, q1);
    }

    public static boolean isSubsumed(Query sub, Query sup) {
        return QueryEngine.isSubsumedBy(sub, sup);
    }

    public static boolean isSubsumedBy(Query sub, Query sup) {
        return !QueryEngine.getSubsumptionMappings(sub, sup).isEmpty();
    }

    public static boolean isSubsumed(Query sub, Query sup, KnowledgeBase backgroundKB) {
        return QueryEngine.isSubsumedBy(sub, sup, backgroundKB);
    }

    public static boolean isSubsumedBy(Query sub, Query sup, KnowledgeBase backgroundKB) {
        return !QueryEngine.getSubsumptionMappings(sub, sup, backgroundKB).isEmpty();
    }

    public static QueryResults getSubsumptionMappings(Query sub, Query sup) {
        return QueryEngine.getSubsumptionMappings(sub, sup, sub.getKB());
    }

    public static QueryResults getSubsumptionMappings(Query sub, Query sup, KnowledgeBase backgroundKB) {
        KnowledgeBase kb = backgroundKB.copy(true);
        List patterns = sub.getQueryPatterns();
        for (QueryPattern pattern : patterns) {
            ATermAppl subj = pattern.getSubject();
            ATermAppl pred = pattern.getPredicate();
            ATermAppl obj = pattern.getObject();
            subj = ATermUtils.isVar(subj) ? subj.getArgument(0) : subj;
            obj = ATermUtils.isVar(obj) ? obj.getArgument(0) : obj;
            kb.addIndividual(subj);
            if (pattern.isTypePattern()) {
                kb.addType(subj, obj);
                continue;
            }
            kb.addIndividual(obj);
            kb.addPropertyValue(pred, subj, obj);
        }
        kb.isConsistent();
        sup.setKB(kb);
        QueryResults results = QueryEngine.exec(sup);
        sup.setKB(backgroundKB);
        return results;
    }
}

