/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.utils.ATermUtils;

public class DistVarsQueryExec
implements QueryExec {
    public static Log log = LogFactory.getLog(QueryEngine.class);
    protected Query query;
    protected KnowledgeBase kb;
    protected List patterns;
    protected Set vars;

    public void prepare() {
        this.kb = this.query.getKB();
        this.patterns = this.query.getQueryPatterns();
        this.vars = this.query.getObjVars();
        if (this.kb == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        if (PelletOptions.USE_CACHING && !this.kb.isClassified()) {
            for (ATermAppl var : this.vars) {
                ATermList list = this.query.getClasses(var);
                while (!list.isEmpty()) {
                    ATermAppl c = (ATermAppl)list.getFirst();
                    ATermAppl notC = ATermUtils.makeNot(c);
                    this.kb.isSatisfiable(c);
                    this.kb.isSatisfiable(notC);
                    list = list.getNext();
                }
            }
        }
    }

    public boolean supports(Query q) {
        return q.getDistVars().containsAll(q.getVars());
    }

    public boolean execBoolean(Query query) {
        this.query = query;
        if (!query.getVars().isEmpty()) {
            throw new RuntimeException("Boolean query cannot have variables!");
        }
        this.prepare();
        return this.isQuerySatisfied();
    }

    public QueryResults exec(Query query) {
        this.query = query;
        this.prepare();
        QueryResultsImpl results = new QueryResultsImpl(query);
        if (this.isQuerySatisfied()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Bind nonground triples");
            }
            this.exec(0, new QueryResultBindingImpl(), results);
        }
        return results;
    }

    protected void exec(int index, QueryResultBinding binding, QueryResults results) {
        if (this.patterns.size() <= index) {
            if (!results.getResultVars().containsAll(binding.getVars())) {
                QueryResultBindingImpl newBinding = new QueryResultBindingImpl();
                List resultVars = results.getResultVars();
                for (int i = 0; i < resultVars.size(); ++i) {
                    ATermAppl var = (ATermAppl)resultVars.get(i);
                    ATermAppl value = binding.getValue(var);
                    newBinding.setValue(var, value);
                }
                binding = newBinding;
                if (results.contains(binding)) {
                    return;
                }
            }
            results.add(binding);
            return;
        }
        QueryPattern pattern0 = (QueryPattern)this.patterns.get(index);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Check pattern " + pattern0 + " " + binding));
        }
        boolean alreadySatisfied = false;
        Collection<Object> sValues = null;
        List<ATermAppl> oValues = null;
        if (!pattern0.isGround()) {
            QueryPattern pattern = pattern0.apply(binding);
            ATermAppl subj = pattern.getSubject();
            ATermAppl pred = pattern.getPredicate();
            ATermAppl obj = pattern.getObject();
            if (ATermUtils.isVar(subj)) {
                if (pattern.isTypePattern()) {
                    sValues = this.kb.getInstances(obj);
                    alreadySatisfied = true;
                } else {
                    sValues = !ATermUtils.isVar(obj) ? this.kb.getIndividualsWithProperty(pred, obj) : this.kb.getIndividuals();
                }
            } else {
                sValues = Collections.singletonList(subj);
            }
            Datatype datatype = null;
            if (ATermUtils.isVar(obj)) {
                if (this.query.getLitVars().contains(obj)) {
                    datatype = this.query.getDatatype(obj);
                }
                if (!ATermUtils.isVar(subj)) {
                    oValues = datatype == null ? this.kb.getObjectPropertyValues(pred, subj) : this.kb.getDataPropertyValues(pred, subj, datatype);
                    alreadySatisfied = true;
                }
            } else {
                oValues = Collections.singletonList(obj);
            }
            for (ATermAppl sValue : sValues) {
                Iterator<Object> j = null;
                if (oValues != null) {
                    j = oValues.iterator();
                } else if (datatype == null) {
                    j = this.kb.getObjectPropertyValues(pred, sValue).iterator();
                    alreadySatisfied = true;
                } else {
                    j = this.kb.getDataPropertyValues(pred, sValue, datatype).iterator();
                    alreadySatisfied = true;
                }
                while (j.hasNext()) {
                    ATermAppl oValue = (ATermAppl)j.next();
                    boolean satisfied = alreadySatisfied || this.isTripleSatisfied(sValue, pred, oValue);
                    if (!satisfied) continue;
                    QueryResultBinding newBinding = (QueryResultBinding)binding.clone();
                    if (ATermUtils.isVar(subj)) {
                        newBinding.setValue(subj, sValue);
                    }
                    if (ATermUtils.isVar(obj)) {
                        newBinding.setValue(obj, oValue);
                    }
                    this.exec(index + 1, newBinding, results);
                }
            }
        } else {
            this.exec(index + 1, binding, results);
        }
    }

    private boolean isQuerySatisfied() {
        log.debug((Object)"Check ground triples");
        boolean querySatisfied = true;
        for (int i = 0; querySatisfied && i < this.patterns.size(); ++i) {
            QueryPattern triple = (QueryPattern)this.patterns.get(i);
            if (!triple.isGround()) continue;
            querySatisfied = this.isTripleSatisfied(triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        return querySatisfied;
    }

    private boolean isTripleSatisfied(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Check triple " + s + " " + (p == null ? "rdf:type" : p.getName()) + " " + o));
        }
        if (ATermUtils.isVar(s) || ATermUtils.isVar(o)) {
            throw new RuntimeException("No value assigned to variables when checking triple in query!");
        }
        boolean tripleSatisfied = p == null ? this.kb.isType(s, o) : this.kb.hasPropertyValue(s, p, o);
        return tripleSatisfied;
    }
}

