/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.utils.ATermUtils;

public class LiteralIterator
implements Iterator {
    QueryResultBinding binding;
    Set litVars;
    ArrayList[] lb;
    int[] indices;
    boolean more = true;

    public LiteralIterator(Query q, QueryResultBinding binding) {
        KnowledgeBase kb = q.getKB();
        this.binding = binding;
        this.litVars = q.getDistLitVars();
        this.lb = new ArrayList[this.litVars.size()];
        this.indices = new int[this.litVars.size()];
        int index = 0;
        for (ATermAppl litVar : this.litVars) {
            Datatype dtype = q.getDatatype(litVar);
            QueryPattern pattern = (QueryPattern)q.findPatterns(null, null, litVar).get(0);
            ATermAppl name = pattern.getSubject();
            if (ATermUtils.isVar(name)) {
                name = binding.getValue(name);
            }
            this.lb[index++] = new ArrayList();
            List<ATermAppl> act = kb.getDataPropertyValues(pattern.getPredicate(), name, dtype);
            if (act.size() > 0) {
                for (ATermAppl lit : act) {
                    this.lb[index].add(lit);
                }
                continue;
            }
            this.more = false;
        }
    }

    public void remove() {
    }

    public boolean hasNext() {
        return this.more;
    }

    public Object next() {
        if (!this.more) {
            return null;
        }
        QueryResultBinding next = (QueryResultBinding)this.binding.clone();
        int index = 0;
        for (ATermAppl o1 : this.litVars) {
            ATermAppl o2 = (ATermAppl)this.lb[index].get(this.indices[index]);
            next.setValue(o1, o2);
            ++index;
        }
        this.more = this.incIndex(0);
        return next;
    }

    private boolean incIndex(int index) {
        if (this.indices[index] + 1 >= this.lb[index].size()) {
            if (index == this.indices.length - 1) {
                return false;
            }
            this.indices[index] = 0;
            return this.incIndex(index + 1);
        }
        int n = index;
        this.indices[n] = this.indices[n] + 1;
        return true;
    }
}

