/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryUtils;
import org.mindswap.pellet.query.impl.QueryPatternImpl;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class QueryImpl
implements Query {
    private KnowledgeBase kb;
    private List patterns;
    private Map types;
    private List resultVars;
    private Set distVars;
    private Set vars;
    private Set objVars;
    private Set litVars;
    private Set constants;
    private QNameProvider qnames;
    private boolean hasUndefinedPredicate;

    public QueryImpl(KnowledgeBase kb) {
        this.kb = kb;
        this.patterns = new ArrayList();
        this.types = new HashMap();
        this.resultVars = new ArrayList();
        this.distVars = new HashSet();
        this.objVars = new HashSet();
        this.litVars = new HashSet();
        this.constants = new HashSet();
        this.qnames = new QNameProvider();
    }

    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public void addDistVar(ATermAppl var) {
        if (!ATermUtils.isVar(var)) {
            return;
        }
        this.distVars.add(var);
    }

    public void addResultVar(ATermAppl var) {
        if (!ATermUtils.isVar(var)) {
            return;
        }
        this.resultVars.add(var);
        this.distVars.add(var);
    }

    private void addTerm(ATermAppl term, boolean isObj) {
        Set set;
        Set set2 = ATermUtils.isVar(term) ? (isObj ? this.objVars : this.litVars) : (set = this.constants);
        if (!set.contains(term)) {
            set.add(term);
        }
    }

    public void addPattern(QueryPattern pattern) {
        this.addPattern(this.patterns.size(), pattern);
    }

    public void addPattern(int index, QueryPattern pattern) {
        ATermAppl subj = pattern.getSubject();
        ATermAppl obj = pattern.getObject();
        this.addTerm(subj, true);
        if (pattern.isTypePattern()) {
            HashSet<ATermAppl> set = (HashSet<ATermAppl>)this.types.get(subj);
            if (set == null) {
                set = new HashSet<ATermAppl>();
                this.types.put(subj, set);
            }
            set.add(obj);
        } else {
            ATermAppl pred = pattern.getPredicate();
            boolean isObj = this.kb == null ? true : this.kb.isObjectProperty(pred);
            this.addTerm(obj, isObj);
        }
        this.patterns.add(index, pattern);
    }

    public void addTypePattern(ATermAppl ind, ATermAppl c) {
        this.addPattern(new QueryPatternImpl(ind, c));
    }

    public void addEdgePattern(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.addPattern(new QueryPatternImpl(s, p, o));
    }

    public void insertEdgePattern(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.addPattern(0, new QueryPatternImpl(s, p, o));
    }

    public void removePattern(QueryPattern pattern) {
        this.patterns.remove(pattern);
        if (pattern.isTypePattern()) {
            ATermAppl subj = pattern.getSubject();
            ATermAppl obj = pattern.getSubject();
            Set set = (Set)this.types.get(subj);
            set.remove(obj);
        }
    }

    public void addConstraint(ATermAppl lit, Datatype dt) {
        this.types.put(lit, dt);
    }

    public Set getVars() {
        if (this.vars == null) {
            this.vars = new HashSet(this.objVars.size() + this.litVars.size());
            this.vars.addAll(this.objVars);
            this.vars.addAll(this.litVars);
        }
        return this.vars;
    }

    public Set getObjVars() {
        return this.objVars;
    }

    public Set getLitVars() {
        return this.litVars;
    }

    public Set getConstants() {
        return this.constants;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public Set getDistVars() {
        return this.distVars;
    }

    public Set getDistObjVars() {
        HashSet distObjVars = new HashSet(this.objVars);
        distObjVars.retainAll(this.distVars);
        return distObjVars;
    }

    public Set getDistLitVars() {
        HashSet distObjVars = new HashSet(this.litVars);
        distObjVars.retainAll(this.distVars);
        return distObjVars;
    }

    public List getQueryPatterns() {
        return this.patterns;
    }

    public ATermAppl rollUpTo(ATermAppl var) {
        if (this.litVars.contains(var)) {
            throw new InternalReasonerException("trying to roll up to a Literal variable.");
        }
        ATermList classParts = ATermUtils.EMPTY_LIST;
        HashSet visited = new HashSet();
        Iterator e = this.getInEdges(var).iterator();
        while (e.hasNext()) {
            classParts = classParts.append(this.rollEdgeIn((QueryPattern)e.next(), visited));
        }
        e = this.getOutEdges(var).iterator();
        while (e.hasNext()) {
            classParts = classParts.append(this.rollEdgeOut((QueryPattern)e.next(), visited));
        }
        classParts = classParts.concat(this.getClasses(var));
        ATermAppl testClass = ATermUtils.makeAnd(classParts);
        return testClass;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Query apply(QueryResultBinding binding) {
        QueryImpl query = new QueryImpl(this.kb);
        int n = this.patterns.size();
        for (int i = 0; i < n; ++i) {
            QueryPattern pattern = (QueryPattern)this.patterns.get(i);
            pattern = pattern.apply(binding);
            query.addPattern(pattern);
        }
        for (ATermAppl var : this.resultVars) {
            if (binding.hasValue(var)) continue;
            query.addResultVar(var);
        }
        for (ATermAppl var : this.distVars) {
            if (binding.hasValue(var)) continue;
            query.addDistVar(var);
        }
        return query;
    }

    public boolean isGround() {
        return this.objVars.isEmpty() && this.litVars.isEmpty();
    }

    private List getInEdges(ATermAppl term) {
        return this.findPatterns(null, null, term);
    }

    private List getOutEdges(ATermAppl term) {
        return this.findPatterns(term, null, null);
    }

    public List findPatterns(ATermAppl subj, ATermAppl pred, ATermAppl obj) {
        ArrayList<QueryPattern> list = new ArrayList<QueryPattern>();
        for (int i = 0; i < this.patterns.size(); ++i) {
            QueryPattern pattern = (QueryPattern)this.patterns.get(i);
            if (pattern.isTypePattern() || subj != null && !subj.equals(pattern.getSubject()) || pred != null && !pred.equals(pattern.getPredicate()) || obj != null && !obj.equals(pattern.getObject())) continue;
            list.add(pattern);
        }
        return list;
    }

    private ATermAppl rollEdgeOut(QueryPattern pattern, Set visited) {
        ATermList outs;
        ATermAppl subj = pattern.getSubject();
        ATermAppl pred = pattern.getPredicate();
        ATermAppl obj = pattern.getObject();
        visited.add(subj);
        if (visited.contains(obj)) {
            ATermList temp = this.getClasses(obj);
            if (temp.getLength() == 0) {
                if (this.kb.isDatatypeProperty(pred)) {
                    return ATermUtils.makeMin((ATerm)pred, 1, (ATerm)ATermUtils.TOP_LIT);
                }
                return ATermUtils.makeMin((ATerm)pred, 1, (ATerm)ATermUtils.TOP);
            }
            return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(temp));
        }
        if (ATermUtils.isLiteral(obj)) {
            ATermAppl type = ATermUtils.makeValue(obj);
            return ATermUtils.makeSomeValues(pred, type);
        }
        if (this.litVars.contains(obj)) {
            Datatype dtype = this.getDatatype(obj);
            return ATermUtils.makeSomeValues(pred, dtype.getName());
        }
        ATermList targetClasses = this.getClasses(obj);
        for (QueryPattern in : this.getInEdges(obj)) {
            if (in.equals(pattern)) continue;
            targetClasses = targetClasses.append(this.rollEdgeIn(in, visited));
        }
        List targetOuts = this.getOutEdges(obj);
        if (targetClasses.isEmpty()) {
            if (targetOuts.size() == 0) {
                if (this.kb.isDatatypeProperty(pred)) {
                    return ATermUtils.makeMin((ATerm)pred, 1, (ATerm)ATermUtils.TOP_LIT);
                }
                return ATermUtils.makeMin((ATerm)pred, 1, (ATerm)ATermUtils.TOP);
            }
            outs = ATermUtils.EMPTY_LIST;
            for (QueryPattern currEdge : targetOuts) {
                outs = outs.append(this.rollEdgeOut(currEdge, visited));
            }
            return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(outs));
        }
        if (targetOuts.size() == 0) {
            return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(targetClasses));
        }
        outs = ATermUtils.EMPTY_LIST;
        for (QueryPattern currEdge : targetOuts) {
            outs = outs.append(this.rollEdgeOut(currEdge, visited));
        }
        for (int i = 0; i < targetClasses.getLength(); ++i) {
            outs = outs.append(targetClasses.elementAt(i));
        }
        return ATermUtils.makeSomeValues(pred, ATermUtils.makeAnd(outs));
    }

    private ATermAppl rollEdgeIn(QueryPattern pattern, Set visited) {
        ATermList ins;
        ATermAppl subj = pattern.getSubject();
        ATermAppl pred = pattern.getPredicate();
        ATermAppl obj = pattern.getObject();
        ATermAppl invPred = this.kb.getRBox().getRole(pred).getInverse().getName();
        visited.add(obj);
        if (visited.contains(subj)) {
            ATermList temp = this.getClasses(subj);
            if (temp.getLength() == 0) {
                if (this.kb.isDatatypeProperty(invPred)) {
                    return ATermUtils.makeMin((ATerm)invPred, 1, (ATerm)ATermUtils.TOP_LIT);
                }
                return ATermUtils.makeMin((ATerm)invPred, 1, (ATerm)ATermUtils.TOP);
            }
            return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(temp));
        }
        ATermList targetClasses = this.getClasses(subj);
        List targetIns = this.getInEdges(subj);
        for (QueryPattern o : this.getOutEdges(subj)) {
            if (o.equals(pattern)) continue;
            targetClasses = targetClasses.append(this.rollEdgeOut(o, visited));
        }
        if (targetClasses.isEmpty()) {
            if (targetIns.isEmpty()) {
                if (this.kb.isDatatypeProperty(pred)) {
                    return ATermUtils.makeMin((ATerm)invPred, 1, (ATerm)ATermUtils.TOP_LIT);
                }
                return ATermUtils.makeMin((ATerm)invPred, 1, (ATerm)ATermUtils.TOP);
            }
            ins = ATermUtils.EMPTY_LIST;
            for (QueryPattern currEdge : targetIns) {
                ins = ins.append(this.rollEdgeIn(currEdge, visited));
            }
            return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(ins));
        }
        if (targetIns.isEmpty()) {
            return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(targetClasses));
        }
        ins = ATermUtils.EMPTY_LIST;
        for (QueryPattern currEdge : targetIns) {
            ins = ins.append(this.rollEdgeIn(currEdge, visited));
        }
        for (int i = 0; i < targetClasses.getLength(); ++i) {
            ins = ins.append(targetClasses.elementAt(i));
        }
        return ATermUtils.makeSomeValues(invPred, ATermUtils.makeAnd(ins));
    }

    public ATermList getClasses(ATermAppl term) {
        ATermList results;
        Set classes = (Set)this.types.get(term);
        ATermList aTermList = results = classes == null ? ATermUtils.EMPTY_LIST : ATermUtils.makeList(classes);
        if (!ATermUtils.isVar(term)) {
            results = results.insert(ATermUtils.makeValue(term));
        }
        return results;
    }

    public Datatype getDatatype(ATermAppl term) {
        Datatype type = (Datatype)this.types.get(term);
        if (type == null) {
            type = RDFSLiteral.instance;
        }
        return type;
    }

    public Query reorder(int[] ordering) {
        if (ordering.length != this.patterns.size()) {
            throw new IllegalArgumentException(ordering.length + " != " + this.patterns.size());
        }
        QueryImpl newQuery = new QueryImpl(this.kb);
        for (int j = 0; j < ordering.length; ++j) {
            newQuery.addPattern((QueryPattern)this.patterns.get(ordering[j]));
        }
        for (ATermAppl var : this.resultVars) {
            newQuery.addResultVar(var);
        }
        for (ATermAppl var : this.distVars) {
            newQuery.addDistVar(var);
        }
        return newQuery;
    }

    public void prepare() {
    }

    public void printName(ATermAppl term, StringBuffer sb) {
        if (ATermUtils.isVar(term)) {
            sb.append("?").append(((ATermAppl)term.getArgument(0)).getName());
        } else {
            sb.append(this.qnames.shortForm(term.getName()));
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean multiLine) {
        int i;
        QNameProvider qnames = new QNameProvider();
        String indent = multiLine ? "     " : " ";
        StringBuffer sb = new StringBuffer();
        sb.append("query(");
        for (i = 0; i < this.resultVars.size(); ++i) {
            ATermAppl var = (ATermAppl)this.resultVars.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("?").append(QueryUtils.getVarName(var));
        }
        sb.append(")");
        if (this.patterns.size() > 0) {
            sb.append(" :-");
            if (multiLine) {
                sb.append("\n");
            }
            for (i = 0; i < this.patterns.size(); ++i) {
                QueryPattern p = (QueryPattern)this.patterns.get(i);
                if (i > 0) {
                    sb.append(",");
                    if (multiLine) {
                        sb.append("\n");
                    }
                }
                sb.append(indent);
                if (p.isTypePattern()) {
                    sb.append(QueryUtils.formatTerm(p.getObject(), qnames));
                    sb.append("(");
                    sb.append(QueryUtils.formatTerm(p.getSubject(), qnames));
                    sb.append(")");
                    continue;
                }
                sb.append(QueryUtils.formatTerm(p.getPredicate(), qnames));
                sb.append("(");
                sb.append(QueryUtils.formatTerm(p.getSubject(), qnames));
                sb.append(", ");
                sb.append(QueryUtils.formatTerm(p.getObject(), qnames));
                sb.append(")");
            }
        }
        sb.append(".");
        if (multiLine) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean hasUndefinedPredicate() {
        return this.hasUndefinedPredicate;
    }

    public void setHasUndefinedPredicate(boolean hasUndefinedPredicate) {
        this.hasUndefinedPredicate = hasUndefinedPredicate;
    }
}

