/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.HashCodeUtil;

public class QueryPatternImpl
implements QueryPattern {
    private ATermAppl s;
    private ATermAppl p;
    private ATermAppl o;
    private int hashCode;

    public QueryPatternImpl(ATermAppl ind, ATermAppl c) {
        if (ATermUtils.isVar(c)) {
            throw new UnsupportedFeatureException();
        }
        this.s = ind;
        this.o = c;
        this.computeHashCode();
    }

    public QueryPatternImpl(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (ATermUtils.isVar(p)) {
            throw new UnsupportedFeatureException();
        }
        this.s = s;
        this.p = p;
        this.o = o;
        this.computeHashCode();
    }

    public boolean isTypePattern() {
        return this.p == null;
    }

    public boolean isEdgePattern() {
        return this.p != null;
    }

    public boolean isGround() {
        return !ATermUtils.isVar(this.s) && !ATermUtils.isVar(this.o);
    }

    public ATermAppl getSubject() {
        return this.s;
    }

    public ATermAppl getPredicate() {
        return this.p;
    }

    public ATermAppl getObject() {
        return this.o;
    }

    public QueryPattern apply(QueryResultBinding binding) {
        ATermAppl obj;
        ATermAppl subj = binding.hasValue(this.s) ? binding.getValue(this.s) : this.s;
        ATermAppl aTermAppl = obj = binding.hasValue(this.o) ? binding.getValue(this.o) : this.o;
        if (this.p == null) {
            return new QueryPatternImpl(subj, obj);
        }
        return new QueryPatternImpl(subj, this.p, obj);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueryPatternImpl)) {
            return false;
        }
        QueryPatternImpl that = (QueryPatternImpl)other;
        return this.s.equals(that.s) && this.o.equals(that.o) && (this.p == null && that.p == null || this.p != null && that.p != null && this.p.equals(that.p));
    }

    private void computeHashCode() {
        this.hashCode = 23;
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.s);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.p);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.o);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.p == null) {
            return "(" + this.s + " rdf:type " + this.o + ")";
        }
        return "(" + this.s + " " + this.p + " " + this.o + ")";
    }
}

