/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules.builtins;

import java.util.HashMap;
import java.util.Map;
import org.mindswap.pellet.rules.builtins.BuiltIn;
import org.mindswap.pellet.rules.builtins.NoSuchBuiltIn;
import org.mindswap.pellet.rules.builtins.TestBuiltIn;
import org.mindswap.pellet.rules.builtins.TestComparison;
import org.mindswap.pellet.rules.builtins.TestEqual;
import org.mindswap.pellet.rules.builtins.TestNotEqual;

public class BuiltInRegistry {
    private Map<String, BuiltIn> builtIns = new HashMap<String, BuiltIn>();
    public static final BuiltInRegistry instance = new BuiltInRegistry();

    private BuiltInRegistry() {
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#equal", new TestBuiltIn(TestEqual.instance));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#notEqual", new TestBuiltIn(TestNotEqual.instance));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThan", new TestBuiltIn(TestComparison.lessThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThanOrEqual", new TestBuiltIn(TestComparison.lessThanOrEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThan", new TestBuiltIn(TestComparison.greaterThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThanOrEqual", new TestBuiltIn(TestComparison.greaterThanOrEqual));
    }

    public BuiltIn getBuiltIn(String name) {
        BuiltIn builtIn = this.builtIns.get(name);
        if (builtIn == null) {
            builtIn = NoSuchBuiltIn.instance;
        }
        return builtIn;
    }

    public void registerBuiltIn(String name, BuiltIn builtIn) {
        this.builtIns.put(name, builtIn);
    }
}

