/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyNode {
    private ATermAppl name;
    private boolean hidden;
    protected Boolean mark;
    private Set<ATermAppl> equivalents;
    private List<TaxonomyNode> supers;
    private List<TaxonomyNode> subs;
    private Map<TaxonomyNode, Set<Set<ATermAppl>>> superExplanations;
    private Set<ATermAppl> instances;

    public TaxonomyNode(ATermAppl name, boolean hidden) {
        this.name = name;
        this.hidden = hidden;
        this.equivalents = Collections.singleton(name);
        this.supers = new ArrayList<TaxonomyNode>(2);
        this.subs = new ArrayList<TaxonomyNode>();
    }

    public boolean isTop() {
        return this.supers.isEmpty();
    }

    public boolean isBottom() {
        return this.subs.isEmpty();
    }

    public boolean isLeaf() {
        return this.subs.size() == 1 && this.subs.get(0).isBottom();
    }

    public static List removeRepeatedElements(List l) {
        ArrayList<TaxonomyNode> result = new ArrayList<TaxonomyNode>();
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            TaxonomyNode aux1 = (TaxonomyNode)l.get(i);
            ATermAppl name1 = aux1.getName();
            int n2 = result.size();
            boolean b = false;
            if (result.isEmpty()) {
                result.add(aux1);
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                TaxonomyNode aux2 = (TaxonomyNode)result.get(j);
                ATermAppl name2 = aux2.getName();
                if (!name2.equals(name1)) continue;
                b = true;
            }
            if (b) continue;
            result.add(aux1);
        }
        return result;
    }

    public static List removeFromNodeList(List l, ATermAppl t) {
        ArrayList<TaxonomyNode> result = new ArrayList<TaxonomyNode>();
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            TaxonomyNode aux1 = (TaxonomyNode)l.get(i);
            if (aux1.getName().equals(t)) continue;
            result.add(aux1);
        }
        return result;
    }

    public boolean compareTo(TaxonomyNode node) {
        if (node.getName().equals(ATermUtils.TOP) || node.getName().equals(ATermUtils.BOTTOM)) {
            return true;
        }
        if (this.getName().equals(ATermUtils.TOP) || this.getName().equals(ATermUtils.BOTTOM)) {
            return true;
        }
        List supers1 = this.getSupers();
        List supers2 = node.getSupers();
        supers1 = TaxonomyNode.removeFromNodeList(supers1, ATermUtils.TOP);
        supers2 = TaxonomyNode.removeFromNodeList(supers2, ATermUtils.TOP);
        supers1 = TaxonomyNode.removeRepeatedElements(supers1);
        supers2 = TaxonomyNode.removeRepeatedElements(supers2);
        List subs1 = this.getSubs();
        List subs2 = node.getSubs();
        subs1 = TaxonomyNode.removeFromNodeList(subs1, ATermUtils.BOTTOM);
        subs2 = TaxonomyNode.removeFromNodeList(subs2, ATermUtils.BOTTOM);
        subs1 = TaxonomyNode.removeRepeatedElements(subs1);
        subs2 = TaxonomyNode.removeRepeatedElements(subs2);
        if (!((Object)this.equivalents).equals(node.equivalents)) {
            System.out.println("The class: " + this.getName() + " has different equivalent classes");
            return false;
        }
        if (!this.compareLists(supers1, supers2)) {
            System.out.println("The class: " + this.getName() + " has different super-classes");
            return false;
        }
        if (!this.compareLists(subs1, subs2)) {
            System.out.println("The class: " + this.getName() + " has different sub-classes");
            return false;
        }
        return true;
    }

    public boolean compareLists(List l1, List l2) {
        int size1 = l1.size();
        int size2 = l2.size();
        HashSet<ATermAppl> toSet1 = new HashSet<ATermAppl>();
        HashSet<ATermAppl> toSet2 = new HashSet<ATermAppl>();
        if (size1 != size2) {
            return false;
        }
        int n = l1.size();
        for (int i = 0; i < n; ++i) {
            TaxonomyNode aux1 = (TaxonomyNode)l1.get(i);
            ATermAppl name1 = aux1.getName();
            toSet1.add(name1);
        }
        int m = l2.size();
        for (int j = 0; j < m; ++j) {
            TaxonomyNode aux2 = (TaxonomyNode)l2.get(j);
            ATermAppl name2 = aux2.getName();
            toSet2.add(name2);
        }
        return toSet1.containsAll(toSet2);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean contains(ATermAppl c) {
        return this.equivalents.contains(c);
    }

    public void addEquivalent(ATermAppl c) {
        if (this.equivalents.size() == 1) {
            this.equivalents = new HashSet<ATermAppl>(this.equivalents);
        }
        this.equivalents.add(c);
    }

    public void addSub(TaxonomyNode other) {
        if (this.equals(other) || this.subs.contains(other)) {
            return;
        }
        this.subs.add(other);
        if (!this.hidden) {
            other.supers.add(this);
        }
    }

    public void addSubs(Collection others) {
        this.subs.addAll(others);
        if (!this.hidden) {
            for (TaxonomyNode other : others) {
                other.supers.add(this);
            }
        }
    }

    public void addSupers(Collection others) {
        this.supers.addAll(others);
        if (!this.hidden) {
            for (TaxonomyNode other : others) {
                other.subs.add(this);
            }
        }
    }

    public void removeSub(TaxonomyNode other) {
        this.subs.remove(other);
        other.supers.remove(this);
        if (other.superExplanations != null) {
            other.superExplanations.remove(this);
        }
    }

    public void disconnect() {
        Iterator<TaxonomyNode> j = this.subs.iterator();
        while (j.hasNext()) {
            TaxonomyNode sub = j.next();
            j.remove();
            sub.supers.remove(this);
        }
        j = this.supers.iterator();
        while (j.hasNext()) {
            TaxonomyNode sup = j.next();
            j.remove();
            sup.subs.remove(this);
        }
    }

    public void addInstance(ATermAppl ind) {
        if (this.instances == null) {
            this.instances = new HashSet<ATermAppl>();
        }
        this.instances.add(ind);
    }

    public void addSuperExplanation(TaxonomyNode sup, Set<ATermAppl> exp) {
        Set<Set<ATermAppl>> exps;
        if (this.superExplanations == null) {
            this.superExplanations = new HashMap<TaxonomyNode, Set<Set<ATermAppl>>>();
            exps = null;
        } else {
            exps = this.superExplanations.get(sup);
        }
        if (exps == null) {
            exps = new HashSet<Set<ATermAppl>>();
        }
        exps.add(exp);
        this.superExplanations.put(sup, exps);
    }

    public void setInstances(Set instances) {
        this.instances = instances;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public Set<ATermAppl> getEquivalents() {
        return this.equivalents;
    }

    public Set<ATermAppl> getInstances() {
        if (this.instances == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.instances);
    }

    public Set<Set<ATermAppl>> getSuperExplanations(TaxonomyNode sup) {
        return this.superExplanations == null ? null : this.superExplanations.get(sup);
    }

    public List<TaxonomyNode> getSubs() {
        return this.subs;
    }

    public List<TaxonomyNode> getSupers() {
        return this.supers;
    }

    public void setSubs(List<TaxonomyNode> subs) {
        this.subs = subs;
    }

    public void setSupers(List<TaxonomyNode> supers) {
        this.supers = supers;
    }

    public void removeMultiplePaths() {
        if (!this.hidden) {
            for (TaxonomyNode sup : this.supers) {
                for (TaxonomyNode sub : this.subs) {
                    sup.removeSub(sub);
                }
            }
        }
    }

    public void print() {
        this.print("");
    }

    public void print(String indent) {
        if (this.subs.isEmpty()) {
            return;
        }
        System.out.print(indent);
        System.out.println(this.equivalents + "(" + this.hashCode() + ")");
        indent = indent + "  ";
        for (TaxonomyNode sub : this.subs) {
            sub.print(indent);
        }
    }

    public String toString() {
        return this.name.getName();
    }

    protected TaxonomyNode copy(Map conversion) {
        TaxonomyNode newnode = new TaxonomyNode(this.name, this.hidden);
        return this.copy(newnode, conversion);
    }

    protected TaxonomyNode copy(TaxonomyNode newnode, Map conversion) {
        newnode.equivalents = this.equivalents != null ? new HashSet<ATermAppl>(this.equivalents) : null;
        newnode.instances = this.instances != null ? new HashSet<ATermAppl>(this.instances) : null;
        newnode.supers = this.copySet(this.supers, conversion);
        newnode.subs = this.copySet(this.subs, conversion);
        return newnode;
    }

    private List copySet(List set, Map conversion) {
        if (set == null) {
            return null;
        }
        Iterator i = set.iterator();
        LinkedList newset = new LinkedList();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            if (!conversion.containsKey(node)) {
                conversion.put(node, new TaxonomyNode(node.name, node.hidden));
            }
            newset.add(conversion.get(node));
        }
        return newset;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

