/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.WebOntTester;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.PhysicalURIInputSource;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class OWLAPIWebOntTester
implements WebOntTester {
    OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    Reasoner reasoner;

    public void classify() {
        this.reasoner.getKB().realize();
    }

    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    public boolean isEntailed(String entailmentFileURI) {
        try {
            OWLOntology ont = this.manager.loadOntology(this.getInputSource(entailmentFileURI));
            return this.reasoner.isEntailed(ont);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInputOntology(String inputFileURI) {
        try {
            OWLOntology ont = this.manager.loadOntology(this.getInputSource(inputFileURI));
            this.reasoner = new Reasoner(this.manager);
            this.reasoner.setOntology(ont);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTimeout(long timeout) {
        this.reasoner.getKB().setTimeout(timeout);
    }

    private OWLOntologyInputSource getInputSource(String fileURI) {
        if (fileURI.endsWith(".n3")) {
            return this.convertN3(fileURI);
        }
        return new PhysicalURIInputSource(URI.create(fileURI));
    }

    private OWLOntologyInputSource convertN3(String fileURI) {
        StringWriter ontologySrc = new StringWriter();
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        model.read(fileURI, fileURI, "N3");
        model.write((Writer)ontologySrc, "RDF/XML");
        return new StringInputSource(ontologySrc.toString());
    }
}

