/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import org.mindswap.pellet.jena.PelletQueryExecution;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.PelletTestCase;

public class QueryTests
extends PelletTestCase {
    public void testFoodQuery() {
        String ns = "http://www.w3.org/2001/sw/WebOnt/guide-src/";
        String food = ns + "food";
        String wine = ns + "wine";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(food + ".owl");
        Resource RedMeatCourse = model.getResource(food + "#RedMeatCourse");
        Resource PastaWithLightCreamCourse = model.getResource(food + "#PastaWithLightCreamCourse");
        Individual MyLunch = model.createIndividual(food + "#MyLunch", PastaWithLightCreamCourse);
        Individual MyDinner = model.createIndividual(food + "#MyDinner", RedMeatCourse);
        Individual White = model.getIndividual(food + "#White");
        Individual Red = model.getIndividual(food + "#Red");
        OntProperty hasColor = model.getOntProperty(wine + "#hasColor");
        hasColor.convertToFunctionalProperty();
        model.prepare();
        String queryBegin = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX food: <" + food + "#>\r\n" + "PREFIX wine: <" + wine + "#>\r\n" + "\r\n" + "SELECT ?Meal ?WineColor\r\n" + "WHERE {\r\n";
        String queryEnd = "}";
        String queryStr1 = queryBegin + "   ?Meal rdf:type food:MealCourse .\r\n" + "   ?Meal food:hasDrink ?Wine .\r\n" + "   ?Wine wine:hasColor ?WineColor" + queryEnd;
        String queryStr2 = queryBegin + "   ?Meal rdf:type food:MealCourse .\r\n" + "   ?Meal food:hasDrink _:Wine .\r\n" + "   _:Wine wine:hasColor ?WineColor" + queryEnd;
        Query query1 = QueryFactory.create((String)queryStr1);
        Query query2 = QueryFactory.create((String)queryStr2);
        ResultSet results1 = new PelletQueryExecution(query1, (Model)model).execSelect();
        QueryTests.assertTrue((!results1.hasNext() ? 1 : 0) != 0);
        ResultSet results2 = new PelletQueryExecution(query2, (Model)model).execSelect();
        this.testResultSet(results2, this.createBindings(new String[]{"Meal", "WineColor"}, new Resource[][]{{MyLunch, White}, {MyDinner, Red}}));
    }

    public void testOedipusQuery() {
        String ns = "http://www.mindswap.org/ontologies/oedipus#";
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX ns:  <http://www.mindswap.org/ontologies/oedipus#>\n\nSELECT ?x\nFROM <http://www.mindswap.org/ontologies/oedipus>\nWHERE { ?x ns:hasChild \n          [ rdf:type ns:Patricide;\n            ns:hasChild \n              [ rdf:type ns:NotPatricide ] \n          ] \n      } ";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ns);
        model.prepare();
        Query query = QueryFactory.create((String)queryStr);
        ResultSet results = new PelletQueryExecution(query, (Model)model).execSelect();
        this.testResultSet(results, this.createBindings(new String[]{"x"}, new Resource[][]{{model.getResource(ns + "IOKASTE")}}));
    }

    public void testFoodConstructQuery() {
        String ns = "http://www.w3.org/2001/sw/WebOnt/guide-src/";
        String food = ns + "food";
        String wine = ns + "wine";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(food + ".owl");
        Resource RedMeatCourse = model.getResource(food + "#RedMeatCourse");
        Resource PastaWithLightCreamCourse = model.getResource(food + "#PastaWithLightCreamCourse");
        Individual MyLunch = model.createIndividual(food + "#MyLunch", PastaWithLightCreamCourse);
        Individual MyDinner = model.createIndividual(food + "#MyDinner", RedMeatCourse);
        Individual White = model.getIndividual(food + "#White");
        Individual Red = model.getIndividual(food + "#Red");
        OntProperty hasColor = model.getOntProperty(wine + "#hasColor");
        hasColor.convertToFunctionalProperty();
        OntProperty preferredWineColor = model.getOntProperty(wine + "#preferredWineColor");
        model.prepare();
        String queryStr = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX food: <" + food + "#>\r\n" + "PREFIX wine: <" + wine + "#>\r\n" + "\r\n" + "CONSTRUCT {" + "   ?Meal wine:preferredWineColor ?WineColor\r\n" + "}" + "WHERE {\r\n" + "   ?Meal rdf:type food:MealCourse .\r\n" + "   ?Meal food:hasDrink _:Wine .\r\n" + "   _:Wine wine:hasColor ?WineColor" + "}";
        Query query = QueryFactory.create((String)queryStr);
        Model results = new PelletQueryExecution(query, (Model)model).execConstruct();
        QueryTests.assertTrue((results.size() == 2L ? 1 : 0) != 0);
        QueryTests.assertTrue((boolean)results.contains((Resource)MyLunch, (Property)preferredWineColor, (RDFNode)White));
        QueryTests.assertTrue((boolean)results.contains((Resource)MyDinner, (Property)preferredWineColor, (RDFNode)Red));
    }

    public void testLiteralLanguage() {
        String ns = "http://example.org/";
        String lang = "en";
        String literal = "lex";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        Individual s = model.createIndividual("http://example.org/s1", OWL.Thing);
        DatatypeProperty p = model.createDatatypeProperty("http://example.org/p");
        Literal o = model.createLiteral("lex", "en");
        model.add((Resource)s, (Property)p, (RDFNode)o);
        model.prepare();
        String queryStr = "PREFIX ns: <http://example.org/>\r\nSELECT ?ind WHERE { ?ind ns:p \"lex\"@en }";
        Query query = QueryFactory.create((String)queryStr);
        ResultSet results = new PelletQueryExecution(query, (Model)model).execSelect();
        this.testResultSet(results, this.createBindings(new String[]{"ind"}, new Resource[][]{{s}}));
    }
}

