/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class IncConsistencyDeletionUnitTest {
    static double ITERS = 50.0;
    static boolean USE_REG_REASONER = true;
    static String[] DEFAULT_FILES = new String[]{"RISKY", "http://www.mindswap.org/~chris/owl/Certus.owl", "LUBM", "http://www.mindswap.org/~chris/tmp/University0.owl", "OUBM", "http://www.mindswap.org/~chris/tmp/univ-bench-lite-3dept.owl", "Mindswappers", "http://www.mindswap.org/2004/owl/mindswappers"};

    public static void main(String[] args) throws Exception {
        String[] files = DEFAULT_FILES;
        boolean formatHTML = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-html")) {
                formatHTML = true;
                continue;
            }
            System.err.println("Unknown option " + args[i]);
        }
        for (int k = 0; k < 1; ++k) {
            List<String> cols = Arrays.asList("Name", "OWL Species", "DL Expressivity", "Triples", "Classes", "Properties", "Individuals", "Loading", "Initial Consistency", "Avg. Reg. Consistency", "Avg. Inc Consistency", "Total");
            TableData table = new TableData(cols);
            for (int i = 0; i < files.length; i += 2) {
                try {
                    String name = files[i];
                    String file = files[i + 1];
                    System.out.println("\nStarting test: " + file);
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (formatHTML) {
                        list.add("<a href=\"" + file + "\">" + name + "</a>");
                    } else {
                        list.add(name);
                    }
                    System.gc();
                    System.gc();
                    System.gc();
                    ModelReader reader = new ModelReader();
                    Model model = reader.read(file);
                    Timer t = new Timer("timer");
                    PelletOptions.USE_TRACING = false;
                    PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                    PelletOptions.USE_COMPLETION_QUEUE = true;
                    System.out.println("  Loading reasoner");
                    OWLReasoner reasoner = new OWLReasoner();
                    t.start();
                    reasoner.load(model);
                    PelletOptions.USE_TRACING = false;
                    PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                    PelletOptions.USE_COMPLETION_QUEUE = true;
                    if (USE_REG_REASONER) {
                        reasoner.isConsistent();
                    }
                    t.stop();
                    long iCons = reasoner.getKB().timers.getTimer("consistency").getTotal();
                    reasoner.getKB().timers.getTimer("consistency").reset();
                    System.out.println("Regular reasoner initial consistency test: " + iCons);
                    PelletOptions.USE_TRACING = true;
                    PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                    PelletOptions.USE_COMPLETION_QUEUE = true;
                    System.out.println("  Loading incremental reasoner");
                    reader = new ModelReader();
                    Model incModel = reader.read(file);
                    OWLReasoner incReasoner = new OWLReasoner();
                    incReasoner.load(incModel);
                    incReasoner.isConsistent();
                    long incICons = incReasoner.getKB().timers.getTimer("consistency").getTotal();
                    incReasoner.getKB().timers.getTimer("consistency").reset();
                    System.out.println("Incremental reasoner initial consistency test: " + incICons);
                    boolean err = false;
                    long total = 0L;
                    long largest = 0L;
                    long incTotal = 0L;
                    long incLargest = 0L;
                    boolean isIncCon = true;
                    boolean isCon = true;
                    Object ind1 = null;
                    Object ind2 = null;
                    Object clazz = null;
                    Object prop = null;
                    System.out.println("  Starting test...");
                    int j = 0;
                    while ((double)j < ITERS) {
                        Random rand = new Random(System.currentTimeMillis());
                        boolean type = rand.nextBoolean();
                        int index = rand.nextInt(incReasoner.getKB().getSyntacticAssertions().size());
                        ATermAppl assertion = null;
                        int counter = 1;
                        for (ATermAppl next : incReasoner.getKB().getSyntacticAssertions()) {
                            if (counter == index) {
                                assertion = next;
                                break;
                            }
                            ++counter;
                        }
                        if (ATermUtils.isTypeAssertion(assertion) || ATermUtils.isPropertyAssertion(assertion)) {
                            long incCons;
                            long cons;
                            System.out.println("Abox prior to deletion: \n");
                            incReasoner.getKB().getABox().printTree();
                            if (ATermUtils.isTypeAssertion(assertion)) {
                                System.out.println(" Remove type " + assertion.getArgument(1) + " from node: " + assertion.getArgument(0));
                                System.out.println("   Ind existing types " + incReasoner.getKB().getABox().getIndividual(assertion.getArgument(0)).getTypes());
                                System.out.println("Reg test");
                                reasoner.getKB().timers.getTimer("consistency").reset();
                                reasoner.getKB().removeType((ATermAppl)assertion.getArgument(0), (ATermAppl)assertion.getArgument(1));
                                PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                                PelletOptions.USE_TRACING = false;
                                if (USE_REG_REASONER) {
                                    isCon = reasoner.isConsistent();
                                }
                                if ((cons = reasoner.getKB().timers.getTimer("consistency").getTotal()) > largest) {
                                    largest = cons;
                                }
                                total += cons;
                                System.out.println("Reg: " + cons);
                                System.out.println("Inc. test");
                                incReasoner.getKB().timers.getTimer("consistency").reset();
                                PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                                PelletOptions.USE_TRACING = true;
                                incReasoner.getKB().removeType((ATermAppl)assertion.getArgument(0), (ATermAppl)assertion.getArgument(1));
                                isIncCon = incReasoner.isConsistent();
                                incCons = incReasoner.getKB().timers.getTimer("consistency").getTotal();
                                if (incCons > incLargest) {
                                    incLargest = incCons;
                                }
                                incTotal += incCons;
                                System.out.println("  Inc: " + incCons);
                                if (isCon != isIncCon && USE_REG_REASONER) {
                                    System.out.println("Normal consistency check: " + isCon + "   Inc. consistency check: " + isIncCon);
                                    break;
                                }
                            } else {
                                System.out.println(" Removing role " + assertion.getArgument(0) + " from nodes: " + assertion.getArgument(1) + ", " + assertion.getArgument(2));
                                System.out.println("   Subject existing types " + incReasoner.getKB().getABox().getIndividual(assertion.getArgument(1)).getTypes());
                                System.out.println("   Object existing types " + incReasoner.getKB().getABox().getNode(assertion.getArgument(2)));
                                System.out.println("Reg test");
                                PelletOptions.USE_INCREMENTAL_CONSISTENCY = false;
                                PelletOptions.USE_TRACING = false;
                                reasoner.getKB().timers.getTimer("consistency").reset();
                                reasoner.getKB().removePropertyValue((ATermAppl)assertion.getArgument(0), (ATermAppl)assertion.getArgument(1), (ATermAppl)assertion.getArgument(2));
                                if (USE_REG_REASONER) {
                                    isCon = reasoner.isConsistent();
                                }
                                if ((cons = reasoner.getKB().timers.getTimer("consistency").getTotal()) > largest) {
                                    largest = cons;
                                }
                                total += cons;
                                System.out.println("RegR: " + cons);
                                System.out.println("Inc. test");
                                incReasoner.getKB().timers.getTimer("consistency").reset();
                                PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                                PelletOptions.USE_TRACING = true;
                                incReasoner.getKB().removePropertyValue((ATermAppl)assertion.getArgument(0), (ATermAppl)assertion.getArgument(1), (ATermAppl)assertion.getArgument(2));
                                isIncCon = incReasoner.isConsistent();
                                incCons = incReasoner.getKB().timers.getTimer("consistency").getTotal();
                                if (incCons > incLargest) {
                                    incLargest = incCons;
                                }
                                incTotal += incCons;
                                System.out.println("  IncR: " + incCons);
                                if (isCon != isIncCon && USE_REG_REASONER) {
                                    System.out.println("Normal consistency check: " + isCon + "   Inc. consistency check: " + isIncCon);
                                    break;
                                }
                            }
                            System.out.println("Abox after deletion: \n");
                            incReasoner.getKB().getABox().getPseudoModel().printTree();
                            System.out.print(".");
                        }
                        ++j;
                    }
                    double avg = (double)total / ITERS;
                    double incAvg = (double)incTotal / ITERS;
                    list.add(reasoner.getSpecies().toString());
                    list.add(reasoner.getKB().getExpressivity());
                    list.add(new Long(model.size()));
                    KnowledgeBase kb = reasoner.getKB();
                    list.add(new Long(kb.getClasses().size()));
                    list.add(new Long(kb.getProperties().size()));
                    list.add(new Long(kb.getIndividuals().size()));
                    t.start();
                    t.stop();
                    Timers timers = reasoner.getKB().timers;
                    list.add(new Double((double)(timers.getTimer("Loading").getTotal() + timers.getTimer("preprocessing").getTotal()) / 1000.0));
                    list.add(new Double((double)iCons / 1000.0));
                    list.add(new Double(avg / 1000.0));
                    list.add(new Double(incAvg / 1000.0));
                    list.add(new Double((double)t.getTotal() / 1000.0));
                    table.add(list);
                    System.out.println();
                    table.print(System.out, formatHTML);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            System.out.println();
            table.print(System.out, formatHTML);
        }
    }

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }
}

