/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATerm;
import aterm.ATermAppl;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class IncConsistencyTests
extends PelletTestCase {
    private KnowledgeBase kb;
    private boolean preUCQ;
    private boolean preUIC;
    private boolean preUSR;
    private static final boolean PRINT_ABOX = false;
    private ATermAppl robert = ATermUtils.makeTermAppl("Robert");
    private ATermAppl mary = ATermUtils.makeTermAppl("Mary");
    private ATermAppl chris = ATermUtils.makeTermAppl("Chris");
    private ATermAppl john = ATermUtils.makeTermAppl("John");
    private ATermAppl bill = ATermUtils.makeTermAppl("Bill");
    private ATermAppl victor = ATermUtils.makeTermAppl("Victor");
    private ATermAppl mbox = ATermUtils.makeTermAppl("mbox");
    private ATermAppl relative = ATermUtils.makeTermAppl("relative");
    private ATermAppl sibling = ATermUtils.makeTermAppl("sibling");
    private ATermAppl person = ATermUtils.makeTermAppl("person");
    private ATermAppl animalOwner = ATermUtils.makeTermAppl("animalOwner");
    private ATermAppl owns = ATermUtils.makeTermAppl("owns");
    private ATermAppl ownedBy = ATermUtils.makeTermAppl("ownedBy");
    private ATermAppl knows = ATermUtils.makeTermAppl("knows");
    private ATermAppl notPerson = ATermUtils.makeNot(this.person);
    private ATermAppl man = ATermUtils.makeTermAppl("man");
    private ATermAppl woman = ATermUtils.makeTermAppl("woman");
    private ATermAppl animal = ATermUtils.makeTermAppl("animal");
    private ATermAppl dog = ATermUtils.makeTermAppl("dog");
    private ATermAppl cat = ATermUtils.makeTermAppl("cat");
    private ATermAppl notCat = ATermUtils.makeNot(this.cat);
    private ATermAppl notDog = ATermUtils.makeNot(this.dog);
    private ATermAppl ssn = ATermUtils.makeTermAppl("ssn");
    private ATermAppl ownsAnimal = ATermUtils.makeTermAppl("ownsAnimal");

    public void setUp() {
        this.preUCQ = PelletOptions.USE_COMPLETION_QUEUE;
        this.preUIC = PelletOptions.USE_INCREMENTAL_CONSISTENCY;
        this.preUSR = PelletOptions.USE_SMART_RESTORE;
        PelletOptions.USE_COMPLETION_QUEUE = true;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
        PelletOptions.USE_SMART_RESTORE = false;
    }

    protected void tearDown() throws Exception {
        PelletOptions.USE_COMPLETION_QUEUE = this.preUCQ;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = this.preUIC;
        PelletOptions.USE_SMART_RESTORE = this.preUSR;
    }

    public void testDisjunction() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.notPerson);
        this.kb.addDisjointClass(this.person, this.notPerson);
        this.kb.addClass(this.animalOwner);
        this.kb.addClass(this.animal);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.notDog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.notCat);
        this.kb.addDisjointClass(this.cat, this.notCat);
        this.kb.addDisjointClass(this.dog, this.notDog);
        this.kb.addDisjointClass(this.dog, this.cat);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addDomain(this.sibling, this.person);
        this.kb.addDatatypeProperty(this.ssn);
        this.kb.addObjectProperty(this.mbox);
        this.kb.addObjectProperty(this.ownsAnimal);
        this.kb.addDomain(this.ownsAnimal, this.person);
        this.kb.addRange(this.ownsAnimal, this.animal);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral("012345678");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        ATermAppl catOrDog = ATermUtils.makeOr(this.dog, this.cat);
        this.kb.addSubClass(this.animal, catOrDog);
        ATermAppl ownsSomeAnimal = ATermUtils.makeSomeValues(this.ownsAnimal, this.animal);
        this.kb.addClass(ownsSomeAnimal);
        this.kb.addSubClass(this.animalOwner, ownsSomeAnimal);
        ATermAppl ownsNoCats = ATermUtils.makeAllValues(this.ownsAnimal, this.notCat);
        ATermAppl ownsNoDogs = ATermUtils.makeAllValues(this.ownsAnimal, this.notDog);
        this.kb.addType(this.robert, ownsSomeAnimal);
        this.kb.addType(this.mary, ownsSomeAnimal);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, ownsNoCats);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoCats);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.mary, ownsNoCats);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.mary, ownsNoDogs);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testDisjunction2() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        this.kb.addObjectProperty(this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty(this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        ATermAppl ownsDog = ATermUtils.makeSomeValues(this.owns, this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl owersAreDogs = ATermUtils.makeAllValues(this.ownedBy, this.dog);
        this.kb.addClass(owersAreDogs);
        this.kb.addSubClass(this.dog, owersAreDogs);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.robert, manOrDog);
        this.kb.addType(this.robert, ATermUtils.makeNot(this.dog));
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, ATermUtils.makeNot(this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasType(this.dog));
    }

    public void testUC() {
        boolean preRoleA = PelletOptions.USE_ROLE_ABSORPTION;
        boolean preAb = PelletOptions.USE_ABSORPTION;
        PelletOptions.USE_ROLE_ABSORPTION = false;
        PelletOptions.USE_ABSORPTION = false;
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.knows);
        ATermAppl onlyKnowsPeople = ATermUtils.makeAllValues(this.knows, this.person);
        this.kb.addClass(onlyKnowsPeople);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addDisjointClass(this.man, this.woman);
        ATermAppl notDog = ATermUtils.makeNot(this.dog);
        this.kb.addClass(notDog);
        ATermAppl personAndNotDog = ATermUtils.makeAnd(this.person, notDog);
        this.kb.addClass(personAndNotDog);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addSubClass(manOrWoman, personAndNotDog);
        this.kb.addIndividual(this.robert);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual(this.mary).getTypes(1).isEmpty() ? 1 : 0) != 0);
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual(this.robert).getTypes(1).isEmpty() ? 1 : 0) != 0);
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getIndividual(this.victor).getTypes(1).isEmpty() ? 1 : 0) != 0);
        PelletOptions.USE_ROLE_ABSORPTION = preRoleA;
        PelletOptions.USE_ABSORPTION = preAb;
    }

    public void testMax() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        this.kb.addObjectProperty(this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty(this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.chris);
        this.kb.addPropertyValue(this.sibling, this.bill, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.chris);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.john);
        ATermAppl twoSiblings = ATermUtils.makeMax((ATerm)this.sibling, 2, (ATerm)this.person);
        this.kb.addClass(twoSiblings);
        ATermAppl manOrDog = ATermUtils.makeOr(twoSiblings, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.robert, manOrDog);
        this.kb.addType(this.bill, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addDifferent(this.chris, this.victor);
        this.kb.addDifferent(this.chris, this.mary);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.bill, ATermUtils.makeNot(this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.removeType(this.bill, ATermUtils.makeNot(this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testMerge() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        this.kb.addPropertyValue(this.sibling, this.chris, this.victor);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((!this.kb.getABox().getPseudoModel().getNode(this.bill).hasSuccessor(this.kb.getABox().getPseudoModel().getNode(this.victor)) ? 1 : 0) != 0);
        this.kb.addSame(this.chris, this.bill);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.bill).hasSuccessor(this.kb.getABox().getPseudoModel().getNode(this.victor)));
        this.kb.addDifferent(this.bill, this.chris);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
    }

    public void testMerge3() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        ATermAppl max = ATermUtils.makeMax((ATerm)this.sibling, 1, (ATerm)ATermUtils.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = ATermUtils.makeSomeValues(this.owns, this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        this.kb.addType(this.bill, max);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        this.kb.removeType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.john).hasType(this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).hasType(this.dog));
    }

    public void testMerge2() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.man);
        this.kb.addClass(this.dog);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        ATermAppl max = ATermUtils.makeMax((ATerm)this.sibling, 1, (ATerm)ATermUtils.TOP);
        this.kb.addClass(max);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        this.kb.addPropertyValue(this.sibling, this.bill, this.mary);
        this.kb.addPropertyValue(this.sibling, this.bill, this.john);
        ATermAppl ownsDog = ATermUtils.makeSomeValues(this.owns, this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl manOrDog = ATermUtils.makeOr(this.man, this.dog);
        this.kb.addClass(manOrDog);
        this.kb.addType(this.mary, manOrDog);
        this.kb.addType(this.chris, manOrDog);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).hasType(this.dog));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.john).hasType(this.dog));
        this.kb.addType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.john).hasType(this.dog));
        this.kb.removeType(this.bill, max);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).isSame(this.kb.getABox().getPseudoModel().getNode(this.john)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getNode(this.john).hasType(this.dog));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getNode(this.mary).hasType(this.dog));
    }

    public void testCompletionQueueBackjumping() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        this.kb.addObjectProperty(this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty(this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        ATermAppl ownsDog = ATermUtils.makeSomeValues(this.owns, this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = ATermUtils.makeAllValues(this.owns, this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = ATermUtils.makeAnd(allCat, this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        this.kb.addType(this.victor, ATermUtils.makeNot(this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        this.kb.removeType(this.victor, ATermUtils.makeNot(this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasType(ATermUtils.makeNot(this.man)));
        this.kb.addType(this.robert, ATermUtils.makeNot(this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasType(ATermUtils.makeNot(this.man)));
        this.kb.removeType(this.robert, ATermUtils.makeNot(this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasType(ATermUtils.makeNot(this.man)));
        this.kb.addType(this.robert, ATermUtils.makeNot(this.woman));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
    }

    public void testRemoveBranch() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.dog);
        this.kb.addClass(this.cat);
        this.kb.addClass(this.man);
        this.kb.addClass(this.woman);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.owns);
        this.kb.addObjectProperty(this.ownedBy);
        this.kb.addInverseProperty(this.owns, this.ownedBy);
        this.kb.addObjectProperty(this.knows);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.chris);
        this.kb.addIndividual(this.john);
        this.kb.addIndividual(this.bill);
        ATermAppl ownsDog = ATermUtils.makeSomeValues(this.owns, this.dog);
        this.kb.addClass(ownsDog);
        this.kb.addSubClass(this.man, ownsDog);
        ATermAppl allCat = ATermUtils.makeAllValues(this.owns, this.cat);
        this.kb.addClass(allCat);
        ATermAppl catAndMan = ATermUtils.makeAnd(allCat, this.man);
        this.kb.addClass(catAndMan);
        ATermAppl manOrWoman = ATermUtils.makeOr(this.man, this.woman);
        this.kb.addClass(manOrWoman);
        this.kb.addType(this.robert, manOrWoman);
        this.kb.addType(this.victor, manOrWoman);
        this.kb.addType(this.mary, manOrWoman);
        this.kb.addType(this.chris, manOrWoman);
        this.kb.addType(this.john, manOrWoman);
        this.kb.addType(this.bill, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        this.kb.removeType(this.victor, manOrWoman);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.mary).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.chris).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.john).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.bill).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((this.kb.getABox().getPseudoModel().getBranches().size() == 5 ? 1 : 0) != 0);
        this.kb.addType(this.chris, ATermUtils.makeNot(this.man));
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.chris).getTypes().contains(this.man));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.chris).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertFalse((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.robert).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.mary).hasRNeighbor(this.kb.getRBox().getRole(this.owns)));
    }

    public void testUpdatedIndviduals() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addObjectProperty(this.sibling);
        this.kb.addObjectProperty(this.relative);
        this.kb.addRange(this.relative, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(this.relative, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        ATermAppl siblingPerson = ATermUtils.makeAllValues(this.sibling, this.person);
        this.kb.addClass(siblingPerson);
        this.kb.addType(this.victor, this.person);
        this.kb.addType(this.mary, this.person);
        this.kb.addType(this.robert, siblingPerson);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasType(this.person));
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.mary).hasType(this.person));
        this.kb.removeType(this.victor, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.victor).hasType(this.person));
        this.kb.removeType(this.mary, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        IncConsistencyTests.assertTrue((boolean)this.kb.getABox().getPseudoModel().getIndividual(this.mary).hasType(this.person));
    }

    public void testClashDependency() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(this.notPerson);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addType(this.robert, this.person);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addType(this.robert, this.notPerson);
        IncConsistencyTests.assertFalse((boolean)this.kb.isConsistent());
        this.kb.removeType(this.robert, this.notPerson);
        IncConsistencyTests.assertTrue((boolean)this.kb.isConsistent());
    }

    public void testBlocking() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.person);
        this.kb.addClass(ATermUtils.makeNot(this.person));
        this.kb.addDisjointClass(this.person, ATermUtils.makeNot(this.person));
        this.kb.addObjectProperty(this.knows);
        this.kb.addObjectProperty(this.ownedBy);
        this.kb.addObjectProperty(this.owns);
        this.kb.addInverseProperty(this.ownedBy, this.owns);
        ATermAppl allSPerson = ATermUtils.makeAllValues(this.knows, ATermUtils.makeNot(this.person));
        this.kb.addClass(allSPerson);
        ATermAppl allRInvallSPerson = ATermUtils.makeAllValues(this.ownedBy, allSPerson);
        this.kb.addClass(allRInvallSPerson);
        ATermAppl allRInvallRInvallSPerson = ATermUtils.makeAllValues(this.ownedBy, allRInvallSPerson);
        this.kb.addClass(allRInvallRInvallSPerson);
        ATermAppl allRInvallRInvallRInvallSPerson = ATermUtils.makeAllValues(this.ownedBy, allRInvallRInvallSPerson);
        this.kb.addClass(allRInvallRInvallRInvallSPerson);
        ATermAppl allRallRInvallRInvallSPerson = ATermUtils.makeAllValues(this.owns, allRInvallRInvallRInvallSPerson);
        this.kb.addClass(allRallRInvallRInvallSPerson);
        ATermAppl allRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues(this.owns, allRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRInvallRInvallSPerson);
        ATermAppl allRallRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues(this.owns, allRallRallRInvallRInvallSPerson);
        this.kb.addClass(allRallRallRallRInvallRInvallSPerson);
        ATermAppl allSallRallRallRallRInvallRInvallSPerson = ATermUtils.makeAllValues(this.knows, allRallRallRallRInvallRInvallSPerson);
        this.kb.addClass(allSallRallRallRallRInvallRInvallSPerson);
        ATermAppl neg = ATermUtils.makeNot(allSallRallRallRallRInvallRInvallSPerson);
        neg = ATermUtils.normalize(neg);
        this.kb.addClass(neg);
        this.kb.addClass(this.man);
        this.kb.addEquivalentClass(this.man, neg);
        this.kb.addClass(this.woman);
        ATermAppl someWoman = ATermUtils.makeSomeValues(this.owns, this.woman);
        this.kb.addClass(someWoman);
        this.kb.addSubClass(this.woman, someWoman);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.john);
        this.kb.addType(this.mary, this.woman);
        this.kb.addPropertyValue(this.knows, this.robert, this.mary);
        this.kb.addPropertyValue(this.knows, this.mary, this.john);
        this.kb.prepare();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.DEBUG);
        this.kb.isConsistent();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.OFF);
        this.kb.addType(this.john, this.person);
        this.kb.addType(this.robert, ATermUtils.makeNot(this.man));
        System.out.println("Checking consistency");
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.DEBUG);
        boolean cons = this.kb.isConsistent();
        ((Log4JLogger)ABox.log).getLogger().setLevel(Level.OFF);
        System.out.println("Done (" + cons + ")");
        IncConsistencyTests.assertFalse((boolean)cons);
    }
}

