/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.HashSet;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class SWRLPerformanceTests
extends PelletTestCase {
    public static final String base = "file:" + PelletTestSuite.base + "swrl-test/misc/";
    URI basicFamily = URI.create("http://www.csc.liv.ac.uk/~luigi/ontologies/basicFamily");
    URI daycare = URI.create("https://mywebspace.wisc.edu/jpthielman/web/daycareontology");
    URI protegeFamily = URI.create("http://a.com/ontology");
    OWLDataFactory factory;
    OWLOntology ontology;
    OWLOntologyManager manager;
    Reasoner reasoner;

    public void setUp() {
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.reasoner = new Reasoner(this.manager);
    }

    public void testBasicFamily() throws OWLOntologyCreationException {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        ontologies.add(this.manager.loadOntology(URI.create(base + "basicFamilyReference.owl")));
        ontologies.add(this.manager.loadOntology(URI.create(base + "basicFamilyRules.owl")));
        this.reasoner.loadOntologies(ontologies);
        OWLObjectProperty uncle = this.factory.getOWLObjectProperty(this.basicFamily.resolve("#hasUncle"));
        int i = 0;
        for (OWLIndividual ind : this.reasoner.getIndividuals()) {
            ++i;
            System.out.println(ind.toString() + ": " + this.reasoner.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)uncle));
        }
        this.reasoner.getKB().timers.print();
    }

    public void testDayCare() throws OWLOntologyCreationException {
        this.ontology = this.manager.loadOntology(URI.create(base + "daycare.swrl.owl"));
        this.reasoner.setOntology(this.ontology);
        OWLObjectProperty exposedTo = this.factory.getOWLObjectProperty(this.daycare.resolve("#is_exposed_to"));
        int i = 0;
        for (OWLIndividual ind : this.reasoner.getIndividuals()) {
            ++i;
            System.out.println(ind.toString() + ": " + this.reasoner.getRelatedIndividuals(ind, (OWLObjectPropertyExpression)exposedTo));
        }
        this.reasoner.getKB().timers.print();
    }

    public void testProtegeFamily() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "family.swrl.owl");
        Resource m02 = ontModel.createResource(this.protegeFamily.resolve("#M02").toString());
        Property hasSibling = ontModel.createProperty(this.protegeFamily.resolve("#hasSibling").toString());
        StmtIterator iter = ontModel.listStatements(m02, hasSibling, (RDFNode)null);
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            System.out.println(statement);
        }
        ((PelletInfGraph)ontModel.getGraph()).getKB().timers.print();
    }
}

