/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATermAppl;
import java.util.Collections;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Rule;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.rules.ReteToRulesTranslator;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TranslatorTests
extends PelletTestCase {
    private ATermAppl a = ATermUtils.makeTermAppl("a");
    private ATermAppl c = ATermUtils.makePlainLiteral("c");
    private ATermAppl pd = ATermUtils.makeTermAppl("pd");
    private ATermAppl pi = ATermUtils.makeTermAppl("pi");
    private AtomIConstant ca = new AtomIConstant(this.a);
    private AtomDConstant cc = new AtomDConstant(this.c);
    private Constant cra = new Constant(this.a);
    private Constant crc = new Constant(this.c);
    private KnowledgeBase kb;
    private ReteToRulesTranslator reteTranslator;
    private RulesToReteTranslator ruleTranslator;
    private Variable vrx = new Variable("x");
    private AtomIVariable vx = new AtomIVariable("x");
    private AtomDVariable vz = new AtomDVariable("z");

    public void setUp() {
        this.kb = new KnowledgeBase();
        this.reteTranslator = new ReteToRulesTranslator(this.kb.getABox());
        this.ruleTranslator = new RulesToReteTranslator(this.kb.getABox());
    }

    public void testClassAtom() {
        ClassAtom atom = new ClassAtom(this.c, this.vx);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{Compiler.TYPE, this.vrx, this.crc});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
        TranslatorTests.assertEquals((Object)atom, (Object)this.reteTranslator.translateTriple(triple));
    }

    public void testDataRangeAtom() {
        DataRangeAtom atom = new DataRangeAtom(XSDString.instance, this.vz);
        TranslatorTests.assertNull((Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
    }

    public void testDatavaluedPropertyAtom() {
        this.kb.addDatatypeProperty(this.pd);
        DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(this.pd, this.vx, this.cc);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{new Constant(this.pd), this.vrx, this.crc});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
        TranslatorTests.assertEquals((Object)atom, (Object)this.reteTranslator.translateTriple(triple));
    }

    public void testDifferentIndividualsAtom() {
        this.kb.addIndividual(this.a);
        DifferentIndividualsAtom atom = new DifferentIndividualsAtom(this.vx, this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{Compiler.DIFF_FROM, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
        TranslatorTests.assertEquals((Object)atom, (Object)this.reteTranslator.translateTriple(triple));
    }

    public void testIndividualPropertyAtom() {
        this.kb.addObjectProperty(this.pi);
        this.kb.addIndividual(this.a);
        IndividualPropertyAtom atom = new IndividualPropertyAtom(this.pi, this.vx, this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{new Constant(this.pi), this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
        TranslatorTests.assertEquals((Object)atom, (Object)this.reteTranslator.translateTriple(triple));
    }

    public void testSameIndividualAtom() {
        this.kb.addIndividual(this.a);
        SameIndividualAtom atom = new SameIndividualAtom(this.vx, this.ca);
        TermTuple triple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{Compiler.SAME_AS, this.vrx, this.cra});
        TranslatorTests.assertEquals((Object)triple, (Object)this.ruleTranslator.translateAtom(atom, DependencySet.INDEPENDENT));
        TranslatorTests.assertEquals((Object)atom, (Object)this.reteTranslator.translateTriple(triple));
    }

    public void testTranslateRule() {
        this.kb.addObjectProperty(this.pi);
        this.kb.addIndividual(this.a);
        IndividualPropertyAtom bodyAtom = new IndividualPropertyAtom(this.pi, this.vx, this.ca);
        TermTuple bodyTriple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{new Constant(this.pi), this.vrx, this.cra});
        SameIndividualAtom headAtom = new SameIndividualAtom(this.vx, this.ca);
        TermTuple headTriple = new TermTuple(DependencySet.INDEPENDENT, new Term[]{Compiler.SAME_AS, this.vrx, this.cra});
        org.mindswap.pellet.rules.model.Rule rule = new org.mindswap.pellet.rules.model.Rule(Collections.singletonList(headAtom), Collections.singletonList(bodyAtom));
        Rule reteRule = new Rule(Collections.singletonList(bodyTriple), Collections.singletonList(headTriple));
        TranslatorTests.assertEquals((Object)reteRule, (Object)this.ruleTranslator.translateRule(rule));
        TranslatorTests.assertEquals((Object)rule, (Object)this.reteTranslator.translateRule(reteRule));
    }
}

