/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUtils {
    public static final Set EMPTY_SET = Collections.EMPTY_SET;

    public static <T> Set<T> add(T o, Set<T> set) {
        int size = set.size();
        if (size == 0) {
            set = SetUtils.singleton(o);
        } else if (size == 1) {
            T existing = set.iterator().next();
            if (!existing.equals(o)) {
                set = SetUtils.binary(existing, o);
            }
        } else {
            set.add(o);
        }
        return set;
    }

    public static final <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static Set remove(Object o, Set set) {
        int size = set.size();
        if (size != 0) {
            if (size == 1) {
                if (set.contains(o)) {
                    set = EMPTY_SET;
                }
            } else {
                set.remove(o);
            }
        }
        return set;
    }

    public static final <T> Set<T> singleton(T o) {
        return Collections.singleton(o);
    }

    public static final <T> Set<T> binary(T o1, T o2) {
        HashSet<T> set = new HashSet<T>();
        set.add(o1);
        set.add(o2);
        return set;
    }

    public static <T> Set<T> union(Collection<? extends Collection<T>> coll) {
        HashSet<T> set = new HashSet<T>();
        for (Collection<T> innerColl : coll) {
            set.addAll(innerColl);
        }
        return set;
    }

    public static <T> Set<T> union(Collection<T> c1, Collection<T> c2) {
        HashSet<T> set = new HashSet<T>(c1);
        set.addAll(c2);
        return set;
    }

    public static <T> Set<T> intersection(Collection<T> c1, Collection c2) {
        HashSet<T> set = new HashSet<T>(c1);
        set.retainAll(c2);
        return set;
    }

    public static boolean intersects(Collection c1, Collection c2) {
        Iterator i = c1.iterator();
        while (i.hasNext()) {
            if (!c2.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean subset(Set sub, Set<T> sup) {
        return sub.size() <= sup.size() && sup.containsAll(sub);
    }

    public static <T> boolean equals(Set<T> s1, Set<T> s2) {
        return s1.size() == s2.size() && s1.containsAll(s2);
    }

    public static <T> Set<T> difference(Collection<T> c1, Collection<T> c2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(c1);
        set.removeAll(c2);
        return set;
    }

    public static <T> Set<T> create(T[] elems) {
        HashSet<T> set = new HashSet<T>(elems.length);
        for (int i = 0; i < elems.length; ++i) {
            set.add(elems[i]);
        }
        return set;
    }

    public static <T> Set<T> create(Collection<T> coll) {
        return new HashSet<T>(coll);
    }
}

