/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.Timer;

public class Timers {
    private Map timers = new LinkedHashMap();
    public Timer mainTimer = this.createTimer("main");

    public Timers() {
        this.mainTimer.start();
    }

    public void addAll(Timers other) {
        for (String name : other.timers.keySet()) {
            Timer otherTimer = other.getTimer(name);
            Timer thisTimer = this.getTimer(name);
            if (thisTimer == null) {
                this.timers.put(name, otherTimer);
                continue;
            }
            thisTimer.add(otherTimer);
        }
    }

    public Timer createTimer(String name) {
        Timer t = new Timer(name, this.mainTimer);
        this.timers.put(name, t);
        return t;
    }

    public Timer startTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.start();
        return t;
    }

    public void checkTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.check();
    }

    public void resetTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.start();
    }

    public void setTimeout(String name, long timeout) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.setTimeout(timeout);
    }

    public void stopTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.stop();
    }

    public void resetAll() {
        for (Timer timer : this.timers.values()) {
            timer.reset();
        }
        this.mainTimer.start();
    }

    public long getTimerTotal(String name) {
        Timer timer = this.getTimer(name);
        return timer == null ? 0L : timer.getTotal();
    }

    public double getTimerAverage(String name) {
        Timer timer = this.getTimer(name);
        return timer == null ? 0.0 : timer.getAverage();
    }

    public Timer getTimer(String name) {
        return (Timer)this.timers.get(name);
    }

    public void print() {
        this.print(false);
    }

    public void print(boolean shortForm) {
        this.print(shortForm, "Total");
    }

    public void print(boolean shortForm, final String sortBy) {
        boolean[] blArray;
        String[] stringArray;
        if (shortForm) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Name";
            stringArray = stringArray2;
            stringArray2[1] = "Total (s)";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "Name";
            stringArray3[1] = "Count";
            stringArray3[2] = "Avg";
            stringArray = stringArray3;
            stringArray3[3] = "Total (s)";
        }
        String[] colNames = stringArray;
        if (shortForm) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[4];
            blArray3[0] = false;
            blArray3[1] = true;
            blArray3[2] = true;
            blArray = blArray3;
            blArray3[3] = true;
        }
        boolean[] alignment = blArray;
        ArrayList list = new ArrayList(this.timers.values());
        if (sortBy != null) {
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (sortBy.equalsIgnoreCase("Total")) {
                        long t1 = ((Timer)o1).getTotal();
                        long t2 = ((Timer)o2).getTotal();
                        if (t1 == 0L) {
                            t1 = ((Timer)o1).getElapsed();
                        }
                        if (t2 == 0L) {
                            t2 = ((Timer)o2).getElapsed();
                        }
                        return (int)(t2 - t1);
                    }
                    if (sortBy.equalsIgnoreCase("Avg")) {
                        return (int)(((Timer)o2).getAverage() - ((Timer)o1).getAverage());
                    }
                    if (sortBy.equalsIgnoreCase("Count")) {
                        return (int)(((Timer)o2).getCount() - ((Timer)o1).getCount());
                    }
                    return ((Timer)o2).getName().compareTo(((Timer)o1).getName());
                }
            });
        }
        DecimalFormat nf = new DecimalFormat("0.00");
        TableData table = new TableData(Arrays.asList(colNames));
        table.setAlignment(alignment);
        for (Timer timer : list) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(timer.getName());
            if (!shortForm) {
                row.add(String.valueOf(timer.getCount()));
                row.add(nf.format(timer.getAverage()));
            }
            if (timer.isStarted()) {
                row.add(String.valueOf(timer.getElapsed()));
            } else {
                row.add(String.valueOf(timer.getTotal()));
            }
            table.add(row);
        }
        table.print(System.out);
    }

    public String toString() {
        return this.timers.values().toString();
    }
}

