/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import org.mindswap.pellet.utils.progress.AbstractProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public class ConsoleProgressMonitor
extends AbstractProgressMonitor
implements ProgressMonitor {
    private String lastMessage = "";
    public boolean CONSOLE = System.getProperty("console", "true").equals("true");

    public ConsoleProgressMonitor() {
    }

    public ConsoleProgressMonitor(int length) {
        this.setProgressLength(length);
    }

    protected void resetProgress() {
        super.resetProgress();
        this.lastMessage = "";
    }

    public void taskStarted() {
        super.taskStarted();
        System.out.println(this.progressTitle + " " + this.progressLength + " elements");
    }

    protected void updateProgress() {
        int pc = (int)(100.0 * (double)this.progress / (double)this.progressLength);
        if (pc == this.progressPercent) {
            return;
        }
        this.progressPercent = pc;
        if (this.CONSOLE) {
            for (int i = 0; i < this.lastMessage.length(); ++i) {
                System.out.print('\b');
            }
        }
        this.lastMessage = this.progressTitle + ": " + this.progressMessage + " " + pc + "% complete in " + this.calcElapsedTime();
        if (this.CONSOLE) {
            System.out.print(this.lastMessage);
        } else if (pc > 0 && pc % 10 == 0) {
            System.out.println(this.lastMessage);
        }
    }

    private String calcElapsedTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long timeInSeconds = elapsedTime / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pad(hours));
        buffer.append(':');
        buffer.append(this.pad(minutes));
        buffer.append(':');
        buffer.append(this.pad(seconds));
        return buffer.toString();
    }

    private String pad(long value) {
        String str = value < 10L ? "0" : "";
        return str + value;
    }

    public void taskFinished() {
        this.setProgress(this.progressLength);
        if (this.CONSOLE) {
            System.out.println();
        }
        System.out.println(this.progressTitle + " finished");
    }
}

