/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestDAMLList
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLList("TestDAMLList");
    }

    public TestDAMLList(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLList.getAll"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest((Iterator)l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getFirst"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                2.assertEquals((String)"DAMLList.getFirst()", (Object)A, (Object)l.getFirst());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.cons"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{B, C});
                DAMLList l2 = l.cons((DAMLCommon)A);
                this.iteratorTest((Iterator)l2.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getRest"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest((Iterator)l.getRest().getAll(), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getCount"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                5.assertEquals((String)"count", (int)3, (int)l.getCount());
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setFirst"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{B, B, C});
                l.setFirst((DAMLCommon)A);
                this.iteratorTest((Iterator)l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRest"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A});
                DAMLList l2 = m.createDAMLList(new RDFNode[]{B, C});
                l.setRest(l2);
                this.iteratorTest((Iterator)l.getAll(), new Object[]{A, B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.setRestNil"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                l.getRest().setRestNil();
                this.iteratorTest((Iterator)l.getAll(), new Object[]{A, B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.nil"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLList l = m.createDAMLList();
                9.assertTrue((String)"nil is nil", (boolean)l.isNil((Resource)l.getNil()));
                9.assertFalse((String)"A is not nil", (boolean)l.isNil((Resource)A));
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.findLast"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                this.iteratorTest((Iterator)l.findLast().getAll(), new Object[]{C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLList.getItem"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLList l = m.createDAMLList(new RDFNode[]{A, B, C});
                11.assertEquals((String)"A", (Object)A, (Object)l.getItem(0));
                11.assertEquals((String)"B", (Object)B, (Object)l.getItem(1));
                11.assertEquals((String)"C", (Object)C, (Object)l.getItem(2));
            }
        }};
    }
}

