/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestWrappedIterator
extends GraphTestBase {
    public static TestSuite suite() {
        return new TestSuite(TestWrappedIterator.class);
    }

    public TestWrappedIterator(String name) {
        super(name);
    }

    public void testWrappedIterator() {
        Iterator<String> i = Arrays.asList("bill", "and", "ben").iterator();
        ExtendedIterator e = WrappedIterator.create(i);
        TestWrappedIterator.assertTrue((String)"wrapper has at least one element", (boolean)e.hasNext());
        TestWrappedIterator.assertEquals((String)"", (Object)"bill", (Object)e.next());
        TestWrappedIterator.assertTrue((String)"wrapper has at least two elements", (boolean)e.hasNext());
        TestWrappedIterator.assertEquals((String)"", (Object)"and", (Object)e.next());
        TestWrappedIterator.assertTrue((String)"wrapper has at least three elements", (boolean)e.hasNext());
        TestWrappedIterator.assertEquals((String)"", (Object)"ben", (Object)e.next());
        TestWrappedIterator.assertFalse((String)"wrapper is now empty", (boolean)e.hasNext());
    }

    public void testUnwrapExtendedIterator() {
        ExtendedIterator i = TestWrappedIterator.graphWith("a R b").find((TripleMatch)Triple.ANY);
        TestWrappedIterator.assertSame((Object)i, (Object)WrappedIterator.create((Iterator)i));
    }

    public void testWrappedNoRemove() {
        Iterator base = this.nodeSet("a b c").iterator();
        base.next();
        base.remove();
        WrappedIterator wrapped = WrappedIterator.createNoRemove(base);
        wrapped.next();
        try {
            wrapped.remove();
            TestWrappedIterator.fail((String)"wrapped-no-remove iterator should deny .remove()");
        }
        catch (UnsupportedOperationException e) {
            TestWrappedIterator.pass();
        }
    }
}

