/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import fr.pasteur.sysbio.rdfscape.browsing.BrowserManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BrowserOptionPanel
extends JPanel {
    BrowserManager browserManager = null;
    private JCheckBox allNamespaceConditionCheckBox = null;
    private JCheckBox collapseDatatypesCheckBox = null;
    JCheckBox useLabelsCheckBox = null;
    JCheckBox splitPropertiesCheckBox = null;
    JList splitPropertiesList = null;
    JTextArea splitPropertyArea = null;
    JTextArea splitPropertiesTextArea = null;
    JButton splitPropertiesButton = null;

    public BrowserOptionPanel(BrowserManager browserManager) {
        this.browserManager = browserManager;
        this.allNamespaceConditionCheckBox = new JCheckBox("Namespace selection in and", this.browserManager.isNamespaceSelectionInAnd());
        this.collapseDatatypesCheckBox = new JCheckBox("Treat datatypes as attributes", this.browserManager.isCollapseAttributesTrue());
        this.useLabelsCheckBox = new JCheckBox("Use labels instead of URIs");
        this.splitPropertiesCheckBox = new JCheckBox("Treat some URI as multiple nodes");
        this.splitPropertiesTextArea = new JTextArea(20, 60);
        JScrollPane jScrollPane = new JScrollPane(this.splitPropertiesTextArea);
        this.splitPropertiesButton = new JButton("Commit");
        this.allNamespaceConditionCheckBox.setToolTipText("If on, when extending a network, both properties and objects must be in selected namespaces. If off, onw of the two will suffice.");
        this.collapseDatatypesCheckBox.setToolTipText("If on, datatype properties will be treated as attributes in a raph representation.");
        this.allNamespaceConditionCheckBox.addActionListener(new allNamespaceConditionBoxListener());
        this.collapseDatatypesCheckBox.addActionListener(new collapseDatatypesCheckBoxListener());
        this.useLabelsCheckBox.addActionListener(new useLabelsCheckBoxListener());
        this.splitPropertiesCheckBox.addActionListener(new splitCheckBoxListener());
        this.splitPropertiesButton.addActionListener(new splitPropertiesButtonListener());
        this.splitPropertyArea = new JTextArea();
        this.add(this.allNamespaceConditionCheckBox);
        this.add(this.collapseDatatypesCheckBox);
        this.add(this.useLabelsCheckBox);
        this.add(this.splitPropertiesCheckBox);
        this.add(jScrollPane);
        this.add(this.splitPropertiesButton);
        this.splitPropertiesButton.setEnabled(false);
        this.splitPropertiesTextArea.setEnabled(false);
    }

    public void refreshAfterKnowledgeChange() {
        if (!this.browserManager.canCollapseDatatypes()) {
            this.collapseDatatypesCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canExtend()) {
            this.allNamespaceConditionCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canHandleLabels()) {
            this.useLabelsCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canHandleSplit()) {
            this.splitPropertiesCheckBox.setEnabled(false);
            this.splitPropertiesTextArea.setEnabled(false);
        }
    }

    public void setSplitConditions(String string) {
        this.splitPropertiesTextArea.setText(string);
    }

    private class splitPropertiesButtonListener
    implements ActionListener {
        private splitPropertiesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setSplitConditions(BrowserOptionPanel.this.splitPropertiesTextArea.getText());
        }
    }

    private class splitCheckBoxListener
    implements ActionListener {
        private splitCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.splitPropertiesButton.setEnabled(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
            BrowserOptionPanel.this.splitPropertiesTextArea.setEnabled(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
            BrowserOptionPanel.this.browserManager.setEnableSplit(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
        }
    }

    private class useLabelsCheckBoxListener
    implements ActionListener {
        private useLabelsCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setUseLabels(BrowserOptionPanel.this.useLabelsCheckBox.isSelected());
        }
    }

    private class collapseDatatypesCheckBoxListener
    implements ActionListener {
        private collapseDatatypesCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setCollapseAttributes(BrowserOptionPanel.this.collapseDatatypesCheckBox.isSelected());
        }
    }

    private class allNamespaceConditionBoxListener
    implements ActionListener {
        private allNamespaceConditionBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setNamespaceSelectionInAnd(BrowserOptionPanel.this.allNamespaceConditionCheckBox.isSelected());
        }
    }
}

