/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import fr.pasteur.sysbio.rdfscape.browsing.BrowserManager;
import fr.pasteur.sysbio.rdfscape.browsing.ResultTableViewer;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class BrowserPanel
extends JPanel {
    private BrowserManager browserManager = null;
    private JComboBox queryEnginesBox = null;
    private Hashtable queryEngines = null;
    private JButton editNetworkButton = null;
    private JButton getNetworkPatternButton = null;
    private JButton newNetworkButton = null;
    private JButton makeQueryButton = null;
    private JButton clearQueryButton = null;
    private JButton selectAll = null;
    private JButton plotSelection = null;
    private JButton searchSelection = null;
    private ResultTableViewer resultTable = null;
    private AbstractQueryResultTable queryResult = null;
    private JPanel upPanel = null;
    private JComponent currentQueryPanel = null;
    private MyQueryEngine currentQueryEngine = null;
    private BrowseModeListener browseModeListener = null;
    private JPanel northPanel = null;
    private JPanel patternPanel = null;
    private JPanel newNetworkPanel = null;

    public BrowserPanel(BrowserManager browserManager) {
        this.browserManager = browserManager;
        this.browseModeListener = new BrowseModeListener();
        this.editNetworkButton = new JButton("Make Editable");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browserManager.setEditable();
            }
        };
        this.editNetworkButton.addActionListener(actionListener);
        this.getNetworkPatternButton = new JButton("Get Pattern");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Insert pattern name : ");
                if (string != null) {
                    BrowserPanel.this.browserManager.getSnapshot(string);
                }
            }
        };
        this.getNetworkPatternButton.addActionListener(actionListener2);
        this.newNetworkButton = new JButton("Create new network");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browserManager.makeNewCytoscapePanel((String)BrowserPanel.this.queryEnginesBox.getSelectedItem());
            }
        };
        this.newNetworkButton.addActionListener(actionListener3);
        this.newNetworkPanel = new JPanel();
        this.newNetworkPanel.setBorder(new TitledBorder("Network"));
        this.newNetworkPanel.add(this.newNetworkButton);
        this.patternPanel = new JPanel();
        this.patternPanel.setBorder(new TitledBorder("Pattern definition"));
        this.patternPanel.add(this.editNetworkButton);
        this.patternPanel.add(this.getNetworkPatternButton);
        this.resultTable = new ResultTableViewer();
        this.makeQueryButton = new JButton("Make Query");
        this.clearQueryButton = new JButton("Clear Query");
        this.selectAll = new JButton("Select All");
        this.plotSelection = new JButton("Plot Selection");
        this.searchSelection = new JButton("Search Selection");
        this.makeQueryButton.addActionListener(new QueryExecListener());
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.resultTable.selectAll();
            }
        };
        this.clearQueryButton.addActionListener(new ClearButtonListener());
        this.selectAll.addActionListener(actionListener4);
        this.plotSelection.addActionListener(new PlotSelectionListener());
        this.searchSelection.addActionListener(new SearchSelectionListener());
        this.upPanel = new JPanel();
        this.upPanel.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new GridLayout(1, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.add(this.makeQueryButton);
        jPanel.add(this.clearQueryButton);
        jPanel.add(this.selectAll);
        jPanel.add(this.plotSelection);
        jPanel.add(this.searchSelection);
        this.upPanel.add((Component)this.northPanel, "North");
        this.upPanel.add((Component)jPanel, "South");
        this.currentQueryPanel = new JPanel();
        this.upPanel.add((Component)this.currentQueryPanel, "Center");
        this.setLayout(new GridLayout(2, 1));
        this.add(this.upPanel);
        JScrollPane jScrollPane = new JScrollPane(this.resultTable);
        jScrollPane.setBorder(new TitledBorder("Results"));
        this.add(jScrollPane);
        this.initBrowseOptions();
        this.northPanel.add(this.queryEnginesBox);
        this.northPanel.add(this.newNetworkPanel);
        this.northPanel.add(this.patternPanel);
    }

    private void initBrowseOptions() {
        ArrayList arrayList = this.browserManager.getAvailableQueryElements();
        System.out.println("Available query engines: " + arrayList.size());
        this.queryEngines = new Hashtable();
        if (arrayList.size() == 0) {
            System.out.println("case 0");
            String[] stringArray = new String[]{"NO QUERY AVAILABLE"};
            this.queryEnginesBox = new JComboBox<String>(stringArray);
            this.queryEnginesBox.setBorder(new TitledBorder("Browse mode"));
            this.queryEnginesBox.setEnabled(false);
            this.currentQueryEngine = null;
            if (this.currentQueryPanel != null) {
                this.upPanel.remove(this.currentQueryPanel);
                this.currentQueryPanel = new JPanel();
                this.upPanel.add((Component)this.currentQueryPanel, "Center");
            }
            this.makeQueryButton.setEnabled(false);
            this.clearQueryButton.setEnabled(false);
            this.plotSelection.setEnabled(false);
            this.searchSelection.setEnabled(false);
            this.selectAll.setEnabled(false);
            System.out.println("case 0 completed");
            return;
        }
        int n = 0;
        String[] stringArray = new String[arrayList.size()];
        for (MyQueryEngine myQueryEngine : arrayList) {
            this.queryEngines.put(myQueryEngine.getLabel(), myQueryEngine);
            stringArray[n] = myQueryEngine.getLabel();
            ++n;
        }
        this.queryEnginesBox = new JComboBox<String>(stringArray);
        this.queryEnginesBox.setBorder(new TitledBorder("Browse mode"));
        this.queryEnginesBox.addActionListener(this.browseModeListener);
        this.makeQueryButton.setEnabled(true);
        this.clearQueryButton.setEnabled(true);
        this.plotSelection.setEnabled(true);
        this.searchSelection.setEnabled(true);
        this.selectAll.setEnabled(true);
        this.queryEnginesBox.setSelectedIndex(0);
        this.currentQueryEngine = (MyQueryEngine)this.queryEngines.get((String)this.queryEnginesBox.getSelectedItem());
        this.currentQueryPanel = this.currentQueryEngine.getPanel();
    }

    public void reset() {
        this.resetQuery();
    }

    public void resetQuery() {
        Enumeration enumeration = this.queryEngines.elements();
        while (enumeration.hasMoreElements()) {
            ((MyQueryEngine)enumeration.nextElement()).reset();
        }
        this.resultTable.setModel(new JenaQueryResultTable());
    }

    public void refreshAfterEngineChange() {
        this.northPanel.remove(this.queryEnginesBox);
        this.northPanel.remove(this.newNetworkPanel);
        this.northPanel.remove(this.patternPanel);
        this.initBrowseOptions();
        this.resetQuery();
        this.northPanel.add(this.queryEnginesBox);
        this.northPanel.add(this.newNetworkPanel);
        this.northPanel.add(this.patternPanel);
    }

    private class SearchSelectionListener
    implements ActionListener {
        String[] myNodesStringArray = null;

        private SearchSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BrowserPanel.this.queryResult == null) {
                System.out.println("No query to search");
                return;
            }
            if (BrowserPanel.this.queryResult.getRowCount() == 0) {
                System.out.println("Nothing to search at all ");
                return;
            }
            if (BrowserPanel.this.queryResult.hasGraph()) {
                System.out.println("Graph results are unsupported yet");
            }
            if (BrowserPanel.this.queryResult.hasTable()) {
                System.out.println("I've seen you have selected " + BrowserPanel.this.resultTable.getSelectedRowCount() + " rows");
                BrowserPanel.this.browserManager.searchValuesInResultTable(BrowserPanel.this.queryResult.getSubsetByRows(BrowserPanel.this.resultTable.getSelectedRows()));
            }
        }
    }

    private class PlotSelectionListener
    implements ActionListener {
        String[] myNodesStringArray = null;

        private PlotSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BrowserPanel.this.queryResult == null) {
                System.out.println("No query to plot");
                return;
            }
            if (BrowserPanel.this.queryResult.getRowCount() == 0) {
                System.out.println("Nothing to plot at all ");
                return;
            }
            if (BrowserPanel.this.queryResult.hasGraph()) {
                System.out.println("Graph results are unsupported yet");
            }
            if (BrowserPanel.this.queryResult.hasTable()) {
                System.out.println("I've seen you have selected " + BrowserPanel.this.resultTable.getSelectedRowCount() + " rows");
                BrowserPanel.this.browserManager.plotValuesInResultTable(BrowserPanel.this.queryResult.getSubsetByRows(BrowserPanel.this.resultTable.getSelectedRows()));
            }
        }
    }

    private class QueryExecListener
    implements ActionListener {
        private QueryExecListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserPanel.this.queryResult = BrowserPanel.this.currentQueryEngine.makeQuery();
            BrowserPanel.this.resultTable.setModel(BrowserPanel.this.queryResult);
        }
    }

    private class ClearButtonListener
    implements ActionListener {
        private ClearButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BrowserPanel.this.resetQuery();
        }
    }

    private class BrowseModeListener
    implements ActionListener {
        private BrowseModeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Something changed");
            if (BrowserPanel.this.queryEngines == null) {
                return;
            }
            String string = (String)BrowserPanel.this.queryEnginesBox.getSelectedItem();
            System.out.println("Changing query engine to :" + string);
            if (BrowserPanel.this.queryEngines == null) {
                System.out.println("No query engines yet.");
                return;
            }
            MyQueryEngine myQueryEngine = (MyQueryEngine)BrowserPanel.this.queryEngines.get(string);
            if (BrowserPanel.this.currentQueryEngine == myQueryEngine) {
                System.out.println("... I already had it as deafult. Nothing done.");
                return;
            }
            BrowserPanel.this.upPanel.remove(BrowserPanel.this.currentQueryPanel);
            BrowserPanel.this.currentQueryEngine = myQueryEngine;
            BrowserPanel.this.currentQueryPanel = myQueryEngine.getPanel();
            BrowserPanel.this.upPanel.add((Component)BrowserPanel.this.currentQueryPanel, "Center");
            BrowserPanel.this.updateUI();
            BrowserPanel.this.validate();
        }
    }
}

