/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import com.ibm.icu.util.StringTokenizer;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapperDataPanel;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapperOptionPanel;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapperPanel;
import fr.pasteur.sysbio.rdfscape.cytomapper.MapperTable;
import fr.pasteur.sysbio.rdfscape.cytomapper.MappingRule;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class CytoMapper
implements RDFScapeModuleInterface,
Contextualizable {
    CytoscapeDealer cytoscapeDealer = null;
    CytoMapperPanel myPanel = null;
    CytoMapperOptionPanel myOptionPanel = null;
    CytoMapperDataPanel myDataPanel = null;
    Hashtable mappingRuleList = null;
    MapperTable mapperTable = null;
    public int clashes = 0;
    public int totalURIs = 0;
    public int totalIDs = 0;
    public int totalMatchedID = 0;
    public int totalMatchedURI = 0;
    public int multi = 0;
    ExpressionData myData = null;
    double[][] dataMatrix = null;
    Hashtable geneToDataMapping = null;
    Hashtable conditionToDataMapping = null;
    Hashtable id2URI = null;
    Hashtable uri2ID = null;

    public CytoMapper() throws Exception {
        System.out.print("\tCytoMapper... ");
        this.mapperTable = new MapperTable();
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Unable to build CytoMapper : missing CommonMemory");
        }
        RDFScape.getContextManager().addContextualizableElement(this);
        this.initialize();
        System.out.println("Ok");
    }

    public boolean initialize() {
        this.mappingRuleList = new Hashtable();
        this.geneToDataMapping = new Hashtable();
        this.conditionToDataMapping = new Hashtable();
        if (this.myOptionPanel != null) {
            this.myOptionPanel.reset();
            this.myOptionPanel.resetAfterKnowledgeBaseChange();
        }
        this.resetMapping();
        return true;
    }

    public void resetMapping() {
        this.id2URI = new Hashtable();
        this.uri2ID = new Hashtable();
        this.mapperTable.reset();
        this.clashes = 0;
        this.totalURIs = 0;
        this.totalIDs = 0;
        this.totalMatchedID = 0;
        this.totalMatchedURI = 0;
        this.multi = 0;
    }

    public Component getOptionPanel() {
        if (this.myOptionPanel == null) {
            this.myOptionPanel = new CytoMapperOptionPanel(this);
        }
        return this.myOptionPanel;
    }

    public CytoMapperPanel getCytoMapperPanel() {
        if (this.myPanel == null) {
            this.myPanel = new CytoMapperPanel(this);
        }
        return this.myPanel;
    }

    public CytoMapperDataPanel getCytoMapperDataPanel() {
        if (this.myPanel == null) {
            this.myDataPanel = new CytoMapperDataPanel(this);
        }
        return this.myDataPanel;
    }

    public void addMappingRule(MappingRule mappingRule) {
        this.mappingRuleList.put(mappingRule.name, mappingRule);
        this.myOptionPanel.refresh();
    }

    public void parseAndAddMappingRule(String string) {
        String string2 = new String();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        System.out.println(">" + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("NAME:")) {
                string3 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("ID:")) {
                string5 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("URI:")) {
                string4 = stringTokenizer.nextToken();
                continue;
            }
            if (string6.equalsIgnoreCase("PATTERN:")) {
                string2 = string2.concat(stringTokenizer.nextToken());
                continue;
            }
            string2 = string2.concat(" " + string6);
        }
        MappingRule mappingRule = new MappingRule();
        mappingRule.name = string3;
        mappingRule.patternText = string2;
        mappingRule.uriVar = string4;
        mappingRule.idVar = string5;
        if (mappingRule.isValid()) {
            this.addMappingRule(mappingRule);
        }
    }

    public Hashtable getGenesMapping() {
        return this.geneToDataMapping;
    }

    public Hashtable getConditionMappings() {
        return this.conditionToDataMapping;
    }

    public void resolve() {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        this.resetMapping();
        for (String string : this.mappingRuleList.keySet()) {
            System.out.println("rule : " + string);
            MappingRule mappingRule = (MappingRule)this.mappingRuleList.get(string);
            String string2 = "SELECT " + mappingRule.uriVar + " " + mappingRule.idVar + " \n WHERE " + mappingRule.patternText + "\n";
            String string3 = new String();
            String[] stringArray = commonMemory.getNamespaces();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = commonMemory.getNamespacePrefix(stringArray[i]);
                if (string4 == null || string4.equalsIgnoreCase("")) continue;
                string3 = string3 + string4 + " for <" + stringArray[i] + ">,\n";
            }
            if (string3.length() > 1) {
                string3 = string3.substring(0, string3.length() - 2);
                string2 = string2 + "USING\n" + string3 + "\n";
            }
            System.out.println(string2);
            AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledge())).makeRDQLQuery(string2);
            this.analyze(abstractQueryResultTable);
            this.mapperTable.add(abstractQueryResultTable);
            this.mapperTable.fireTableDataChanged();
        }
    }

    private void analyze(AbstractQueryResultTable abstractQueryResultTable) {
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            if (!abstractQueryResultTable.isURI(i, 0) || !abstractQueryResultTable.isLiteral(i, 1)) continue;
            String string = abstractQueryResultTable.getURI(i, 0);
            String string2 = abstractQueryResultTable.getDatatypeValue(i, 1);
            HashSet<String> hashSet = (HashSet<String>)this.uri2ID.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.uri2ID.put(string, hashSet);
            } else if (!hashSet.contains(string2)) {
                ++this.multi;
            }
            hashSet.add(string2);
            if (this.id2URI.get(string2) == null) {
                this.id2URI.put(string2, string);
                continue;
            }
            if (((String)this.id2URI.get(string2)).equals(string)) continue;
            ++this.clashes;
            System.out.println("Clash for:\n " + string2 + " " + string + "\nVs");
            System.out.println(string2 + " " + (String)this.id2URI.get(string2) + "\n");
        }
        this.totalIDs = this.id2URI.keySet().size();
        this.totalURIs = this.uri2ID.keySet().size();
    }

    public void map() {
        int[] nArray = this.cytoscapeDealer.mapNodes(this.id2URI);
        this.totalMatchedID = nArray[0];
        this.totalMatchedURI = nArray[1];
    }

    public void linkData() {
        this.myData = this.cytoscapeDealer.getExpressionData();
        this.myPanel.initLinkBars(this.mapperTable.getTotalURIs(), this.myData.getNumberOfGenes());
        System.out.println("I have a " + this.myData.getNumberOfGenes() + " x " + this.myData.getNumberOfConditions() + " matrix in mind");
        this.dataMatrix = new double[this.mapperTable.getTotalURIs()][this.myData.getNumberOfConditions()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.mapperTable.uriToID.keySet()) {
            ArrayList arrayList = (ArrayList)this.mapperTable.uriToID.get(string);
            Vector vector = this.myData.getMeasurements((String)arrayList.get(0));
            if (vector != null) {
                System.out.println(string + " -> " + arrayList.get(0) + " #" + vector.size());
                this.geneToDataMapping.put(string, new Integer(n));
                this.myPanel.ontologyDataCoverage.setValue(++n3);
                hashSet.add((String)arrayList.get(0));
                this.myPanel.dataOntologyCoverage.setValue(hashSet.size());
                n2 = 0;
                for (mRNAMeasurement mRNAMeasurement2 : vector) {
                    this.dataMatrix[n][n2] = mRNAMeasurement2.getRatio();
                    ++n2;
                }
            }
            ++n;
        }
        System.out.println("TEST:");
        for (int i = 0; i < this.dataMatrix.length; ++i) {
            for (int j = 0; j < this.dataMatrix[i].length; ++j) {
                System.out.print(this.dataMatrix[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public double[][] getDataMatrix() {
        return this.dataMatrix;
    }

    public void reset() {
        this.initialize();
    }

    public void update() {
    }

    public boolean isInValidState() {
        return this.canOperate();
    }

    public boolean canOperate() {
        return true;
    }

    public boolean loadFromActiveContext() {
        this.initialize();
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Unable to locate mapping rules");
            return false;
        }
        try {
            Object var4_4 = null;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                System.out.println("Reading mapping rule : " + fileArray[i].getName());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                int n = 0;
                while ((n = bufferedReader.read(cArray)) >= 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                String string2 = stringBuffer.toString();
                if (!fileArray[i].isFile()) continue;
                this.parseAndAddMappingRule(string2);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to load mapping rules");
            return false;
        }
        return true;
    }

    public boolean saveToContext() {
        System.out.println("Saving...");
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getDefaultMapDirName();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Unable to locate mapping rules");
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        Enumeration enumeration = this.mappingRuleList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            System.out.println("Going to save: " + string2);
            MappingRule mappingRule = (MappingRule)this.mappingRuleList.get(string2);
            File file2 = new File(string + "/" + string2);
            try {
                FileWriter fileWriter = new FileWriter(file2);
                fileWriter.write("NAME: " + mappingRule.getName() + "\n" + "ID: " + mappingRule.getID() + "\n" + "URI: " + mappingRule.getURI() + "\n" + "PATTERN: " + mappingRule.getRuleString());
                fileWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Unable to save mapping rule to file " + string + "/" + string2);
                return false;
            }
        }
        return true;
    }

    public boolean canResolve() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledge());
    }

    public int getNumberOfMatchedIDs() {
        return this.totalMatchedID;
    }

    public int getNumberOfMatchedURIs() {
        return this.totalMatchedURI;
    }

    public int getNumberOfURIsToBeMatched() {
        return this.totalURIs;
    }

    public int getNumberOfNodesToBeMatched() {
        return this.cytoscapeDealer.getNodeCount();
    }

    public void touch() {
    }
}

