/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapper;
import fr.pasteur.sysbio.rdfscape.cytomapper.MappingRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class CytoMapperOptionPanel
extends JPanel {
    CytoMapper cytoMapper = null;
    JPanel rulePanel = null;
    JTable myResultTable = null;
    JTabbedPane ruleTextPanels = null;
    JLabel statLabel = new JLabel();
    JButton addButton = null;
    JButton delButton = null;
    JButton resolveButton = null;
    JButton mergeButton = null;

    public CytoMapperOptionPanel(CytoMapper cytoMapper) {
        this.cytoMapper = cytoMapper;
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.rulePanel = new JPanel(new BorderLayout());
        this.myResultTable = new JTable(this.cytoMapper.mapperTable);
        JScrollPane jScrollPane = new JScrollPane(this.myResultTable);
        this.ruleTextPanels = new JTabbedPane();
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        this.addButton = new JButton("New");
        this.delButton = new JButton("Del");
        this.resolveButton = new JButton("Resolve");
        this.mergeButton = new JButton("Merge");
        jPanel.add(this.addButton);
        jPanel.add(this.delButton);
        jPanel.add(this.resolveButton);
        jPanel.add(this.mergeButton);
        this.rulePanel.add((Component)this.ruleTextPanels, "Center");
        this.rulePanel.add((Component)jPanel, "South");
        jTabbedPane.add((Component)this.rulePanel, "Rules");
        jTabbedPane.add((Component)jScrollPane, "Results");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Insert rule name");
                if (string == null) {
                    return;
                }
                MappingRule mappingRule = new MappingRule();
                mappingRule.name = string;
                CytoMapperOptionPanel.this.cytoMapper.addMappingRule(mappingRule);
            }
        };
        this.addButton.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CytoMapperOptionPanel.this.ruleTextPanels.getSelectedIndex() >= 0) {
                    CytoMapperOptionPanel.this.cytoMapper.mappingRuleList.remove(CytoMapperOptionPanel.this.ruleTextPanels.getTitleAt(CytoMapperOptionPanel.this.ruleTextPanels.getSelectedIndex()));
                    CytoMapperOptionPanel.this.ruleTextPanels.remove(CytoMapperOptionPanel.this.ruleTextPanels.getSelectedComponent());
                }
            }
        };
        this.delButton.addActionListener(actionListener2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CytoMapperOptionPanel.this.cytoMapper.resolve();
                CytoMapperOptionPanel.this.showStats();
            }
        };
        this.resolveButton.addActionListener(actionListener3);
        this.add((Component)jTabbedPane, "Center");
        this.add((Component)this.statLabel, "North");
        this.showStats();
    }

    private void showStats() {
        this.remove(this.statLabel);
        this.statLabel = new JLabel("URIs: " + this.cytoMapper.totalURIs + "              IDs: " + this.cytoMapper.totalIDs + "              Conflicts: " + this.cytoMapper.clashes + "             Multi: " + this.cytoMapper.multi);
        this.add((Component)this.statLabel, "North");
        this.validate();
    }

    public void refresh() {
        this.reset();
        Enumeration enumeration = this.cytoMapper.mappingRuleList.elements();
        while (enumeration.hasMoreElements()) {
            MappingRule mappingRule = (MappingRule)enumeration.nextElement();
            this.ruleTextPanels.add((Component)mappingRule.getPanel(), mappingRule.name);
        }
    }

    public void reset() {
        Component[] componentArray = this.ruleTextPanels.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.ruleTextPanels.remove(componentArray[i]);
        }
    }

    public void resetAfterKnowledgeBaseChange() {
        if (this.cytoMapper.canResolve()) {
            this.resolveButton.setEnabled(true);
        } else {
            this.resolveButton.setEnabled(false);
        }
    }
}

