/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class CytoMapperPanel
extends JPanel {
    CytoMapper cytoMapper = null;
    JButton mapButton = null;
    JButton linkDataButton = null;
    JProgressBar ontologyCoverage = null;
    JProgressBar graphCoverage = null;
    JProgressBar ontologyDataCoverage = null;
    JProgressBar dataOntologyCoverage = null;

    public CytoMapperPanel(CytoMapper cytoMapper) {
        this.cytoMapper = cytoMapper;
        this.mapButton = new JButton("Map");
        this.linkDataButton = new JButton("Link data");
        this.linkDataButton.setEnabled(false);
        this.ontologyCoverage = new JProgressBar();
        this.graphCoverage = new JProgressBar();
        this.ontologyDataCoverage = new JProgressBar();
        this.dataOntologyCoverage = new JProgressBar();
        this.ontologyCoverage.setBorder(new TitledBorder("Ontology Coverage in graph"));
        this.graphCoverage.setBorder(new TitledBorder("Graph Coverage"));
        this.ontologyDataCoverage.setBorder(new TitledBorder("Ontology Coverage in data"));
        this.dataOntologyCoverage.setBorder(new TitledBorder("Data coverage in ontology"));
        this.graphCoverage.setMinimum(0);
        this.graphCoverage.setStringPainted(true);
        this.ontologyDataCoverage.setMinimum(0);
        this.ontologyDataCoverage.setStringPainted(true);
        this.ontologyCoverage.setMinimum(0);
        this.ontologyCoverage.setStringPainted(true);
        this.dataOntologyCoverage.setStringPainted(true);
        this.add(this.mapButton);
        this.add(this.linkDataButton);
        this.add(this.ontologyCoverage);
        this.add(this.graphCoverage);
        this.add(this.ontologyDataCoverage);
        this.add(this.dataOntologyCoverage);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CytoMapperPanel.this.initOntology2GraphBars();
                CytoMapperPanel.this.cytoMapper.map();
                this.updateOntology2GraphBars();
                CytoMapperPanel.this.linkDataButton.setEnabled(true);
            }

            private void updateOntology2GraphBars() {
                CytoMapperPanel.this.ontologyCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfMatchedURIs());
                CytoMapperPanel.this.graphCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfMatchedIDs());
            }
        };
        this.mapButton.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CytoMapperPanel.this.cytoMapper.linkData();
            }
        };
        this.linkDataButton.addActionListener(actionListener2);
    }

    public void initOntology2GraphBars() {
        this.ontologyCoverage.setMaximum(this.cytoMapper.getNumberOfURIsToBeMatched());
        this.ontologyCoverage.setValue(0);
        this.graphCoverage.setMaximum(this.cytoMapper.getNumberOfNodesToBeMatched());
        this.graphCoverage.setValue(0);
    }

    public void initLinkBars(int n, int n2) {
        this.ontologyDataCoverage.setValue(0);
        this.ontologyDataCoverage.setMaximum(n);
        this.dataOntologyCoverage.setValue(0);
        this.dataOntologyCoverage.setMaximum(n2);
    }
}

