/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import ding.view.EdgeContextMenuListener;
import ding.view.InnerCanvas;
import ding.view.NodeContextMenuListener;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.MemoryViewer;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.cytoscape.PatternMenu;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class CytoscapeDealer
implements PropertyChangeListener,
MemoryViewer {
    private CyNetwork myCurrentNetwork = null;
    private CyNetworkView myCurrentNetworkView = null;
    private CommonMemory commonMemory = null;
    private HashMap patternPanels = null;
    private CyNode hackNode = null;
    private static int currentID = 0;
    private Hashtable networkType = null;
    private HashSet isEditable = null;
    private Collection varRestrictions = null;
    private ArrayList tempFilterConditions = null;
    private static int bNodeCounter = 0;
    private static int literalNodeCounter = 0;
    private static int nodeIDCounter = 0;
    private boolean showRDFSLabels = false;
    private boolean collapseDatatypeAttributes = false;
    private boolean enableSplit = false;
    private HashSet uri2Split = null;
    private PatternMenu menuListener = null;

    public CytoscapeDealer() throws Exception {
        System.out.print("\tCytoscapeDealer... ");
        System.out.print(" 0");
        this.link();
        System.out.print(" 1");
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_FOCUS", this);
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_CREATED", this);
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        this.myCurrentNetworkView = Cytoscape.getCurrentNetworkView();
        System.out.print(" 2");
        this.menuListener = new PatternMenu();
        System.out.print(" 3");
        this.patternPanels = new HashMap();
        this.networkType = new Hashtable();
        System.out.print(" 4");
        this.reset();
        System.out.print(" 5 ");
        System.out.println("Ok");
    }

    private void relink() throws Exception {
        this.link();
    }

    private void link() throws Exception {
        if (RDFScape.getCommonMemory() == null) {
            System.out.print("!!!");
            throw new Exception("Cannot build CytoscapeDealer : missing CommonMemory");
        }
        System.out.print(".");
        this.commonMemory = RDFScape.getCommonMemory();
        this.commonMemory.addViewerElement(this);
        System.out.print(".");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        System.out.print("Event ");
        if (propertyChangeEvent.getPropertyName() == "NETWORK_VIEW_CREATED") {
            this.myCurrentNetworkView = (CyNetworkView)propertyChangeEvent.getNewValue();
            System.out.print("focus change ->" + this.myCurrentNetworkView);
        }
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        this.myCurrentNetworkView = Cytoscape.getCurrentNetworkView();
        System.out.println();
    }

    public void reset() {
        this.isEditable = new HashSet();
        this.tempFilterConditions = new ArrayList();
        this.restoreSplitConditions();
    }

    public CyNetwork getCurrentNetwork() {
        return Cytoscape.getCurrentNetwork();
    }

    public Image getScreenshot(int n, int n2) {
        System.out.println("Going to get a screenshot");
        InnerCanvas innerCanvas = ((DGraphView)Cytoscape.getCurrentNetworkView()).getCanvas();
        System.out.println("Dimensions: " + innerCanvas.getWidth() + "x" + innerCanvas.getHeight());
        BufferedImage bufferedImage = new BufferedImage(innerCanvas.getWidth(), innerCanvas.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        innerCanvas.print((Graphics)graphics2D);
        return bufferedImage.getScaledInstance(300, 300, 1);
    }

    public String[] getSelectedOntologyNodes() {
        this.myCurrentNetwork = Cytoscape.getCurrentNetwork();
        Set set = this.myCurrentNetwork.getFlaggedNodes();
        ArrayList arrayList = new ArrayList();
        for (CyNode cyNode : set) {
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void makeNewPanel(String string) {
        String string2 = string + " browser " + currentID;
        ++currentID;
        this.myCurrentNetwork = Cytoscape.createNetwork((String)string2);
        this.myCurrentNetworkView = Cytoscape.createNetworkView((CyNetwork)this.myCurrentNetwork);
        this.networkType.put(string2, string);
        this.myCurrentNetworkView.addNodeContextMenuListener((NodeContextMenuListener)this.menuListener);
        this.myCurrentNetworkView.addEdgeContextMenuListener((EdgeContextMenuListener)this.menuListener);
    }

    public void setEditable() {
        String string = this.myCurrentNetwork.getTitle();
        if (string == null) {
            return;
        }
        if (!this.isEditable.contains(string)) {
            this.isEditable.add(string);
        }
    }

    public String getCurrentNetworkType() {
        return (String)this.networkType.get(this.myCurrentNetwork.getTitle());
    }

    public void searchNode(String string) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        Iterator iterator = this.myCurrentNetwork.nodesIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string2 = cyAttributes.getStringAttribute(node.getIdentifier(), "URI");
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            this.myCurrentNetwork.setFlagged(node, true);
        }
    }

    public CyNode getNodeWithURI(String string) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyNode cyNode = null;
        Iterator iterator = this.myCurrentNetwork.nodesIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string2 = cyAttributes.getStringAttribute(node.getIdentifier(), "URI");
            if (string2 == null || cyAttributes.getStringAttribute(node.getIdentifier(), "HACK") != null || !string2.equalsIgnoreCase(string)) continue;
            return (CyNode)node;
        }
        return cyNode;
    }

    private void checkGenericType() {
        if ((String)this.networkType.get(this.myCurrentNetwork.getTitle()) == null) {
            this.networkType.put(this.myCurrentNetwork.getTitle(), "GENERIC");
            System.out.println("Made generic");
        }
    }

    public String getNodeAttributeValueByURI(String string, String string2) {
        System.out.println("Request for attribute " + string2 + " for Node " + string);
        System.out.println(this.myCurrentNetwork.getTitle());
        if (this.myCurrentNetwork == null) {
            System.out.println("mhhhh where ?");
            return null;
        }
        CyNode cyNode = this.getNodeWithURI(string);
        if (cyNode == null) {
            System.out.println("Node not found");
            return null;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.getStringAttribute(cyNode.getIdentifier(), string2);
    }

    public String getEdgeAttributeValueByURI(String string, String string2, String string3) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        System.out.println("Request for attribute " + string3 + " for Edge " + string + "->" + string2);
        if (this.myCurrentNetwork == null) {
            System.out.println("mhhhh where ?");
            return null;
        }
        Object var6_6 = null;
        int[] nArray = this.myCurrentNetwork.getEdgeIndicesArray();
        for (int i = 0; i < nArray.length; ++i) {
            Edge edge = this.myCurrentNetwork.getEdge(nArray[i]);
            String string4 = cyAttributes.getStringAttribute(edge.getSource().getIdentifier(), "URI");
            String string5 = cyAttributes.getStringAttribute(edge.getTarget().getIdentifier(), "URI");
            if (string4 == null || string5 == null) continue;
            if (cyAttributes2.getStringAttribute(edge.getIdentifier(), "HACK") == null) {
                // empty if block
            }
            return cyAttributes2.getStringAttribute(edge.getIdentifier(), string3);
        }
        return null;
    }

    public int getNodeCount() {
        if (this.myCurrentNetwork == null) {
            System.out.println("mhhhh where ?");
            return 0;
        }
        return this.myCurrentNetwork.getNodeCount();
    }

    public ExpressionData getExpressionData() {
        return Cytoscape.getExpressionData();
    }

    public void addSelectedSetOfNodes(AbstractQueryResultTable abstractQueryResultTable, int[][] nArray) {
        if (!this.hasGraph()) {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        System.out.println("Plotting " + nArray.length + " to " + this.myCurrentNetwork.getTitle());
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i][0];
            int n2 = nArray[i][1];
            if (abstractQueryResultTable.isURI(n, n2)) {
                this.addSimpleURI(abstractQueryResultTable.getURI(n, n2), abstractQueryResultTable.getNamespace(n, n2), abstractQueryResultTable.getLabel(n, n2));
            }
            if (abstractQueryResultTable.isLiteral(n, n2)) {
                // empty if block
            }
            if (!abstractQueryResultTable.isBlank(n, n2)) continue;
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public CyNode addSimpleURI(String string, String string2, String string3) {
        KnowledgeWrapper knowledgeWrapper = RDFScape.getKnowledge();
        String string4 = string;
        if (this.commonMemory.splitEnabled && this.uri2Split.contains(string)) {
            string4 = string + nodeIDCounter++;
        }
        CyNode cyNode = Cytoscape.getCyNode((String)string4, (boolean)true);
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "URI");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "URI", string);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", string3);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(this.commonMemory.getNamespaceColor(string2)));
        if (this.commonMemory.collapseDataTypes && KnowledgeWrapper.hasGraphAccessSupport(knowledgeWrapper)) {
            String[][] stringArray = ((GraphQueryAnswerer)((Object)knowledgeWrapper)).getDatatypeAttributeBox(string);
            for (int i = 0; i < stringArray.length; ++i) {
                cyAttributes.setAttribute(cyNode.getIdentifier(), stringArray[i][0], stringArray[i][1]);
            }
        }
        this.myCurrentNetwork.addNode((Node)cyNode);
        this.commonMemory.registerURINamespace(string, string2);
        this.commonMemory.registerURICytoNode(string, cyNode);
        this.commonMemory.registerURILabel(string, string3);
        return cyNode;
    }

    public CyNode addSimpleLiteral(String string, String string2, String string3, Object object) {
        CyNode cyNode = Cytoscape.getCyNode((String)(string + "^^" + string2), (boolean)true);
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "LITERAL");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "DATATYPE", string2);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", string);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", string3);
        cyAttributes.setAttribute(cyNode.getIdentifier(), "VALUE", string);
        this.myCurrentNetwork.addNode((Node)cyNode);
        this.commonMemory.registerLiteralCyNode(object, cyNode);
        this.commonMemory.registerLiteralNode2Label(object, string);
        if (string2 != null) {
            this.commonMemory.registerDatatypeURI2Literal(string2, object);
        }
        return cyNode;
    }

    public CyNode addSimpleBlankNode(Object object) {
        System.out.println("Adding blank node " + object.toString());
        boolean bl = false;
        System.out.println("Network : " + this.myCurrentNetwork);
        CyNode cyNode = Cytoscape.getCyNode((String)object.toString(), (boolean)true);
        System.out.println(cyNode);
        System.out.println(cyNode.getIdentifier());
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        cyAttributes.setAttribute(cyNode.getIdentifier(), "TYPE", "BLANK");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "LABEL", "B");
        cyAttributes.setAttribute(cyNode.getIdentifier(), "COLOR", "LIGHT_GRAY");
        this.myCurrentNetwork.addNode((Node)cyNode);
        this.commonMemory.registerBNodeCyNode(object, cyNode);
        return cyNode;
    }

    public CyNode[] addSplittedURI() {
        return null;
    }

    public CyNode searchNodeByURI(String string) {
        return null;
    }

    public void updateView() {
        if (this.myCurrentNetworkView != null) {
            this.myCurrentNetworkView.redrawGraph(true, false);
            this.myCurrentNetworkView.fitContent();
            this.myCurrentNetworkView.updateView();
        }
    }

    public void updateNamespaceView(String string) {
        int n;
        System.out.println("Repainting after change in ns: " + string);
        if (this.myCurrentNetworkView == null) {
            return;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        Color color = this.commonMemory.getNamespaceColor(string);
        CyNode[] cyNodeArray = this.commonMemory.getNamespaceCyNodes(string);
        for (n = 0; n < cyNodeArray.length; ++n) {
            if (cyAttributes.hasAttribute(cyNodeArray[n].getIdentifier(), "VAR")) continue;
            cyAttributes.setAttribute(cyNodeArray[n].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        cyNodeArray = this.commonMemory.getCyNodesForLiteralDatatypeURINamespace(string);
        for (n = 0; n < cyNodeArray.length; ++n) {
            if (cyAttributes.hasAttribute(cyNodeArray[n].getIdentifier(), "VAR")) continue;
            cyAttributes.setAttribute(cyNodeArray[n].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        CyEdge[] cyEdgeArray = this.commonMemory.getNamespaceCyEdges(string);
        for (int i = 0; i < cyEdgeArray.length; ++i) {
            if (cyAttributes2.hasAttribute(cyEdgeArray[i].getIdentifier(), "VAR")) continue;
            cyAttributes2.setAttribute(cyEdgeArray[i].getIdentifier(), "COLOR", DefaultSettings.translateColor2String(color));
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public boolean canCollapseDatatypes() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledge());
    }

    public boolean canExtend() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledge());
    }

    public void addIncomingEdge(CyNode cyNode, AbstractQueryResultTable abstractQueryResultTable, int n, CommonMemory commonMemory) {
        CyNode cyNode2;
        if (abstractQueryResultTable.isURI(n, 0)) {
            cyNode2 = this.addSimpleURI(abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0));
            this.addSimpleEdge(cyNode2, abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
        }
        if (abstractQueryResultTable.isLiteral(n, 0)) {
            cyNode2 = this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, 0), abstractQueryResultTable.getDatatypeType(n, 0), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, 0)), abstractQueryResultTable.getValueAt(n, 0));
            this.addSimpleEdge(cyNode2, abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
        }
        if (abstractQueryResultTable.isBlank(n, 0)) {
            cyNode2 = this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, 0));
            this.addSimpleEdge(cyNode2, abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1), cyNode, commonMemory);
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public void addOutgoingEdge(CyNode cyNode, AbstractQueryResultTable abstractQueryResultTable, int n, CommonMemory commonMemory) {
        CyNode cyNode2 = null;
        CyEdge cyEdge = null;
        if (abstractQueryResultTable.isURI(n, 1)) {
            cyNode2 = this.addSimpleURI(abstractQueryResultTable.getURI(n, 1), abstractQueryResultTable.getNamespace(n, 1), abstractQueryResultTable.getLabel(n, 1));
            cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNode2, commonMemory);
        }
        if (abstractQueryResultTable.isLiteral(n, 1)) {
            cyNode2 = this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, 1), abstractQueryResultTable.getDatatypeType(n, 1), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, 1)), abstractQueryResultTable.getValueAt(n, 1));
            cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNode2, commonMemory);
        }
        if (abstractQueryResultTable.isBlank(n, 1)) {
            cyNode2 = this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, 1));
            cyEdge = this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(n, 0), abstractQueryResultTable.getNamespace(n, 0), abstractQueryResultTable.getLabel(n, 0), cyNode2, commonMemory);
        }
        System.out.println("Adding outgoing edge");
        this.myCurrentNetworkView.fitContent();
        CyNode[] cyNodeArray = null;
        CyEdge[] cyEdgeArray = null;
        cyNodeArray = new CyNode[]{cyNode};
        cyEdgeArray = new CyEdge[]{};
        String string = CytoscapeInit.getProperties().getProperty("layout.default");
        System.out.println("Default layout seems to be: " + string);
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    private CyEdge addSimpleEdge(CyNode cyNode, String string, String string2, String string3, CyNode cyNode2, CommonMemory commonMemory) {
        CyEdge cyEdge = Cytoscape.getCyEdge((String)cyNode.getIdentifier(), (String)string, (String)cyNode2.getIdentifier(), (String)"_concept_");
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        System.out.println("Adding edge with the following attributes:\nCOLOR " + DefaultSettings.translateColor2String(commonMemory.getNamespaceColor(string2)) + "\n" + "URI " + string + "\n" + "LABEL " + string3 + "\n");
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(commonMemory.getNamespaceColor(string2)));
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "URI", string);
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "LABEL", string3);
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "TYPE", "PROPERTY");
        this.myCurrentNetwork.addEdge((Edge)cyEdge);
        this.commonMemory.registerURICytoEdge(string, cyEdge);
        this.commonMemory.registerURILabel(string, string3);
        return cyEdge;
    }

    public String[][] getTripleWithVariablesArrayList() {
        Object object;
        if (this.myCurrentNetwork.getTitle() == null) {
            return new String[0][3];
        }
        this.tempFilterConditions = new ArrayList();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Iterator iterator = this.myCurrentNetwork.edgesIterator();
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        while (iterator.hasNext()) {
            String[] stringArray;
            Object object2;
            Object object3;
            object = (Edge)iterator.next();
            String[] stringArray2 = object.getSource();
            Node node = object.getTarget();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (cyAttributes.hasAttribute(stringArray2.getIdentifier(), "VAR")) {
                string = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "VAR");
                if (cyAttributes.hasAttribute(stringArray2.getIdentifier(), "FILTER")) {
                    object3 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "FILTER");
                    object2 = new String[]{string, object3, "F"};
                    this.tempFilterConditions.add(object2);
                }
            } else {
                object3 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "TYPE");
                if (object3.equalsIgnoreCase("BLANK")) {
                    string = "?b" + bNodeCounter++;
                }
                if (object3.equalsIgnoreCase("LITERAL")) {
                    object2 = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "VALUE");
                    string = "?l" + literalNodeCounter++;
                    stringArray = new String[]{string, object2, "P"};
                    this.tempFilterConditions.add(stringArray);
                }
                if (object3.equalsIgnoreCase("URI")) {
                    string = cyAttributes.getStringAttribute(stringArray2.getIdentifier(), "URI");
                }
            }
            string2 = cyAttributes2.hasAttribute(object.getIdentifier(), "VAR") ? cyAttributes2.getStringAttribute(object.getIdentifier(), "VAR") : cyAttributes2.getStringAttribute(object.getIdentifier(), "URI");
            if (cyAttributes.hasAttribute(node.getIdentifier(), "VAR")) {
                string3 = cyAttributes.getStringAttribute(node.getIdentifier(), "VAR");
                if (cyAttributes.hasAttribute(node.getIdentifier(), "FILTER")) {
                    object3 = cyAttributes.getStringAttribute(node.getIdentifier(), "FILTER");
                    object2 = new String[]{string3, object3, "F"};
                    this.tempFilterConditions.add(object2);
                }
            } else {
                object3 = cyAttributes.getStringAttribute(node.getIdentifier(), "TYPE");
                if (object3.equalsIgnoreCase("BLANK")) {
                    string3 = "?b" + bNodeCounter++;
                }
                if (object3.equalsIgnoreCase("LITERAL")) {
                    object2 = cyAttributes.getStringAttribute(node.getIdentifier(), "VALUE");
                    string3 = "?l" + literalNodeCounter++;
                    stringArray = new String[]{string3, object2, "P"};
                    this.tempFilterConditions.add(stringArray);
                }
                if (object3.equalsIgnoreCase("URI")) {
                    string3 = cyAttributes.getStringAttribute(node.getIdentifier(), "URI");
                }
            }
            object3 = new String[]{string, string2, string3};
            System.out.println("Pattern: " + string + "---" + string2 + "---" + string3);
            arrayList.add((String[])object3);
        }
        System.out.println("Filters: ");
        for (String[] stringArray2 : this.tempFilterConditions) {
            System.out.println(stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2]);
        }
        object = new String[0][3];
        return (String[][])arrayList.toArray((T[])object);
    }

    public String[][] getFilterConditionsArray() {
        String[][] stringArray = new String[0][3];
        if (this.tempFilterConditions.size() == 0) {
            return stringArray;
        }
        return (String[][])this.tempFilterConditions.toArray((T[])stringArray);
    }

    public void searchURIs(AbstractQueryResultTable abstractQueryResultTable) {
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (int j = 0; j < abstractQueryResultTable.getColumnCount(); ++j) {
                if (!abstractQueryResultTable.isURI(i, j)) continue;
                CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(abstractQueryResultTable.getURI(i, j));
                for (int k = 0; k < cyNodeArray.length; ++k) {
                    this.myCurrentNetwork.setFlagged((Node)cyNodeArray[k], true);
                }
            }
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public void addURIs(AbstractQueryResultTable abstractQueryResultTable) {
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (int j = 0; j < abstractQueryResultTable.getColumnCount(); ++j) {
                if (!abstractQueryResultTable.isURI(i, j)) continue;
                this.addSimpleURI(abstractQueryResultTable.getURI(i, j), abstractQueryResultTable.getNamespace(i, j), abstractQueryResultTable.getLabel(i, j));
            }
        }
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    public void searchPattern(AbstractQueryResultTable abstractQueryResultTable) {
        if (this.myCurrentNetwork.getTitle() == null || this.myCurrentNetwork.getTitle() == "0") {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            CyNode[] cyNodeArray = this.searchGenericNodeFromTable(abstractQueryResultTable, i, 0);
            CyNode[] cyNodeArray2 = this.searchGenericNodeFromTable(abstractQueryResultTable, i, 2);
            CyEdge[] cyEdgeArray = this.commonMemory.getCyEdgesFromURI(abstractQueryResultTable.getURI(i, 1));
            for (int j = 0; j < cyEdgeArray.length; ++j) {
                int n;
                System.out.println("Checking edge " + j);
                CyNode cyNode = (CyNode)cyEdgeArray[j].getSource();
                CyNode cyNode2 = (CyNode)cyEdgeArray[j].getTarget();
                boolean bl = false;
                boolean bl2 = false;
                for (n = 0; n < cyNodeArray.length; ++n) {
                    if (cyNodeArray[n] != cyNode) continue;
                    bl = true;
                    break;
                }
                for (n = 0; n < cyNodeArray2.length; ++n) {
                    if (cyNodeArray2[n] != cyNode2) continue;
                    bl2 = true;
                    break;
                }
                if (!bl || !bl2) continue;
                this.myCurrentNetwork.setFlagged((Edge)cyEdgeArray[j], bl && bl2);
            }
        }
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.updateView();
    }

    public void addPattern(AbstractQueryResultTable abstractQueryResultTable) {
        if (this.myCurrentNetwork.getTitle() == null || this.myCurrentNetwork.getTitle() == "0") {
            RDFScape.warn("No graph selected.\nPlease create a graph first.");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            CyNode cyNode = null;
            CyNode cyNode2 = null;
            cyNode = this.addGenericNodeFromTable(abstractQueryResultTable, i, 0);
            cyNode2 = this.addGenericNodeFromTable(abstractQueryResultTable, i, 2);
            this.addSimpleEdge(cyNode, abstractQueryResultTable.getURI(i, 1), abstractQueryResultTable.getNamespace(i, 1), abstractQueryResultTable.getLabel(i, 1), cyNode2, this.commonMemory);
        }
        this.layoutAll();
        this.myCurrentNetworkView.redrawGraph(true, false);
        this.myCurrentNetworkView.fitContent();
        this.myCurrentNetworkView.updateView();
    }

    private CyNode addGenericNodeFromTable(AbstractQueryResultTable abstractQueryResultTable, int n, int n2) {
        if (abstractQueryResultTable.isURI(n, n2)) {
            return this.addSimpleURI(abstractQueryResultTable.getURI(n, n2), abstractQueryResultTable.getNamespace(n, n2), abstractQueryResultTable.getLabel(n, n2));
        }
        if (abstractQueryResultTable.isLiteral(n, n2)) {
            return this.addSimpleLiteral(abstractQueryResultTable.getDatatypeValue(n, n2), abstractQueryResultTable.getDatatypeType(n, n2), DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n, n2)), abstractQueryResultTable.getValueAt(n, n2));
        }
        if (abstractQueryResultTable.isBlank(n, n2)) {
            return this.addSimpleBlankNode(abstractQueryResultTable.getValueAt(n, n2));
        }
        return null;
    }

    private CyNode[] searchGenericNodeFromTable(AbstractQueryResultTable abstractQueryResultTable, int n, int n2) {
        if (abstractQueryResultTable.isURI(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(abstractQueryResultTable.getURI(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    this.myCurrentNetwork.setFlagged((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        if (abstractQueryResultTable.isLiteral(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodeForLiteralNode(abstractQueryResultTable.getValueAt(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    this.myCurrentNetwork.setFlagged((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        if (abstractQueryResultTable.isBlank(n, n2)) {
            CyNode[] cyNodeArray = this.commonMemory.getCyNodesForBNode(abstractQueryResultTable.getValueAt(n, n2));
            if (cyNodeArray != null) {
                for (int i = 0; i < cyNodeArray.length; ++i) {
                    this.myCurrentNetwork.setFlagged((Node)cyNodeArray[i], true);
                }
            }
            return cyNodeArray;
        }
        return new CyNode[0];
    }

    public void updateURILabel(String string) {
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyNode[] cyNodeArray = this.commonMemory.getCyNodesForURI(string);
        for (int i = 0; i < cyNodeArray.length; ++i) {
            String string2 = this.commonMemory.getLabelForURI(string);
            if (string2 == null) continue;
            cyAttributes.setAttribute(cyNodeArray[i].getIdentifier(), "LABEL", string2);
        }
    }

    public void addSplitConditions(AbstractQueryResultTable abstractQueryResultTable) {
        System.out.println("Split!");
        if (abstractQueryResultTable.getColumnCount() != 1) {
            System.out.println("I want only uris!");
            return;
        }
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            if (!abstractQueryResultTable.isURI(i, 0)) continue;
            this.uri2Split.add(abstractQueryResultTable.getURI(i, 0));
        }
    }

    public void restoreSplitConditions() {
        this.uri2Split = new HashSet();
    }

    public int[] mapNodes(Hashtable hashtable) {
        Iterator iterator;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        int[] nArray = new int[]{0, 0};
        if (this.myCurrentNetwork == null) {
            return nArray;
        }
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        CyAttributes cyAttributes2 = Cytoscape.getEdgeAttributes();
        Iterator iterator2 = this.myCurrentNetwork.nodesIterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            String string;
            System.out.print("Node: " + n2++ + " ");
            iterator = (CyNode)iterator2.next();
            System.out.println(iterator.getIdentifier());
            if (cyAttributes.hasAttribute(iterator.getIdentifier(), "URI")) {
                string = cyAttributes.getStringAttribute(iterator.getIdentifier(), "URI");
                ++n;
                hashSet.add(string);
                this.extractNode((CyNode)iterator, string, cyAttributes);
                continue;
            }
            string = (String)hashtable.get(iterator.getIdentifier());
            System.out.println(cyAttributes.getStringAttribute(iterator.getIdentifier(), "ID") + "->" + string);
            if (string == null) continue;
            ++n;
            hashSet.add(string);
            this.extractNode((CyNode)iterator, string, cyAttributes);
        }
        iterator = this.myCurrentNetwork.edgesIterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string;
            CyEdge cyEdge = (CyEdge)iterator.next();
            if (cyAttributes2.hasAttribute(cyEdge.getIdentifier(), "URI")) {
                string = cyAttributes2.getStringAttribute(cyEdge.getIdentifier(), "URI");
                this.extractEdge(cyEdge, string, cyAttributes2);
                continue;
            }
            string = (String)hashtable.get(cyEdge.getIdentifier());
            if (string == null) continue;
            this.extractEdge(cyEdge, string, cyAttributes2);
        }
        this.updateView();
        nArray[0] = n;
        nArray[1] = hashSet.size();
        System.out.println("Nodes matched: " + n);
        System.out.println("URIs resolved: " + hashSet.size());
        RDFScape.getKnowledge().touch();
        return nArray;
    }

    private void extractNode(CyNode cyNode, String string, CyAttributes cyAttributes) {
        this.commonMemory.registerURICytoNode(string, cyNode);
        String string2 = string;
        if (KnowledgeWrapper.hasGraphAccessSupport(RDFScape.getKnowledge()) && cyAttributes.hasAttribute(cyNode.getIdentifier(), "canonicalName")) {
            String string3 = cyAttributes.getStringAttribute(cyNode.getIdentifier(), "canonicalName");
            ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).addDataStatement(string, "http://www.w3.org/2000/01/rdf-schema#label", string3);
            string2 = this.commonMemory.showRDFSLabels ? ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).getRDFLabelForURI(string) : ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).getShortLabelForURI(string);
        }
        this.commonMemory.registerURILabel(string, string2);
    }

    private void extractEdge(CyEdge cyEdge, String string, CyAttributes cyAttributes) {
        this.commonMemory.registerURICytoEdge(string, cyEdge);
        String string2 = string;
        if (KnowledgeWrapper.hasGraphAccessSupport(RDFScape.getKnowledge()) && cyAttributes.hasAttribute(cyEdge.getIdentifier(), "canonicalName")) {
            String string3 = cyAttributes.getStringAttribute(cyEdge.getIdentifier(), "canonicalName");
            ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).addDataStatement(string, "http://www.w3.org/2000/01/rdf-schema#label", string3);
            string2 = this.commonMemory.showRDFSLabels ? ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).getRDFLabelForURI(string) : ((GraphQueryAnswerer)((Object)RDFScape.getKnowledge())).getShortLabelForURI(string);
        }
        this.commonMemory.registerURILabel(string, string2);
    }

    public boolean hasGraph() {
        return this.myCurrentNetwork.getTitle() != null && this.myCurrentNetwork.getTitle() != "0";
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.myCurrentNetworkView;
    }

    public boolean isEditable() {
        String string = this.myCurrentNetwork.getTitle();
        if (string == null) {
            return false;
        }
        return this.isEditable.contains(string);
    }

    public boolean isVariable(NodeView nodeView) {
        CyNode cyNode = (CyNode)nodeView.getNode();
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        return cyAttributes.hasAttribute(cyNode.getIdentifier(), "VAR");
    }

    public boolean isVariable(EdgeView edgeView) {
        CyEdge cyEdge = (CyEdge)edgeView.getEdge();
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        return cyAttributes.hasAttribute(cyEdge.getIdentifier(), "VAR");
    }

    public void layoutAll() {
        JMenu jMenu = Cytoscape.getDesktop().getCyMenus().getLayoutMenu();
        MenuElement[] menuElementArray = jMenu.getSubElements();
        MenuElement[] menuElementArray2 = ((JPopupMenu)menuElementArray[0]).getSubElements();
        JMenuItem jMenuItem = null;
        for (int i = 0; i < menuElementArray2.length && !(jMenuItem = (JMenuItem)menuElementArray2[i]).getText().equals("yFiles"); ++i) {
        }
        menuElementArray = jMenuItem.getSubElements();
        menuElementArray2 = ((JPopupMenu)menuElementArray[0]).getSubElements();
        AbstractButton abstractButton = null;
        for (int i = 0; i < menuElementArray2.length && !(abstractButton = (JMenuItem)menuElementArray2[i]).getText().equals("Circular"); ++i) {
        }
        abstractButton.doClick();
    }
}

