/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.knowledge;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RichResource;
import fr.pasteur.sysbio.rdfscape.knowledge.InfRuleObject;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.ClassQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.SPAQRLQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.SPQRLQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.StringQueryEngine;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaWrapper
extends KnowledgeWrapper
implements RDQLQueryAnswerer,
GraphQueryAnswerer,
SPAQRLQueryAnswerer {
    private Model myBasicKnowledge = null;
    private OntModel myPreProcessedKnowledge = null;
    private OntModel myOntoKnowledge = null;
    private Model myKnowledge = null;
    private ArrayList preRuleList = null;
    private ArrayList postRuleList = null;
    private int validStatus;
    private int status;
    private int targetStatus;
    private String[][] ruleOptions = new String[][]{{"PRE", "POST"}};
    private String[] ruleDefaultOptions = new String[]{"POST"};
    private String[] ruleOptionNames = new String[]{"STAGE"};
    private String[][] options = new String[][]{{"None", "RDFS-1", "RDFS-2", "OWL-low", "OWL-high", "Pellet", "DIG:8080", "DIG:Ask"}};
    private String[] defaultOptions = new String[]{"None"};
    private String[] paramNames = new String[]{"Level"};
    private String jenaReasoningLevel = this.defaultOptions[0];
    private OntModelSpec mySpec;

    public JenaWrapper() throws Exception {
        System.out.println("\tStarring: Jena Wrapper");
        this.initialize();
        System.out.println("\t          - ready");
    }

    public void initialize() {
        this.myBasicKnowledge = ModelFactory.createDefaultModel();
        this.preRuleList = new ArrayList();
        this.postRuleList = new ArrayList();
        this.status = 0;
        this.validStatus = 0;
        this.targetStatus = 3;
    }

    public void reset() {
        this.myBasicKnowledge.removeAll();
        this.preRuleList = new ArrayList();
        this.postRuleList = new ArrayList();
        this.status = 0;
        this.validStatus = 0;
        this.targetStatus = 3;
        System.out.println("After reset mu basic knowldge contains " + this.myBasicKnowledge.size() + " sharp!");
    }

    public String[][] getRuleOptions() {
        return this.ruleOptions;
    }

    public String[] getRuleOptionDefaultValues() {
        return this.ruleDefaultOptions;
    }

    public String[] getRuleOptionsNames() {
        return this.ruleOptionNames;
    }

    public String[][] getReasonerOptions() {
        return this.options;
    }

    public String[] getReasonerOptionNames() {
        return this.paramNames;
    }

    public String[] getReasonerOptionsDefaultValues() {
        return this.defaultOptions;
    }

    public String[] getReasonerActualOptions() {
        String[] stringArray = new String[2];
        stringArray[0] = this.jenaReasoningLevel;
        return stringArray;
    }

    public boolean canAddontologies() {
        return true;
    }

    public boolean canAddRules() {
        return true;
    }

    public String addOntology(String string) {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        String string2 = null;
        Model model = ModelFactory.createDefaultModel();
        try {
            model.read(string);
            string2 = new Long(model.size()).toString();
            this.myBasicKnowledge.add(model);
            System.out.println("My basic knowledge gets to..." + this.myBasicKnowledge.size() + " sharp!");
            Map map = model.getNsPrefixMap();
            Set set = map.keySet();
            for (String string3 : set) {
                String string4 = (String)map.get(string3);
                System.out.println(string3 + " : " + string4);
                commonMemory.registerNameSpace(string4);
                if (commonMemory.getPrefixFromNs(string4) != null) continue;
                commonMemory.registerPrefix(string4, string3);
            }
            commonMemory.touch();
            if (this.status < 1) {
                this.status = 1;
            }
            this.validStatus = 0;
            if (this.targetStatus < 1) {
                this.targetStatus = 1;
            }
            System.out.println("JenaWrapperStatus: S:" + this.status + " V:" + this.validStatus + " T: " + this.targetStatus);
        }
        catch (Exception exception) {
            System.out.println("Problem while adding ontology");
            exception.printStackTrace();
        }
        System.out.println("Mu knowledge get to " + this.myBasicKnowledge.size() + " statements");
        return string2;
    }

    public boolean addRuleSet(ArrayList arrayList) {
        InfRuleObject infRuleObject;
        ArrayList<InfRuleObject> arrayList2 = new ArrayList<InfRuleObject>();
        ArrayList<InfRuleObject> arrayList3 = new ArrayList<InfRuleObject>();
        for (InfRuleObject infRuleObject2 : arrayList) {
            if (!infRuleObject2.isActive()) continue;
            if (infRuleObject2.getParam("STAGE") == null) {
                System.out.println("JenaWrapper: rule " + infRuleObject2.getName() + " has no stage info");
                return false;
            }
            if (infRuleObject2.getParam("STAGE").equalsIgnoreCase("PRE")) {
                arrayList2.add(infRuleObject2);
                continue;
            }
            if (infRuleObject2.getParam("STAGE").equalsIgnoreCase("POST")) {
                arrayList3.add(infRuleObject2);
                continue;
            }
            System.out.println("JenaWrapper: rule " + infRuleObject2.getName() + " has invalid stage info :" + infRuleObject2.getParam("STAGE"));
            return false;
        }
        System.out.print(".");
        boolean bl = true;
        boolean bl2 = true;
        for (InfRuleObject infRuleObject3 : arrayList2) {
            if (!this.preRuleList.contains(infRuleObject3)) {
                bl = false;
                continue;
            }
            infRuleObject = (InfRuleObject)this.preRuleList.get(this.preRuleList.indexOf(infRuleObject3));
            if (!infRuleObject.getRule().equals(infRuleObject3.getRule())) {
                bl = false;
            }
            if (!infRuleObject.isActive() == infRuleObject3.isActive()) continue;
            bl = false;
        }
        System.out.print(".");
        for (InfRuleObject infRuleObject3 : this.preRuleList) {
            if (!arrayList2.contains(infRuleObject3)) {
                bl = false;
                continue;
            }
            infRuleObject = (InfRuleObject)arrayList2.get(arrayList2.indexOf(infRuleObject3));
            if (!infRuleObject.getRule().equals(infRuleObject3.getRule())) {
                bl = false;
            }
            if (!infRuleObject.isActive() == infRuleObject3.isActive()) continue;
            bl = false;
        }
        System.out.print(".");
        for (InfRuleObject infRuleObject3 : arrayList3) {
            if (!this.postRuleList.contains(infRuleObject3)) {
                bl2 = false;
                continue;
            }
            infRuleObject = (InfRuleObject)this.postRuleList.get(this.postRuleList.indexOf(infRuleObject3));
            if (!infRuleObject.getRule().equals(infRuleObject3.getRule())) {
                bl = false;
            }
            if (!infRuleObject.isActive() == infRuleObject3.isActive()) continue;
            bl = false;
        }
        System.out.print(".");
        for (InfRuleObject infRuleObject3 : this.postRuleList) {
            if (!arrayList3.contains(infRuleObject3)) {
                bl2 = false;
                continue;
            }
            infRuleObject = (InfRuleObject)arrayList3.get(arrayList3.indexOf(infRuleObject3));
            if (!infRuleObject.getRule().equals(infRuleObject3.getRule())) {
                bl = false;
            }
            if (!infRuleObject.isActive() == infRuleObject3.isActive()) continue;
            bl = false;
        }
        System.out.println(".");
        if (!bl) {
            this.preRuleList = arrayList2;
            if (this.validStatus > 1) {
                this.validStatus = 1;
            }
            if (this.targetStatus < 2) {
                this.targetStatus = 2;
            }
        }
        if (!bl2) {
            this.postRuleList = arrayList3;
            if (this.validStatus > 3) {
                this.validStatus = 3;
            }
            this.targetStatus = 4;
        }
        if (this.preRuleList.size() == 0 && this.targetStatus == 2) {
            this.targetStatus = 1;
        }
        if (this.postRuleList.size() == 0 && this.targetStatus == 4) {
            this.targetStatus = 3;
        }
        System.out.println("JenaWrapperStatus: S:" + this.status + " V:" + this.validStatus + "T: " + this.targetStatus);
        return true;
    }

    public RichResource getResourceHandler(String string) {
        return null;
    }

    public void setReasonerParameter(String string, String string2) {
        System.out.println("JenaWrapper: asked to set " + string + " as " + string2);
        if (string == null || string2 == null) {
            System.out.println("Missing something...");
            return;
        }
        if (string.equalsIgnoreCase("Level")) {
            boolean bl = false;
            for (int i = 0; i < this.options[0].length; ++i) {
                if (!string2.equalsIgnoreCase(this.options[0][i])) continue;
                bl = true;
            }
            if (bl) {
                this.switchJenaLevel(string2);
            } else {
                System.out.println("JenaWrapper: " + string2 + " is not a valid value for " + string);
            }
        } else {
            System.out.println("JenaWrapper: unkwown parameter " + string);
        }
    }

    private OntModelSpec getJenaMode() {
        if (this.jenaReasoningLevel.equalsIgnoreCase("None")) {
            System.out.println("r1");
            return OntModelSpec.OWL_MEM;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-1")) {
            System.out.println("r2");
            return OntModelSpec.RDFS_MEM_TRANS_INF;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-2")) {
            System.out.println("r3");
            return OntModelSpec.RDFS_MEM_RDFS_INF;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("OWL-low")) {
            System.out.println("r4");
            return OntModelSpec.OWL_MEM_MICRO_RULE_INF;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("OWL-high")) {
            System.out.println("r5");
            return OntModelSpec.OWL_MEM_MINI_RULE_INF;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("Pellet")) {
            System.out.println("r6");
            return PelletReasonerFactory.THE_SPEC;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("DIG:8080")) {
            System.out.println("r7");
            return OntModelSpec.OWL_DL_MEM;
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("DIG:Ask")) {
            System.out.println("r8");
            return OntModelSpec.OWL_DL_MEM;
        }
        System.out.println("No suitable spec found");
        return OntModelSpec.OWL_MEM;
    }

    private OntModelSpec getBaseModelSpec() {
        if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-1") || this.jenaReasoningLevel.equalsIgnoreCase("RDFS-2")) {
            return OntModelSpec.RDFS_MEM;
        }
        return OntModelSpec.OWL_MEM;
    }

    public void clear() {
        RDFScape.getCommonMemory().initialize();
    }

    public void touch() {
        System.out.println("Checking knowledge");
        System.out.println("JenaWrapperStatus: S:" + this.status + " V:" + this.validStatus + " T: " + this.targetStatus);
        System.out.println("Basic knowledge has " + this.myBasicKnowledge.size() + " known facts");
        if (this.myBasicKnowledge.size() < 10L) {
            System.out.println("Why not loading some ontology first ?");
        }
        if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-2") || this.jenaReasoningLevel.equalsIgnoreCase("OWL-low") || this.jenaReasoningLevel.equalsIgnoreCase("OWL-high")) {
            List list;
            System.out.println("Mhhh this is a rule based reasoner...");
            System.out.println("Going to hack it directly");
            String string = new String("");
            if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-2")) {
                string = this.makeRuleBlock("RDFS");
            }
            if (this.jenaReasoningLevel.equalsIgnoreCase("OWL-low")) {
                string = this.makeRuleBlock("OWLMicro");
            }
            if (this.jenaReasoningLevel.equalsIgnoreCase("OWL-high")) {
                string = this.makeRuleBlock("OWLMini");
            }
            try {
                list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
            }
            catch (Exception exception) {
                System.out.println("Parser Error :\n" + exception);
                return;
            }
            OntModelSpec ontModelSpec = this.getJenaMode();
            GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list, ontModelSpec.getReasonerFactory());
            ontModelSpec.setReasoner((Reasoner)genericRuleReasoner);
            this.myKnowledge = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
            this.myKnowledge.add(this.myBasicKnowledge);
            System.out.println("My knowledge get to a minimum of " + this.myKnowledge.size() + " statements");
        } else if (this.jenaReasoningLevel.equalsIgnoreCase("Pellet")) {
            System.out.println("You want a Pellet reasoner here...");
            this.myOntoKnowledge = ModelFactory.createOntologyModel((OntModelSpec)this.getJenaMode());
            this.myOntoKnowledge.add(this.myBasicKnowledge);
            this.myOntoKnowledge.prepare();
            if (this.preRuleList.size() + this.postRuleList.size() > 0) {
                List list;
                System.out.println("Let me see if I can add some support for your rules...(on top of this)");
                String string = this.makeRuleBlock(null);
                try {
                    list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
                }
                catch (Exception exception) {
                    System.out.println("Parser Error :\n" + exception);
                    return;
                }
                GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
                genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
                genericRuleReasoner.setOWLTranslation(false);
                genericRuleReasoner.setTransitiveClosureCaching(true);
                OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM;
                ontModelSpec.setReasoner((Reasoner)genericRuleReasoner);
                this.myKnowledge = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
                this.myKnowledge.add((Model)this.myOntoKnowledge);
            } else {
                this.myKnowledge = this.myOntoKnowledge;
            }
        } else if (this.jenaReasoningLevel.equalsIgnoreCase("RDFS-1")) {
            System.out.println("You want fast and cheap RDFS entailments...");
            this.myOntoKnowledge = ModelFactory.createOntologyModel((OntModelSpec)this.getJenaMode());
            this.myOntoKnowledge.add(this.myBasicKnowledge);
            this.myOntoKnowledge.prepare();
            if (this.preRuleList.size() + this.postRuleList.size() > 0) {
                List list;
                System.out.println("Let me see if I can add some support for your rules...(on top of this)");
                String string = this.makeRuleBlock(null);
                try {
                    list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
                }
                catch (Exception exception) {
                    System.out.println("Parser Error :\n" + exception);
                    return;
                }
                GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
                genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
                genericRuleReasoner.setOWLTranslation(false);
                genericRuleReasoner.setTransitiveClosureCaching(true);
                OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM;
                ontModelSpec.setReasoner((Reasoner)genericRuleReasoner);
                this.myKnowledge = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
                this.myKnowledge.add((Model)this.myOntoKnowledge);
            } else {
                this.myKnowledge = this.myOntoKnowledge;
            }
        } else if (this.jenaReasoningLevel.equalsIgnoreCase("None")) {
            List list;
            System.out.println("You want no entailments, maybe just rules...");
            System.out.println("Let me see if I can add some support for your rules...");
            String string = this.makeRuleBlock(null);
            try {
                list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
            }
            catch (Exception exception) {
                System.out.println("Parser Error :\n" + exception);
                return;
            }
            GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
            genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
            genericRuleReasoner.setOWLTranslation(false);
            genericRuleReasoner.setTransitiveClosureCaching(true);
            OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM;
            ontModelSpec.setReasoner((Reasoner)genericRuleReasoner);
            this.myKnowledge = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
            this.myKnowledge.add(this.myBasicKnowledge);
        }
    }

    private void makePreProcessedKnowledge() {
        List list;
        Object object2;
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        if (this.preRuleList.size() == 0) {
            this.myPreProcessedKnowledge = ModelFactory.createOntologyModel((OntModelSpec)this.getBaseModelSpec());
            this.myPreProcessedKnowledge.add(this.myBasicKnowledge);
            this.myPreProcessedKnowledge.prepare();
            this.myPreProcessedKnowledge.reset();
            this.myKnowledge = this.myPreProcessedKnowledge;
            this.status = 2;
            this.validStatus = 2;
            System.out.println("This was pretty easy...");
            System.out.println("My knowledge get to " + this.myKnowledge.size() + " statements");
            return;
        }
        String[] stringArray = commonMemory.getNamespaces();
        String string = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = commonMemory.getNamespacePrefix(stringArray[i]);
            if (object2 == null) continue;
            string = string.concat("@prefix " + (String)object2 + ": " + "<" + stringArray[i] + ">\n");
        }
        string = string.concat("\n\n");
        for (Object object2 : this.preRuleList) {
            if (!((InfRuleObject)object2).isActive()) continue;
            string = string.concat(((InfRuleObject)object2).getRule() + "\n\n");
        }
        System.out.println("Your rules...\n" + string);
        try {
            list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
        }
        catch (Exception exception) {
            System.out.println("Parser Error :\n" + exception);
            return;
        }
        System.out.println("My knowledge has " + this.myKnowledge.size() + " statements");
        System.out.println("A");
        object2 = this.getBaseModelSpec();
        System.out.println("B");
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
        genericRuleReasoner.setMode(GenericRuleReasoner.BACKWARD);
        genericRuleReasoner.setOWLTranslation(false);
        object2.setReasoner((Reasoner)genericRuleReasoner);
        System.out.println("C");
        object2.setReasoner((Reasoner)genericRuleReasoner);
        System.out.println("D");
        this.myPreProcessedKnowledge = ModelFactory.createOntologyModel((OntModelSpec)object2);
        this.myPreProcessedKnowledge.add(this.myBasicKnowledge);
        this.myPreProcessedKnowledge.reset();
        System.out.println("E");
        this.myKnowledge = this.myPreProcessedKnowledge;
        System.out.println("After Pre processing rules,  my knowledge get to a minimum of" + this.myKnowledge.size() + " statements");
        this.status = 2;
        this.validStatus = 2;
    }

    private void makeOntoKnowledge() {
        if (this.jenaReasoningLevel.equalsIgnoreCase("None")) {
            this.myOntoKnowledge = this.myPreProcessedKnowledge;
            this.myKnowledge = this.myOntoKnowledge;
            System.out.println("This was preatty easy...");
            this.status = 3;
            this.validStatus = 3;
            System.out.println("My knowledge get to " + this.myKnowledge.size() + " statements");
            return;
        }
        System.out.println("Making ontoknowledge: Level= " + this.jenaReasoningLevel + ";");
        String string = "http://localhost:8080";
        if (this.jenaReasoningLevel.equalsIgnoreCase("DIG:8080") || this.jenaReasoningLevel.equalsIgnoreCase("DIG:Ask")) {
            if (this.jenaReasoningLevel.equalsIgnoreCase("DIG:Ask") && (string = JOptionPane.showInputDialog("Plese specify reasoner URI")) == null) {
                string = "http://localhost:8080";
            }
            Model model = ModelFactory.createDefaultModel();
            Resource resource = model.createResource();
            resource.addProperty(ReasonerVocabulary.EXT_REASONER_URL, (RDFNode)model.createResource(string));
            DIGReasonerFactory dIGReasonerFactory = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
            DIGReasoner dIGReasoner = (DIGReasoner)dIGReasonerFactory.create(resource);
            OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
            ontModelSpec.setReasoner((Reasoner)dIGReasoner);
            this.myOntoKnowledge = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, null);
        } else {
            System.out.println("Jena mode : " + this.getJenaMode());
            this.myOntoKnowledge = ModelFactory.createOntologyModel((OntModelSpec)this.getJenaMode());
        }
        this.myOntoKnowledge.add((Model)this.myPreProcessedKnowledge);
        this.myOntoKnowledge.rebind();
        this.myOntoKnowledge.prepare();
        this.myKnowledge = this.myOntoKnowledge;
        this.status = 3;
        this.validStatus = 3;
        System.out.println("My knowledge get to " + this.myKnowledge.size() + " statements");
    }

    private void makePostProcessedKnowledge() {
        List list;
        Object object2;
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        if (this.postRuleList.size() == 0) {
            this.myKnowledge = this.myOntoKnowledge;
            this.status = 4;
            this.validStatus = 4;
            System.out.println("This was pretty easy...");
            System.out.println("My knowledge get to " + this.myKnowledge.size() + " statements");
            return;
        }
        String[] stringArray = commonMemory.getNamespaces();
        String string = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = commonMemory.getNamespacePrefix(stringArray[i]);
            if (object2 == null) continue;
            string = string.concat("@prefix " + (String)object2 + ": " + "<" + stringArray[i] + ">\n");
        }
        string = string.concat("\n\n");
        for (Object object2 : this.postRuleList) {
            if (!((InfRuleObject)object2).isActive()) continue;
            string = string.concat(((InfRuleObject)object2).getRule() + "\n\n");
        }
        System.out.println("Your rules...\n" + string);
        try {
            list = Rule.parseRules((Rule.Parser)Rule.rulesParserFromReader((BufferedReader)new BufferedReader(new StringReader(string))));
        }
        catch (Exception exception) {
            System.out.println("Parser Error :\n" + exception);
            return;
        }
        object2 = this.getJenaMode();
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list, object2.getReasonerFactory());
        object2.setReasoner((Reasoner)genericRuleReasoner);
        this.myKnowledge = ModelFactory.createOntologyModel((OntModelSpec)object2);
        this.myKnowledge.add((Model)this.myOntoKnowledge);
        System.out.println("My knowledge get to " + this.myKnowledge.size() + " statements");
        this.status = 4;
        this.validStatus = 4;
    }

    private void switchJenaLevel(String string) {
        if (string.equalsIgnoreCase(this.jenaReasoningLevel)) {
            return;
        }
        this.jenaReasoningLevel = string;
        if (this.validStatus > 2) {
            this.validStatus = 2;
        }
        if (this.targetStatus < 3) {
            this.targetStatus = 3;
        }
        System.out.println("JenaWrapperStatus: S:" + this.status + " V:" + this.validStatus + "T: " + this.targetStatus);
    }

    public String validateRule(String string) {
        Rule rule = null;
        try {
            rule = Rule.parseRule((String)string);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        if (!rule.isBackward()) {
            return "Backward rules only, please...";
        }
        return null;
    }

    public ArrayList getAvailableQueryManagers() {
        ArrayList<MyQueryEngine> arrayList = new ArrayList<MyQueryEngine>();
        try {
            arrayList.add(new RDQLQueryEngine());
            arrayList.add(new ClassQueryEngine());
            arrayList.add(new StringQueryEngine());
            arrayList.add(new SPQRLQueryEngine());
        }
        catch (Exception exception) {
            System.out.println("I got confused while setting up query facilities...");
        }
        return arrayList;
    }

    public AbstractQueryResultTable makeRDQLQuery(String string) {
        ResultSet resultSet = null;
        QueryExecution queryExecution = null;
        Query query = null;
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        Vector vector = new Vector();
        try {
            System.out.println(1);
            query = QueryFactory.create((String)string, (Syntax)Syntax.syntaxRDQL);
            queryExecution = QueryExecutionFactory.create((Query)query, (Model)this.myKnowledge);
            resultSet = queryExecution.execSelect();
        }
        catch (QueryException queryException) {
            RDFScape.warn(queryException.getMessage());
            return jenaQueryResultTable;
        }
        List list = query.getResultVars();
        int n = 0;
        while (resultSet.hasNext()) {
            QuerySolution querySolution = resultSet.nextSolution();
            int n2 = 0;
            for (String string2 : list) {
                RDFNode rDFNode = querySolution.get(string2);
                jenaQueryResultTable.addObject(rDFNode, n, n2);
                jenaQueryResultTable.addVar(string2, n2);
                ++n2;
            }
            ++n;
        }
        System.out.println("Result table: " + jenaQueryResultTable.getRowCount() + " x " + jenaQueryResultTable.getColumnCount());
        return jenaQueryResultTable;
    }

    public AbstractQueryResultTable getLeftOfNode(Object object) {
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        StmtIterator stmtIterator = this.myKnowledge.listStatements(null, null, (RDFNode)object);
        this.putStmtIteratorToTable(stmtIterator, jenaQueryResultTable, true, false);
        return jenaQueryResultTable;
    }

    public AbstractQueryResultTable getRightOfNode(Object object) {
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        RDFNode rDFNode = (RDFNode)object;
        if (rDFNode.isResource()) {
            StmtIterator stmtIterator = this.myKnowledge.listStatements((Resource)object, null, (RDFNode)null);
            this.putStmtIteratorToTable(stmtIterator, jenaQueryResultTable, false, true);
        }
        return jenaQueryResultTable;
    }

    private void putStmtIteratorToTable(StmtIterator stmtIterator, JenaQueryResultTable jenaQueryResultTable, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        if (!bl) {
            n3 = 0;
            n4 = 1;
        }
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            RDFNode rDFNode = statement.getObject();
            Property property = statement.getPredicate();
            if (bl) {
                jenaQueryResultTable.addObject(resource, n, n2);
            }
            jenaQueryResultTable.addObject(property, n, n3);
            if (bl2) {
                jenaQueryResultTable.addObject(rDFNode, n, n4);
            }
            ++n;
        }
    }

    public static String getNamespaceFromURI(String string) {
        Resource resource = ResourceFactory.createResource((String)string);
        return resource.getNameSpace();
    }

    public String getRDFLabelForURI(String string) {
        RDFNode rDFNode;
        Property property;
        Resource resource = ResourceFactory.createResource((String)string);
        NodeIterator nodeIterator = this.myKnowledge.listObjectsOfProperty(resource, property = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label"));
        if (nodeIterator.hasNext() && (rDFNode = nodeIterator.nextNode()).isLiteral()) {
            return ((Literal)rDFNode).getString();
        }
        return null;
    }

    public String getShortLabelForURI(String string) {
        Resource resource = ResourceFactory.createResource((String)string);
        String string2 = resource.getNameSpace();
        String string3 = resource.getLocalName();
        String string4 = RDFScape.getCommonMemory().getNamespacePrefix(string2);
        if (string4 != null && string3 != null) {
            return string4 + ":" + string3;
        }
        return null;
    }

    public String[][] getDatatypeAttributeBox(String string) {
        String[][] stringArray = new String[0][2];
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StmtIterator stmtIterator = this.myKnowledge.listStatements(ResourceFactory.createResource((String)string), null, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            if (!rDFNode.isLiteral()) continue;
            String string2 = statement.getPredicate().getURI();
            String string3 = ((Literal)statement.getObject()).getValue().toString();
            if (this.getRDFLabelForURI(string2) != null) {
                string2 = this.getRDFLabelForURI(string2);
            } else if (this.getShortLabelForURI(string2) != null) {
                string2 = this.getShortLabelForURI(string2);
            }
            String[] stringArray2 = new String[]{string2, string3};
            arrayList.add(stringArray2);
        }
        return (String[][])arrayList.toArray((T[])stringArray);
    }

    public String[] getClassURIList() {
        String[] stringArray = new String[]{};
        if (this.myKnowledge == null) {
            return stringArray;
        }
        System.out.println("+");
        ArrayList<String> arrayList = new ArrayList<String>();
        ExtendedIterator extendedIterator = ((OntModel)this.myKnowledge).listNamedClasses();
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            System.out.println("-->" + resource.getURI());
            arrayList.add(resource.getURI());
        }
        return arrayList.toArray(stringArray);
    }

    public AbstractQueryResultTable makeSPAQRLQuery(String string) {
        JenaQueryResultTable jenaQueryResultTable = new JenaQueryResultTable();
        if (this.myKnowledge == null) {
            return jenaQueryResultTable;
        }
        Query query = QueryFactory.create((String)string);
        QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)this.myKnowledge);
        ResultSet resultSet = null;
        try {
            resultSet = queryExecution.execSelect();
        }
        catch (QueryParseException queryParseException) {
            System.out.println("Problems in SPQRL query");
            RDFScape.warn(queryParseException.getMessage());
            queryParseException.printStackTrace();
            return jenaQueryResultTable;
        }
        if (resultSet != null) {
            List list = query.getResultVars();
            System.out.println("Vars # " + list.size());
            int n = 0;
            while (resultSet.hasNext()) {
                QuerySolution querySolution = (QuerySolution)resultSet.next();
                int n2 = 0;
                System.out.println("E");
                for (String string2 : list) {
                    RDFNode rDFNode = querySolution.get(string2);
                    jenaQueryResultTable.addObject(rDFNode, n, n2);
                    jenaQueryResultTable.addVar(string2, n2);
                    ++n2;
                }
                ++n;
            }
        }
        System.out.println("Result table: " + jenaQueryResultTable.getRowCount() + " x " + jenaQueryResultTable.getColumnCount());
        return jenaQueryResultTable;
    }

    public void addDataStatement(String string, String string2, String string3) {
        this.myBasicKnowledge.add(ResourceFactory.createResource((String)string), ResourceFactory.createProperty((String)string2), (RDFNode)ResourceFactory.createPlainLiteral((String)string3));
        this.validStatus = 1;
    }

    private String makeRuleBlock(String string) {
        String[] stringArray = RDFScape.getCommonMemory().getNamespaces();
        String string2 = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = RDFScape.getCommonMemory().getNamespacePrefix(stringArray[i]);
            if (object == null) continue;
            string2 = string2.concat("@prefix " + (String)object + ": " + "<" + stringArray[i] + ">\n");
        }
        if (string != null) {
            string2 = string2.concat("@include <" + string + ">\n");
        }
        string2 = string2.concat("\n\n");
        for (Object object : this.preRuleList) {
            if (!((InfRuleObject)object).isActive()) continue;
            string2 = string2.concat(((InfRuleObject)object).getRule() + "\n\n");
        }
        string2 = string2.concat("\n\n");
        for (Object object : this.postRuleList) {
            if (!((InfRuleObject)object).isActive()) continue;
            string2 = string2.concat(((InfRuleObject)object).getRule() + "\n\n");
        }
        System.out.println("Your rules...\n" + string2);
        return string2;
    }
}

